/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diameter;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.diameter.ObjectType;
import de.planetensuche.simulationen.diameter.PlanetCompareDto;
import de.planetensuche.simulationen.images.DrawImage;
import de.planetensuche.simulationen.images.DrawImageReaderUtil;
import de.planetensuche.simulationen.images.PlanetImageUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Optional;

public final class PlanetComparisionGui
extends Basisdialog {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final int screenWidth;
    private final int screenHeigth;
    private final Collection<PlanetCompareDto> data;
    private double firstDiameterInDJup;
    private double lastDiameterInDJup;
    private boolean endSimulation;

    public PlanetComparisionGui(Collection<PlanetCompareDto> collection) {
        super(BasisdialogId.SIMULATION_PLANET_VERGLEICH);
        this.data = collection;
        this.setTitle(this.getSprachcontainer().getString("sim_gui134"));
        this.setAlwaysOnTop(true);
        this.setBackground(new Color(0, 0, 0));
        this.setForeground(new Color(255, 255, 255));
        this.resizeToDesktopSize();
        this.screenWidth = this.getWidth();
        this.screenHeigth = this.getHeight();
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (!(keyEvent.getKeyCode() != 39 && keyEvent.getKeyCode() != 227 || PlanetComparisionGui.this.endSimulation)) {
                    PlanetComparisionGui.this.firstDiameterInDJup = PlanetComparisionGui.this.lastDiameterInDJup;
                    PlanetComparisionGui.this.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        try {
            graphics.setFont(new Font("Serif", 1, 14));
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.screenWidth, this.screenHeigth);
            graphics.setColor(Color.white);
            int n = 20;
            int n2 = this.screenHeigth / 2 - 100;
            int n3 = n2 + 50;
            for (PlanetCompareDto planetCompareDto : this.data) {
                Optional<Image> optional;
                double d = planetCompareDto.getDiameterInDJup();
                if (this.firstDiameterInDJup == 0.0) {
                    this.firstDiameterInDJup = d;
                }
                if (!(d >= this.firstDiameterInDJup)) continue;
                double d2 = d / this.firstDiameterInDJup;
                int n4 = (int)Math.round(16.0 * d2);
                if (n + n4 + 120 > this.screenWidth) {
                    optional = this.getSprachcontainer().getString("sim_m157");
                    this.logger.debug(optional);
                    graphics.drawString((String)((Object)optional), this.screenWidth / 3, this.getTopStartPixel() + 60);
                    return;
                }
                optional = this.getImageForObject(planetCompareDto);
                if (optional.isPresent()) {
                    graphics.drawImage((Image)optional.get(), n, n2 - n4, n4, n4, this.rootPane);
                } else {
                    graphics.drawString("?", n, n2);
                }
                int n5 = n + n4 / 2;
                graphics.drawLine(n5, n2 - n4 / 2, n5, n3 - 15);
                graphics.drawString(planetCompareDto.getName(), n5, n3);
                this.showPlanetDetails(d, graphics, n5, n3, planetCompareDto);
                if (planetCompareDto.getObjectType() == ObjectType.MOON) {
                    graphics.drawLine(n5, n2 - n4 - 50, n5, n2 - n4 / 2);
                    graphics.drawString(this.getSprachcontainer().getString("sim_m159"), n5, n2 - n4 - 65);
                } else if (planetCompareDto.getObjectType() == ObjectType.BROWN_DWARF) {
                    graphics.drawLine(n5, n2 - n4 - 50, n5, n2 - n4 / 2);
                    graphics.drawString(this.getSprachcontainer().getString("sim_m160"), n5, n2 - n4 - 65);
                }
                n = n + n4 + 50;
                if ((n3 += 105) >= this.screenHeigth - 105) {
                    n3 = n2 + 50;
                }
                this.lastDiameterInDJup = d;
            }
            graphics.drawString(this.getSprachcontainer().getString("sim_m156"), this.screenWidth / 3, this.getTopStartPixel() + 60);
            this.endSimulation = true;
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
        }
    }

    private void showPlanetDetails(double d, Graphics graphics, int n, int n2, PlanetCompareDto planetCompareDto) {
        if (d < 0.44665116669934735) {
            graphics.drawString(this.getSprachcontainer().toLocalisedDouble(d * 11.194418312950768) + " " + this.getSprachcontainer().getString("db_m459"), n, n2 + 15);
        } else {
            graphics.drawString(this.getSprachcontainer().toLocalisedDouble(d) + " " + this.getSprachcontainer().getString("db_m99"), n, n2 + 15);
        }
        long l = Math.round(d * 142984.0);
        graphics.drawString(this.getSprachcontainer().toLocalisedNumber(l) + " km", n, n2 + 30);
        if (planetCompareDto.getMassInJup() != null) {
            if (planetCompareDto.getMassInJup() < 0.03145866245392312) {
                graphics.drawString(this.getSprachcontainer().toLocalisedDouble(planetCompareDto.getMassInJup() * 317.87746903247404) + " " + this.getSprachcontainer().getString("db_m457"), n, n2 + 45);
            } else {
                graphics.drawString(this.getSprachcontainer().toLocalisedDouble(planetCompareDto.getMassInJup()) + " " + this.getSprachcontainer().getString("db_m102"), n, n2 + 45);
            }
        }
        if (planetCompareDto.getTemperatureInKelvin() != null) {
            double d2 = planetCompareDto.getTemperatureInKelvin() - 273.15;
            graphics.drawString(this.getSprachcontainer().toLocalisedDouble(d2) + " " + this.getSprachcontainer().getString("sim_m158"), n, n2 + (planetCompareDto.getMassInJup() != null ? 60 : 45));
        }
    }

    private Optional<Image> getImageForObject(PlanetCompareDto planetCompareDto) {
        return switch (planetCompareDto.getObjectType()) {
            case ObjectType.MOON -> DrawImageReaderUtil.read(DrawImage.MOON);
            case ObjectType.PLANET -> PlanetImageUtil.getImageForDensity(planetCompareDto.getDiameterInDJup(), planetCompareDto.getMassInJup());
            default -> DrawImageReaderUtil.read(DrawImage.GAS_PLANET);
        };
    }
}

