/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diameter;

import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.diameter.StarDto;
import de.planetensuche.simulationen.images.StarImageUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Optional;

public final class StarComparisionGui
extends Basisdialog {
    private final int screenWidth;
    private final int screenHeigth;
    private final Collection<StarDto> data;
    private double firstDiameterInDSun;
    private double lastDiameterInDSun;
    private boolean endSimulation;

    public StarComparisionGui(Collection<StarDto> collection) {
        super(BasisdialogId.SIMULATION_STERN_VERGLEICH);
        this.data = collection;
        this.setTitle(this.getSprachcontainer().getString("sim_gui132"));
        this.setAlwaysOnTop(true);
        this.setBackground(new Color(0, 0, 0));
        this.setForeground(new Color(255, 255, 255));
        this.resizeToDesktopSize();
        this.screenWidth = this.getWidth();
        this.screenHeigth = this.getHeight();
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (!(keyEvent.getKeyCode() != 39 && keyEvent.getKeyCode() != 227 || StarComparisionGui.this.endSimulation)) {
                    StarComparisionGui.this.firstDiameterInDSun = StarComparisionGui.this.lastDiameterInDSun;
                    StarComparisionGui.this.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        try {
            graphics.setFont(new Font("Serif", 1, 14));
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.screenWidth, this.screenHeigth);
            graphics.setColor(Color.white);
            int n = 20;
            int n2 = this.screenHeigth / 2;
            int n3 = n2 + 50;
            for (StarDto starDto : this.data) {
                Optional<Image> optional;
                double d = starDto.getDiameterInDSun();
                if (this.firstDiameterInDSun == 0.0) {
                    this.firstDiameterInDSun = d;
                }
                if (!(d >= this.firstDiameterInDSun)) continue;
                double d2 = d / this.firstDiameterInDSun;
                int n4 = (int)Math.round(16.0 * d2);
                if (n + n4 + 120 > this.screenWidth) {
                    optional = this.getSprachcontainer().getString("sim_m157");
                    graphics.drawString((String)((Object)optional), this.screenWidth / 3, this.getTopStartPixel() + 60);
                    return;
                }
                optional = StarImageUtil.getImageForSpType(starDto.getSptyp());
                if (optional.isPresent()) {
                    graphics.drawImage((Image)optional.get(), n, n2 - n4, n4, n4, this.rootPane);
                } else {
                    graphics.drawString("?", n, n2);
                }
                int n5 = n + n4 / 2;
                graphics.drawLine(n5, n2 - n4 / 2, n5, n3 - 15);
                graphics.drawString(starDto.getName(), n5, n3);
                graphics.drawString(this.getSprachcontainer().toLocalisedDouble(d) + " " + this.getSprachcontainer().getString("db_m98"), n5, n3 + 15);
                double d3 = 1392784.0;
                long l = Math.round(d * d3);
                graphics.drawString(this.getSprachcontainer().toLocalisedNumber(l) + " km", n5, n3 + 30);
                graphics.drawString(this.getSprachcontainer().getString("sim_m155") + " " + starDto.getConstellation(), n5, n3 + 45);
                n = n + n4 + 50;
                if ((n3 += 90) >= this.screenHeigth - 90) {
                    n3 = n2 + 50;
                }
                this.lastDiameterInDSun = d;
            }
            graphics.drawString(this.getSprachcontainer().getString("sim_m156"), this.screenWidth / 3, this.getTopStartPixel() + 60);
            this.endSimulation = true;
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
        }
    }
}

