/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diashow;

import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.diashow.Diashowthread;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public final class DiashowGui
extends Basisdialog {
    private final ISprachcontainer sprache;
    private int zaehler;
    private final Timer timer;
    private Dimension bildschirmgroesse;
    private JLabel jLabel;
    private JScrollPane jScrollPane1;

    public DiashowGui(ISprachcontainer iSprachcontainer) {
        super(BasisdialogId.SIMULATION_DIASHOW);
        this.initComponents();
        this.sprache = iSprachcontainer;
        this.zaehler = 0;
        this.setTitle("Diashow");
        this.bildschirmgroesse = Toolkit.getDefaultToolkit().getScreenSize();
        this.resizeToDesktopSize();
        this.setResizable(false);
        Object object = JOptionPane.showInputDialog(null, iSprachcontainer.getString("sim_m87"), iSprachcontainer.getString("sim_m87_titel"), 3, null, null, "2.0");
        double d = 2.0;
        try {
            if (object != null) {
                d = Double.parseDouble(object.toString().trim());
            }
        }
        catch (Exception exception) {
            d = 2.0;
        }
        long l = Math.round(d * 1000.0);
        JOptionPane.showMessageDialog(null, iSprachcontainer.getString("sim_m88"), iSprachcontainer.getString("db_menu_25"), 1);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new Diashowthread(this), 100L, l);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jLabel = new JLabel();
        this.setAlwaysOnTop(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                DiashowGui.this.formKeyPressed(keyEvent);
            }
        });
        this.jLabel.setText("keine Bilder gefunden");
        this.jScrollPane1.setViewportView(this.jLabel);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.setSize(new Dimension(400, 300));
        this.setLocationRelativeTo(null);
    }

    private void formKeyPressed(KeyEvent keyEvent) {
        this.timer.cancel();
        this.setVisible(false);
    }

    public int getZaehler() {
        return this.zaehler;
    }

    public void setZaehler(int n) {
        this.zaehler = n;
    }

    public void setBild(File file) {
        try {
            if (file == null) {
                this.jLabel.setText(this.sprache.getString("sim_m89"));
            } else {
                this.jLabel.setText("");
                this.jLabel.setToolTipText("");
                Image image = new ImageIcon("pics" + File.separator + file.getName()).getImage();
                int n = (int)Math.round(this.bildschirmgroesse.getHeight() / (double)image.getHeight(null) * 100.0);
                if ((double)(image.getWidth(null) * n) <= this.bildschirmgroesse.getWidth()) {
                    image = image.getScaledInstance(image.getWidth(null) * n / 100, image.getHeight(null) * n / 100, 4);
                } else {
                    n = (int)Math.round(this.bildschirmgroesse.getWidth() / (double)image.getWidth(null) * 100.0);
                    image = image.getScaledInstance(image.getWidth(null) * n / 100, image.getHeight(null) * n / 100, 4);
                }
                this.jLabel.setIcon(new ImageIcon(image));
            }
        }
        catch (Exception exception) {
            if (file != null) {
                this.getLogger().error("Fehler in setBild(" + file.getName() + ")", exception);
            }
            this.getLogger().error(exception);
        }
    }
}

