/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.exoplanetensystem;

import de.planetensuche.guidesigner.GuiDesignerFabrik;
import de.planetensuche.guidesigner.IGuiDesigner;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.exoplanetensystem.DiagrammFarbHelfer;
import de.planetensuche.simulationen.exoplanetensystem.ExoplanetDTO;
import de.planetensuche.simulationen.exoplanetensystem.ExoplanetenLegendeDialog;
import de.planetensuche.simulationen.exoplanetensystem.IExoplanetenService;
import de.planetensuche.simulationen.exoplanetensystem.PlanetenbahnFormelUtil;
import de.planetensuche.simulationen.exoplanetensystem.RotierendePlanetenZeichner;
import de.planetensuche.simulationen.exoplanetensystem.SternDTO;
import de.planetensuche.simulationen.images.DrawImage;
import de.planetensuche.simulationen.images.DrawImageReaderUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Optional;
import javax.swing.JOptionPane;

public final class ExoplanetenGui
extends Basisdialog {
    private static final boolean FEATURE_TOGGLE_ROTATION = false;
    private final IExoplanetenService service;
    private final IGuiDesigner guiDesigner;
    private ExoplanetenLegendeDialog legendeDialog;
    private final RotierendePlanetenZeichner task;
    private final SternDTO stern;
    private final String sternName;
    private List<ExoplanetDTO> exoplaneten;
    private int screenWidth;
    private int screenHeight;
    private double groessteGrosseHalbachse;
    private double groessterPeriphel;
    private double exzentritaet;
    private double lebenszoneInnen;
    private double lebenszoneAussen;

    public ExoplanetenGui(IExoplanetenService iExoplanetenService, String string, boolean bl) {
        super(BasisdialogId.SIMULATION_EXOPLANETENSYSTEM);
        this.service = iExoplanetenService;
        this.guiDesigner = GuiDesignerFabrik.getInstance();
        this.task = new RotierendePlanetenZeichner(this.rootPane);
        this.sternName = string;
        this.initComponents();
        this.setUndecorated(false);
        this.stern = this.service.getDatenFuerStern(string);
        this.initSimulationseigenschaften(bl);
    }

    private void initSimulationseigenschaften(boolean bl) {
        int n = 0;
        if (bl) {
            n = JOptionPane.showConfirmDialog(null, this.i18n.getString("sim_m90"), this.i18n.getString("sim_m90_titel"), 0);
        }
        int n2 = 0;
        if (bl) {
            n2 = JOptionPane.showConfirmDialog(null, this.i18n.getString("sim_m91"), this.i18n.getString("sim_m91_titel"), 0);
        }
        boolean bl2 = n2 == 0;
        this.exoplaneten = this.service.getPlanetenFuerStern(this.stern.getSternname());
        boolean bl3 = false;
        double d = 0.01;
        for (ExoplanetDTO exoplanetDTO : this.exoplaneten) {
            if (!exoplanetDTO.isExzentrizitaetUnbekannt()) continue;
            if (!bl3 && bl) {
                d = this.frageBenutzerNachExzentrizitaet();
                bl3 = true;
            }
            exoplanetDTO.setExzentrizitaet(d);
        }
        if (n == 0) {
            this.lebenszoneInnen = this.stern.getLebenszoneInnen();
            this.lebenszoneAussen = this.stern.getLebenszoneAussen();
        }
        if (bl2) {
            ExoplanetDTO exoplanetDTO = this.service.getErde();
            this.exoplaneten.add(exoplanetDTO);
        }
        this.berechneGroessteHalbachseUndPerihel();
        if (this.lebenszoneInnen > 0.0 && this.lebenszoneAussen > this.groessteGrosseHalbachse) {
            this.groessteGrosseHalbachse = this.lebenszoneAussen;
            this.groessterPeriphel = this.lebenszoneAussen;
        }
        this.legendeDialog = new ExoplanetenLegendeDialog(this.stern, this.exoplaneten, bl2);
        this.legendeDialog.setVisible(true);
        this.legendeDialog.repaint();
    }

    private double frageBenutzerNachExzentrizitaet() {
        double d = 0.01;
        Object object = JOptionPane.showInputDialog(null, this.i18n.getString("sim_m146"), this.i18n.getString("sim_m146_titel"), 3, null, null, "0.01");
        if (object != null && !"".equals(object)) {
            try {
                d = this.i18n.parseDouble((String)object);
                if (d < 0.01 || d >= 1.0) {
                    d = 0.01;
                }
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.01;
                String string = this.i18n.getString("sim_f3_1") + " " + this.i18n.getString("db_m111") + " " + this.i18n.getString("sim_f3_2") + " 0.01  " + this.i18n.getString("sim_f3_3");
                this.getLogger().showErrorMessageBox(null, string, this.i18n.getString("sim_f3_titel"));
            }
        }
        return d;
    }

    private void berechneGroessteHalbachseUndPerihel() {
        for (ExoplanetDTO exoplanetDTO : this.exoplaneten) {
            double d;
            if (exoplanetDTO.getEntfernungInAE() > this.groessteGrosseHalbachse) {
                this.groessteGrosseHalbachse = exoplanetDTO.getEntfernungInAE();
            }
            if (!(this.groessterPeriphel < (d = exoplanetDTO.getEntfernungInAE() - exoplanetDTO.getEntfernungInAE() * exoplanetDTO.getExzentrizitaet()))) continue;
            this.groessterPeriphel = d;
        }
    }

    private void zeigeLebenszone(double d, Graphics graphics, int n, int n2) {
        double d2 = this.lebenszoneAussen * d;
        this.exzentritaet = 0.0;
        double d3 = PlanetenbahnFormelUtil.getLineareExzentritaet(d2, this.exzentritaet);
        double d4 = d2 - d3;
        double d5 = PlanetenbahnFormelUtil.calcKleineHalbachse(d2, this.exzentritaet);
        graphics.setColor(Color.GREEN);
        graphics.fillOval((int)Math.round((double)n - d4), (int)Math.round((double)n2 - d5), (int)Math.round(d2 + d4 + d3), (int)Math.round(d5 * 2.0));
        d2 = this.lebenszoneInnen * d;
        this.exzentritaet = 0.0;
        d3 = d2 * this.exzentritaet;
        d4 = d2 - d3;
        d5 = PlanetenbahnFormelUtil.calcKleineHalbachse(d2, this.exzentritaet);
        graphics.setColor(Color.BLACK);
        graphics.fillOval((int)Math.round((double)n - d4), (int)Math.round((double)n2 - d5), (int)Math.round(d2 + d4 + d3), (int)Math.round(d5 * 2.0));
    }

    private void berechneUndZeigePlanetenbahnen(Graphics graphics, double d, int n, int n2) {
        DiagrammFarbHelfer diagrammFarbHelfer = new DiagrammFarbHelfer();
        int n3 = 0;
        for (ExoplanetDTO exoplanetDTO : this.exoplaneten) {
            graphics.setColor(diagrammFarbHelfer.getColor(n3));
            double d2 = exoplanetDTO.getEntfernungInAE() * d;
            this.exzentritaet = exoplanetDTO.getExzentrizitaet();
            double d3 = PlanetenbahnFormelUtil.getLineareExzentritaet(d2, this.exzentritaet);
            double d4 = d2 - d3;
            double d5 = PlanetenbahnFormelUtil.calcKleineHalbachse(d2, this.exzentritaet);
            graphics.drawOval((int)((double)n - d4), (int)((double)n2 - d5), (int)(d4 + d3 + d2), (int)(d5 * 2.0));
            ++n3;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Optional<Image> optional;
        graphics.setFont(this.guiDesigner.getFont(false));
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        double d = (double)this.screenWidth / (this.groessteGrosseHalbachse * 3.6);
        int n = (int)Math.round(this.groessterPeriphel * d) + 50;
        int n2 = (int)Math.round((double)this.screenHeight / 2.0);
        if (this.lebenszoneInnen > 0.0 && this.lebenszoneAussen > 0.0) {
            this.zeigeLebenszone(d, graphics, n, n2);
        }
        if ((optional = DrawImageReaderUtil.read(DrawImage.YELLOW_STAR)).isPresent()) {
            graphics.drawImage(optional.get(), n - 8, n2 - 8, 16, 16, this.rootPane);
        } else {
            graphics.drawString("?", n, n2);
        }
        this.berechneUndZeigePlanetenbahnen(graphics, d, n, n2);
    }

    private void initComponents() {
        this.setBackground(new Color(0, 0, 0));
        this.setForeground(new Color(255, 255, 255));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ExoplanetenGui.this.formWindowClosing(windowEvent);
            }
        });
        this.setLayout(null);
        this.resizeToDesktopSize();
        this.setResizable(true);
        this.screenWidth = this.getMaxDesktopWidth();
        this.screenHeight = this.getMaxDesktopHeight();
        this.setTitle(this.i18n.getString("sim_fenster3") + " '" + this.sternName + "'");
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.legendeDialog.dispose();
        this.dispose();
    }
}

