/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.exoplanetensystem;

import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.exoplanetensystem.DiagrammFarbHelfer;
import de.planetensuche.simulationen.exoplanetensystem.ExoplanetDTO;
import de.planetensuche.simulationen.exoplanetensystem.SternDTO;
import de.planetensuche.simulationen.images.PlanetImageUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class ExoplanetenLegendeDialog
extends Basisdialog {
    private final SternDTO sternDTO;
    private final List<ExoplanetDTO> exoplaneten;
    private double minDurchmesser = 50.0;
    private double maxDurchmesser;
    private double vergroesserung;
    private int anzahlDurchmesser;

    public ExoplanetenLegendeDialog(SternDTO sternDTO, List<ExoplanetDTO> list, boolean bl) {
        super(BasisdialogId.SIMULATION_EXOPLANETENSYSTEM_LEGENDE);
        this.sternDTO = sternDTO;
        this.exoplaneten = list;
        Collections.sort(this.exoplaneten, (exoplanetDTO, exoplanetDTO2) -> Double.compare(exoplanetDTO.getEntfernungInAE(), exoplanetDTO2.getEntfernungInAE()));
        for (ExoplanetDTO exoplanetDTO3 : this.exoplaneten) {
            if (exoplanetDTO3.getDurchmesserInJupiterdurchmessern() == 0.0) continue;
            if (exoplanetDTO3.getDurchmesserInJupiterdurchmessern() < this.minDurchmesser) {
                this.minDurchmesser = exoplanetDTO3.getDurchmesserInJupiterdurchmessern();
            }
            if (exoplanetDTO3.getDurchmesserInJupiterdurchmessern() > this.maxDurchmesser) {
                this.maxDurchmesser = exoplanetDTO3.getDurchmesserInJupiterdurchmessern();
            }
            ++this.anzahlDurchmesser;
        }
        if (bl) {
            --this.anzahlDurchmesser;
        }
        this.setAlwaysOnTop(true);
        this.setBackground(new Color(0, 0, 0));
        this.setForeground(new Color(255, 255, 255));
        this.setResizable(true);
        this.setTitle(this.i18n.getString("sim_gui89"));
        this.vergroesserung = 8.0 / this.minDurchmesser;
        if (this.vergroesserung * this.maxDurchmesser < 40.0) {
            this.vergroesserung = 40.0 / this.maxDurchmesser;
        }
        int n = this.getLengthOfLongestExoplanetName() * 5;
        int n2 = 210 + n + (int)(this.vergroesserung * this.maxDurchmesser) + this.anzahlDurchmesser * 30;
        int n3 = 210 + this.exoplaneten.size() * 15 + (int)(this.vergroesserung * this.maxDurchmesser);
        this.setBounds(this.getLeftStartPixel(), this.getTopStartPixel() + 30, n2, n3);
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        graphics.drawString(this.i18n.getString("sim_m134") + ": " + this.i18n.toLocalisedDouble((double)Math.round(this.sternDTO.getLebenszoneInnen() * 1000000.0) / 1000000.0) + " " + this.i18n.getString("db_m83"), 20, 55);
        graphics.drawString(this.i18n.getString("sim_m135") + ": " + this.i18n.toLocalisedDouble((double)Math.round(this.sternDTO.getLebenszoneAussen() * 1000000.0) / 1000000.0) + " " + this.i18n.getString("db_m83"), 20, 70);
        DiagrammFarbHelfer diagrammFarbHelfer = new DiagrammFarbHelfer();
        int n = 0;
        int n2 = 0;
        for (ExoplanetDTO exoplanetDTO : this.exoplaneten) {
            n2 = 85 + 15 * (n + 1);
            graphics.setColor(diagrammFarbHelfer.getColor(n));
            graphics.drawOval(20, n2 - 7, 9, 6);
            graphics.setColor(Color.WHITE);
            graphics.drawString(exoplanetDTO.getPlanetenName() + ": " + this.i18n.toLocalisedDouble(exoplanetDTO.getEntfernungInAE()) + " " + this.i18n.getString("db_m83") + "; " + this.i18n.toLocalisedDouble(exoplanetDTO.getExzentrizitaet()) + " e", 40, n2);
            ++n;
        }
        graphics.setColor(Color.WHITE);
        graphics.drawString(this.i18n.getString("db_m99") + ":", 30, n2 + 30);
        if (this.anzahlDurchmesser > 0) {
            this.zeigePlanetenDurchmesser(n2, graphics, diagrammFarbHelfer);
        } else {
            graphics.drawString(this.i18n.getString("sim_m147"), 30, n2 + 60);
        }
    }

    private void zeigePlanetenDurchmesser(int n, Graphics graphics, DiagrammFarbHelfer diagrammFarbHelfer) {
        int n2 = 0;
        int n3 = n + 60 + (int)(this.vergroesserung * this.maxDurchmesser / 2.0);
        int n4 = n + 60 + (int)(this.vergroesserung * this.maxDurchmesser) + 20;
        int n5 = 40;
        for (ExoplanetDTO exoplanetDTO : this.exoplaneten) {
            Optional<Image> optional;
            graphics.setColor(diagrammFarbHelfer.getColor(n2));
            int n6 = (int)Math.round(exoplanetDTO.getDurchmesserInJupiterdurchmessern() * this.vergroesserung);
            n5 += n6 / 2;
            if ((double)n6 > 0.0) {
                optional = PlanetImageUtil.getImageForDensity(exoplanetDTO.getDurchmesserInJupiterdurchmessern(), exoplanetDTO.getMasseInJupitermassen());
                if (optional.isPresent()) {
                    graphics.drawImage((Image)optional.get(), n5 - n6 / 2, n3 - n6 / 2, n6, n6, this.rootPane);
                } else {
                    graphics.drawString("?", n5, n3);
                }
            } else {
                graphics.drawString("?", n5, n3);
                n6 = 10;
            }
            optional = this.getPlanetnummer(exoplanetDTO);
            graphics.drawString((String)((Object)optional), n5, n4);
            n5 = n5 + n6 / 2 + 30;
            ++n2;
        }
    }

    private String getPlanetnummer(ExoplanetDTO exoplanetDTO) {
        String string = exoplanetDTO.getPlanetenName();
        String[] stringArray = string.split(" ");
        String string2 = stringArray.length > 1 ? stringArray[stringArray.length - 1] : string;
        return string2;
    }

    private int getLengthOfLongestExoplanetName() {
        int n = 1;
        for (ExoplanetDTO exoplanetDTO : this.exoplaneten) {
            int n2 = exoplanetDTO.getPlanetenName().length();
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }
}

