/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.exoplanetensystem;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbankkern.api.repos.IHabitableZoneRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.exoplanetensystem.ExoplanetDTO;
import de.planetensuche.simulationen.exoplanetensystem.IExoplanetenService;
import de.planetensuche.simulationen.exoplanetensystem.IExoplanetensystemeRepository;
import de.planetensuche.simulationen.exoplanetensystem.SternDTO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public final class ExoplanetenService
implements IExoplanetenService {
    private final ILogging logging;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IExoplanetensystemeRepository exoplanetensystemeRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final IHabitableZoneRepository habitableZoneRepository;

    public ExoplanetenService(IPlanetensucheObjektRepository iPlanetensucheObjektRepository, IExoplanetensystemeRepository iExoplanetensystemeRepository, IObjektnamenRepository iObjektnamenRepository, IHabitableZoneRepository iHabitableZoneRepository) {
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.exoplanetensystemeRepository = iExoplanetensystemeRepository;
        this.objektnamenRepository = iObjektnamenRepository;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.habitableZoneRepository = iHabitableZoneRepository;
    }

    @Override
    public ExoplanetDTO getErde() {
        ExoplanetDTO exoplanetDTO = new ExoplanetDTO();
        try {
            Integer n = this.objektnamenRepository.getIDFuerNamen("Erde", true);
            IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(n);
            exoplanetDTO.setPlanetenName(iPlanetensucheObjekt.getObjektNamen().get(0));
            exoplanetDTO.setEntfernungInAE(iPlanetensucheObjekt.getEntfernung());
            exoplanetDTO.setExzentrizitaet(iPlanetensucheObjekt.getExzentritaet());
            exoplanetDTO.setMasseInJupitermassen(iPlanetensucheObjekt.getMasse());
            exoplanetDTO.setUmlaufszeitInTagen(iPlanetensucheObjekt.getUmlaufszeit());
            exoplanetDTO.setDurchmesserInJupiterdurchmessern(iPlanetensucheObjekt.getDurchmesser());
        }
        catch (SQLException sQLException) {
            this.logging.error(sQLException);
        }
        return exoplanetDTO;
    }

    @Override
    public List<ExoplanetDTO> getPlanetenFuerStern(String string) {
        Map<Daten, List<String>> map = this.exoplanetensystemeRepository.findPlanetsByStarName(string);
        if (Check.isEmpty(map)) {
            throw new IllegalArgumentException("Zum Stern '" + string + "' wurden keine Planeten gefunden!");
        }
        ArrayList<ExoplanetDTO> arrayList = new ArrayList<ExoplanetDTO>(map.size());
        for (Map.Entry<Daten, List<String>> entry : map.entrySet()) {
            try {
                Daten daten = entry.getKey();
                String string2 = entry.getValue().get(0);
                if (daten.getEntfernung() > 0.0) {
                    ExoplanetDTO exoplanetDTO = new ExoplanetDTO();
                    exoplanetDTO.setPlanetenName(string2);
                    exoplanetDTO.setEntfernungInAE(daten.getEntfernung());
                    exoplanetDTO.setExzentrizitaet(daten.getExzentritaet());
                    exoplanetDTO.setMasseInJupitermassen(daten.getMasse());
                    exoplanetDTO.setUmlaufszeitInTagen(daten.getUmlaufszeit());
                    exoplanetDTO.setDurchmesserInJupiterdurchmessern(daten.getDurchmesser());
                    arrayList.add(exoplanetDTO);
                    continue;
                }
                this.logging.debug("Zum Objekt " + string2 + " ist keine Entfernung bekannt. Planet wird ignoriert.");
            }
            catch (RuntimeException runtimeException) {
                this.logging.error(runtimeException);
            }
        }
        return arrayList;
    }

    @Override
    public SternDTO getDatenFuerStern(String string) {
        SternDTO sternDTO = new SternDTO();
        try {
            Integer n = this.objektnamenRepository.getIDFuerNamen(string, true);
            if (n == null) {
                throw new IllegalArgumentException("Objekt '" + string + "' nicht gefunden!");
            }
            IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(n);
            sternDTO.setSternname(string);
            Optional<Pair<Double, Double>> optional = this.habitableZoneRepository.getInnerAndOuterHZ(iPlanetensucheObjekt.getDatenid());
            if (optional.isPresent()) {
                sternDTO.setLebenszoneInnen(optional.get().getLeft());
                sternDTO.setLebenszoneAussen(optional.get().getRight());
            }
        }
        catch (SQLException sQLException) {
            this.logging.error(sQLException);
        }
        return sternDTO;
    }
}

