/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.exoplanetensystem;

import de.planetensuche.datenbankkern.api.repos.IHabitableZoneRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.statusfenster.StatusfensterHandler;
import de.planetensuche.simulationen.exoplanetensystem.ExoplanetenGui;
import de.planetensuche.simulationen.exoplanetensystem.ExoplanetenService;
import de.planetensuche.simulationen.exoplanetensystem.ExoplanetensystemeListeDialog;
import de.planetensuche.simulationen.exoplanetensystem.IExoplanetensystemeRepository;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JTextField;

public final class ExoplanetensystemeListeControler {
    private final ILogging logger;
    private final ExoplanetensystemeListeDialog dialog;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IExoplanetensystemeRepository exoplanetensystemeRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final IHabitableZoneRepository habitableZoneRepository;

    public ExoplanetensystemeListeControler(IPlanetensucheObjektRepository iPlanetensucheObjektRepository, IExoplanetensystemeRepository iExoplanetensystemeRepository, IObjektnamenRepository iObjektnamenRepository, IHabitableZoneRepository iHabitableZoneRepository) {
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.exoplanetensystemeRepository = iExoplanetensystemeRepository;
        this.objektnamenRepository = iObjektnamenRepository;
        this.habitableZoneRepository = iHabitableZoneRepository;
        this.logger = LoggingFactory.getLoggerForClass(ExoplanetensystemeListeControler.class);
        this.dialog = new ExoplanetensystemeListeDialog();
        this.dialog.getWeiterButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ExoplanetensystemeListeControler.this.dialog.getAusgewaehltesSystem();
                if (string != null) {
                    ExoplanetensystemeListeControler.this.zeigeExoplanetensystem(string, true);
                }
            }
        });
        this.dialog.getSearchField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                JTextField jTextField = (JTextField)keyEvent.getSource();
                String string = jTextField.getText();
                if (string != null && string.length() >= 3) {
                    ExoplanetensystemeListeControler.this.filterExoplanetList(string);
                } else if (string == null || string.isEmpty()) {
                    ExoplanetensystemeListeControler.this.dialog.showCompleteList();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    private void filterExoplanetList(String string) {
        try {
            Map<String, Integer> map = this.exoplanetensystemeRepository.getExoplanetsByName(string);
            this.logger.debug("suche nach '" + string + "' brachte " + map.size() + " ergebnisse");
            this.dialog.filterTable(map);
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
        }
    }

    public void zeigeExoplanetensystem(String string, boolean bl) {
        ExoplanetenService exoplanetenService = new ExoplanetenService(this.planetensucheObjektRepository, this.exoplanetensystemeRepository, this.objektnamenRepository, this.habitableZoneRepository);
        ExoplanetenGui exoplanetenGui = new ExoplanetenGui(exoplanetenService, string, bl);
        exoplanetenGui.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zeigeListe(JFrame jFrame) {
        StatusfensterHandler statusfensterHandler = new StatusfensterHandler(jFrame, null);
        statusfensterHandler.startAnimation();
        Map<String, Integer> map = null;
        try {
            map = this.exoplanetensystemeRepository.getExoplanetensysteme();
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
        }
        finally {
            if (map != null) {
                this.dialog.showDialog(map);
                this.dialog.requestFocus();
            }
            statusfensterHandler.stopAnimation();
        }
    }

    void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }
}

