/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.exoplanetensystem;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.exoplanetensystem.IExoplanetensystemeRepository;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ExoplanetensystemeRepository
implements IExoplanetensystemeRepository {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankService datenbankService;
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCacheDao;

    @Inject
    public ExoplanetensystemeRepository(IDatenbankService iDatenbankService, IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.datenbankService = iDatenbankService;
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCacheDao = iIdCacheDAO;
    }

    @Override
    public Map<String, Integer> getExoplanetensysteme() throws SQLException {
        List list;
        Object object2;
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.zugehoerigkeit, qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsPlaneten()).and(qDaten.entfernung.gt(0.0)).and(qDaten.entdeckungbestaetigt.isTrue()))).fetch();
        QDaten qDaten2 = new QDaten("self");
        List list3 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qNamen.namen}).from((Expression<?>)qDaten)).rightJoin((EntityPath)qDaten2)).on((Predicate)qDaten.id.eq(qDaten2.zugehoerigkeit))).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsSterne()).and(qDaten2.entfernung.gt(0.0)).and(qDaten2.entdeckungbestaetigt.isTrue()))).fetch();
        HashMap hashMap = new HashMap();
        for (Object object2 : list3) {
            Integer n = object2.get(qDaten.id);
            Object object3 = object2.get(qNamen.namen);
            list = (List)hashMap.get(n);
            if (list == null) {
                list = new ArrayList();
                hashMap.put(n, list);
            }
            list.add(object3);
        }
        TreeMap treeMap = new TreeMap();
        object2 = new ArrayList();
        for (Object object3 : list2) {
            list = object3.get(qDaten.id);
            Double d = object3.get(qDaten.entfernung);
            if (object2.contains(list) || d == null || !(d > 0.0)) continue;
            String string = object3.get(qNamen.namen);
            Integer n = object3.get(qDaten.zugehoerigkeit);
            String string2 = string.substring(0, string.length() - 2).trim();
            List list4 = (List)hashMap.get(n);
            if (list4 == null || !list4.contains(string2)) continue;
            object2.add(list);
            Integer n2 = (Integer)treeMap.get(string2);
            if (n2 == null) {
                treeMap.put(string2, 1);
                continue;
            }
            treeMap.put(string2, n2 + 1);
        }
        return treeMap;
    }

    @Override
    public Map<String, Integer> getExoplanetsByName(String string) throws SQLException {
        QNamen qNamen = QNamen.namen1;
        QDaten qDaten = QDaten.daten;
        List<Integer> list = this.datenbankService.getObjekttypenidsPlaneten();
        List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.zugehoerigkeit, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.zugehoerigkeit.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)list).and(qDaten.entfernung.gt(0.0)).and(qDaten.entdeckungbestaetigt.isTrue()).and(qNamen.namen.likeIgnoreCase("%" + string + "%")))).fetch();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Tuple tuple : list2) {
            String string2 = tuple.get(qNamen.namen);
            Integer n = (Integer)hashMap.get(string2);
            if (n == null) {
                hashMap.put(string2, 1);
                continue;
            }
            hashMap.put(string2, n + 1);
        }
        return hashMap;
    }

    @Override
    public Map<Daten, List<String>> findPlanetsByStarName(String string) {
        try {
            QDaten qDaten = QDaten.daten;
            QNamen qNamen = QNamen.namen1;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten, qNamen.namen}).from((Expression<?>)qDaten)).innerJoin((EntityPath)qNamen)).on((Predicate)qNamen.datenid.eq(qDaten.id))).where(qDaten.zugehoerigkeit.eq((Expression)((SQLQuery)SQLExpressions.select(qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))).and(qDaten.entfernung.gt(0.0)).and(qDaten.entdeckungbestaetigt.isTrue()))).orderBy((OrderSpecifier<?>)qNamen.namen.asc())).fetch();
            LinkedHashMap<Daten, List<String>> linkedHashMap = new LinkedHashMap<Daten, List<String>>();
            for (Tuple tuple : list) {
                Daten daten = tuple.get(qDaten);
                ArrayList<String> arrayList = linkedHashMap.keySet().iterator();
                while (arrayList.hasNext()) {
                    Daten daten2 = (Daten)arrayList.next();
                    if (daten2.getId().intValue() != daten.getId().intValue()) continue;
                    daten = daten2;
                    break;
                }
                if ((arrayList = (List)linkedHashMap.get(daten)) == null) {
                    arrayList = new ArrayList<String>();
                    linkedHashMap.put(daten, arrayList);
                }
                arrayList.add(tuple.get(qNamen.namen));
            }
            return linkedHashMap;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("findPlanetsByStarName(" + string + ")", runtimeException);
            return Collections.emptyMap();
        }
    }
}

