/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.exoplanetensystem;

import java.util.GregorianCalendar;

public final class PlanetenbahnFormelUtil {
    private PlanetenbahnFormelUtil() {
    }

    public static double getLineareExzentritaet(double d, double d2) {
        return d * d2;
    }

    public static double getEkliptikaleBreite(double d, double d2) {
        return Math.asin(Math.sin(d) * Math.sin(d2));
    }

    public static double getArgumentDerBreite(double d, double d2) {
        return d + d2;
    }

    public static double calcKleineHalbachse(double d, double d2) {
        return d * Math.sqrt(1.0 - d2 * d2);
    }

    public static double berechneJulianischesDatum(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2000);
        gregorianCalendar.set(2, 1);
        gregorianCalendar.set(5, 1);
        gregorianCalendar.set(11, 12);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.add(5, n);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(1);
        int n4 = gregorianCalendar.get(5);
        if (n2 <= 2) {
            n2 += 12;
            --n3;
        }
        double d = Math.floor((double)n3 / 400.0) - Math.floor((double)n3 / 100.0);
        int n5 = gregorianCalendar.get(13);
        int n6 = gregorianCalendar.get(12);
        int n7 = gregorianCalendar.get(11);
        double d2 = Math.floor(365.25 * (double)n3) + Math.floor(30.6001 * (double)(n2 + 1)) + d + 1720996.5 + (double)n4 + ((double)n7 + (double)n6 / 60.0 + (double)n5 / 3600.0) / 24.0;
        return d2;
    }

    public static double getMittlereAnomalie(double d, double d2, double d3, double d4) {
        double d5 = d3 - d4;
        double d6 = d5 / d;
        double d7 = d6 * 360.0 + d2;
        for (int i = 0; !(i >= 10 || d7 >= 0.0 && d7 <= 360.0); ++i) {
            if (d7 < 0.0) {
                d7 += 360.0;
                continue;
            }
            d7 -= 360.0;
        }
        return d7;
    }

    public static double getExzentrischeAnomalie(int n, double d, double d2) {
        if (n < 0) {
            return 0.0;
        }
        if (n == 0) {
            return d;
        }
        double d3 = PlanetenbahnFormelUtil.getExzentrischeAnomalie(n - 1, d, d2);
        return d + 57.29577951308232 * d2 * Math.sin(d3);
    }

    public static double getWahreAnomalie(double d, double d2) {
        double d3 = Math.sqrt((1.0 + d) / (1.0 - d));
        double d4 = Math.tan(d2 / 2.0);
        double d5 = d3 * d4;
        double d6 = Math.atan(d5) * 2.0;
        return Math.toDegrees(d6);
    }

    public static double getWahreAnomalie(double d, int n, double d2, double d3, double d4, double d5) {
        double d6 = PlanetenbahnFormelUtil.getMittlereAnomalie(d2, d3, d4, d5);
        double d7 = PlanetenbahnFormelUtil.getExzentrischeAnomalie(n, d6, d);
        double d8 = PlanetenbahnFormelUtil.getWahreAnomalie(d, d7);
        return d8;
    }

    public static double getEntfernungVomStern(double d, double d2, double d3) {
        double d4 = d * (1.0 - d2 * Math.cos(Math.toRadians(d3)));
        return d4;
    }

    public static double getEntfernungVomStern2(double d, double d2, double d3) {
        double d4 = d * (1.0 - d2 * d2) / (1.0 + d2 * Math.cos(d3));
        return d4;
    }

    public static double calcBahngeschwindigkeit(double d, double d2) {
        double d3 = Math.PI * 2 * d * 1.4959787E8 / (d2 * 24.0 * 60.0 * 60.0);
        return d3;
    }
}

