/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.exoplanetensystem;

import de.planetensuche.simulationen.exoplanetensystem.ExoplanetDTO;
import de.planetensuche.simulationen.exoplanetensystem.PlanetenbahnFormelUtil;
import de.planetensuche.simulationen.images.DrawImage;
import de.planetensuche.simulationen.images.DrawImageReaderUtil;
import java.awt.Graphics;
import java.awt.Image;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.JRootPane;
import org.apache.commons.lang3.tuple.Pair;

public class RotierendePlanetenZeichner {
    private final JRootPane jpane;
    private int t = 1;
    private final double einTagInSekunden = 86400.0;
    private final Map<Koerper, Pair<Double, Double>> gesamtAnziehungskraefte = new HashMap<Koerper, Pair<Double, Double>>();

    public RotierendePlanetenZeichner(JRootPane jRootPane) {
        this.jpane = jRootPane;
    }

    public void callKaputt(Graphics graphics, double d, int n, int n2, List<ExoplanetDTO> list) throws Exception {
        Object object;
        if (this.gesamtAnziehungskraefte.isEmpty()) {
            for (ExoplanetDTO object22 : list) {
                Iterator<Object> iterator = new Koerper(this, object22, d);
                this.gesamtAnziehungskraefte.put((Koerper)((Object)iterator), null);
            }
        }
        ExoplanetDTO exoplanetDTO = new ExoplanetDTO();
        exoplanetDTO.setPlanetenName("Sonne");
        exoplanetDTO.setEntfernungInAE(0.0);
        exoplanetDTO.setMasseInJupitermassen(1048.9989462592202);
        Koerper koerper = new Koerper(this, exoplanetDTO, d);
        for (Koerper koerper2 : this.gesamtAnziehungskraefte.keySet()) {
            object = koerper2.calcAnziehungskraft(koerper);
            double d2 = ((Pair)object).getLeft();
            double d3 = ((Pair)object).getRight();
            System.out.println(koerper2.getName() + " kr\u00e4fte: " + d2 + ", " + d3);
            this.gesamtAnziehungskraefte.put(koerper2, Pair.of(d2, d3));
        }
        for (Map.Entry<Koerper, Pair<Double, Double>> entry : this.gesamtAnziehungskraefte.entrySet()) {
            object = entry.getKey();
            Pair<Double, Double> pair = entry.getValue();
            ((Koerper)object).setGeschwindigkeitXInMeterProSekunde(((Koerper)object).getGeschwindigkeitXInMeterProSekunde() + pair.getLeft() / ((Koerper)object).getMasseInKg() * 86400.0);
            ((Koerper)object).setGeschwindigkeitYInMeterProSekunde(((Koerper)object).getGeschwindigkeitYInMeterProSekunde() + pair.getRight() / ((Koerper)object).getMasseInKg() * 86400.0);
            ((Koerper)object).setPositionXInMeter(((Koerper)object).getPositionXInMeter() + ((Koerper)object).getGeschwindigkeitXInMeterProSekunde() * 86400.0);
            ((Koerper)object).setPositionYInMeter(((Koerper)object).getPositionYInMeter() + ((Koerper)object).getGeschwindigkeitYInMeterProSekunde() * 86400.0);
            System.out.println(((Koerper)object).name + ": " + ((Koerper)object).geschwindigkeitXInMeterProSekunde + " m/s, " + ((Koerper)object).geschwindigkeitYInMeterProSekunde + " m/s");
            this.gesamtAnziehungskraefte.put((Koerper)object, pair);
        }
        for (Koerper koerper3 : this.gesamtAnziehungskraefte.keySet()) {
            if (koerper3.getName().equals("Sonne")) continue;
            int n3 = n + (int)(koerper3.getPositionXInMeter() / 1.2925255968E15);
            int n4 = n2 + (int)(koerper3.getPositionYInMeter() / 1.2925255968E15);
            Optional<Image> optional = DrawImageReaderUtil.read(DrawImage.PLANET_WITH_RING_SYSTEM);
            if (!optional.isPresent()) continue;
            System.out.println(koerper3.getName() + ": x=" + n3 + ", y=" + n4);
            graphics.drawImage(optional.get(), n3, n4, 30, 30, this.jpane);
            System.out.println("t=" + this.t);
        }
        ++this.t;
        Thread.sleep(100L);
    }

    public void call(Graphics graphics, double d, int n, int n2, List<ExoplanetDTO> list) throws Exception {
        double d2 = 2451545.0;
        double d3 = PlanetenbahnFormelUtil.berechneJulianischesDatum(this.t);
        System.out.println("JD: " + d3);
        for (ExoplanetDTO exoplanetDTO : list) {
            double d4 = exoplanetDTO.getExzentrizitaet();
            double d5 = exoplanetDTO.getEntfernungInAE() * d;
            double d6 = PlanetenbahnFormelUtil.calcKleineHalbachse(d5, d4);
            double d7 = 175.0;
            System.out.println("groesseHalbachse=" + d5 + ", klHalbachse=" + d6 + ", exzentritaet=" + d4);
            double d8 = 174.452192;
            double d9 = PlanetenbahnFormelUtil.getMittlereAnomalie(exoplanetDTO.getUmlaufszeitInTagen(), d8, d3, d2);
            System.out.println("mittlereAnomalie=" + d9 + " f\u00fcr " + exoplanetDTO.getPlanetenName());
            if (Double.isInfinite(d9)) continue;
            double d10 = PlanetenbahnFormelUtil.getExzentrischeAnomalie(5, d9, d4);
            double d11 = PlanetenbahnFormelUtil.getWahreAnomalie(d4, d10);
            double d12 = PlanetenbahnFormelUtil.getEntfernungVomStern2(d5, d4, d11);
            System.out.println("r=" + d12 + ", wahreAnnomalie=" + d11 + " f\u00fcr " + exoplanetDTO.getPlanetenName());
            double d13 = d5;
            double d14 = d6;
            double d15 = d13 * Math.cos(Math.toRadians(d10));
            double d16 = d14 * Math.sin(Math.toRadians(d10));
            int n3 = n + (int)d15;
            int n4 = n2 + (int)d16;
            Optional<Image> optional = DrawImageReaderUtil.read(DrawImage.ROCKY_PLANET);
            if (!optional.isPresent()) continue;
            System.out.println(exoplanetDTO.getPlanetenName() + ": x=" + n3 + ", y=" + n4);
            graphics.drawImage(optional.get(), n3, n4, 30, 30, this.jpane);
        }
        System.out.println("t=" + this.t);
        ++this.t;
        Thread.sleep(100L);
    }

    public class Koerper {
        private double positionXInMeter = 0.0;
        private double positionYInMeter = 0.0;
        private double geschwindigkeitXInMeterProSekunde = 0.0;
        private double geschwindigkeitYInMeterProSekunde = 0.0;
        private double masseInKg = 0.0;
        private String name;

        public Koerper(RotierendePlanetenZeichner rotierendePlanetenZeichner, ExoplanetDTO exoplanetDTO, double d) {
            this.name = exoplanetDTO.getPlanetenName();
            this.positionXInMeter = exoplanetDTO.getEntfernungInAE() * d * 1.4959787E8 * 1000.0;
            this.positionYInMeter = PlanetenbahnFormelUtil.calcKleineHalbachse(exoplanetDTO.getEntfernungInAE() * d * 1.4959787E8 * 1000.0, exoplanetDTO.getExzentrizitaet());
            this.geschwindigkeitYInMeterProSekunde = exoplanetDTO.getBahngeschwindigkeitInKmSekunde() * 1000.0;
            this.masseInKg = exoplanetDTO.getMasseInJupitermassen() * 1.898E27;
        }

        public Pair<Double, Double> calcAnziehungskraft(Koerper koerper) {
            if (koerper == this) {
                throw new IllegalArgumentException(this.name + " kann nicht mit sich selbst berechnet werden");
            }
            double d = this.getPositionXInMeter() - koerper.getPositionXInMeter();
            double d2 = this.getPositionYInMeter() - koerper.getPositionYInMeter();
            double d3 = Math.sqrt(d * 2.0 + d2 * 2.0);
            System.out.println("diff " + this.name + ": " + d3);
            if (d3 == 0.0) {
                throw new IllegalArgumentException("Kollision zwischen " + this.name + " und " + koerper.getName());
            }
            double d4 = 6.6742E-11 * this.masseInKg * koerper.getMasseInKg() / Math.pow(d3, 2.0);
            System.out.println("kraft " + this.name + ": " + d4 + " kg/meter");
            double d5 = Math.atan2(d2, d);
            double d6 = Math.cos(d5) * d4;
            double d7 = Math.sin(d5) * d4;
            System.out.println(this.name + " fx, fy: " + d6 + ", " + d7);
            return Pair.of(d6, d7);
        }

        public double getPositionXInMeter() {
            return this.positionXInMeter;
        }

        public void setPositionXInMeter(double d) {
            this.positionXInMeter = d;
        }

        public double getPositionYInMeter() {
            return this.positionYInMeter;
        }

        public void setPositionYInMeter(double d) {
            this.positionYInMeter = d;
        }

        public double getGeschwindigkeitXInMeterProSekunde() {
            return this.geschwindigkeitXInMeterProSekunde;
        }

        public void setGeschwindigkeitXInMeterProSekunde(double d) {
            this.geschwindigkeitXInMeterProSekunde = d;
        }

        public double getGeschwindigkeitYInMeterProSekunde() {
            return this.geschwindigkeitYInMeterProSekunde;
        }

        public void setGeschwindigkeitYInMeterProSekunde(double d) {
            this.geschwindigkeitYInMeterProSekunde = d;
        }

        public double getMasseInKg() {
            return this.masseInKg;
        }

        public void setMasseInKg(double d) {
            this.masseInKg = d;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }
}

