/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.images;

import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.images.DrawImage;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Optional;
import javax.imageio.ImageIO;

public final class DrawImageReaderUtil {
    private DrawImageReaderUtil() {
    }

    public static Optional<Image> read(DrawImage drawImage) {
        try {
            File file = new File(drawImage.getImagePath());
            if (!file.exists()) {
                LoggingFactory.getLoggerForClass(DrawImageReaderUtil.class).warn("image '" + drawImage.getImagePath() + "' did not exists, but is a required default image");
                return Optional.empty();
            }
            BufferedImage bufferedImage = ImageIO.read(file);
            return Optional.of(bufferedImage);
        }
        catch (Exception exception) {
            LoggingFactory.getLoggerForClass(DrawImageReaderUtil.class).error("image: " + drawImage.name(), exception);
            return Optional.empty();
        }
    }
}

