/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.images;

import de.planetensuche.simulationen.images.DrawImage;
import de.planetensuche.simulationen.images.DrawImageReaderUtil;
import java.awt.Image;
import java.util.Optional;

public final class PlanetImageUtil {
    private PlanetImageUtil() {
    }

    public static double calcDensity(double d, double d2) {
        double d3 = d2 * 1.898E27 * 1000.0;
        double d4 = d * 142984.0 * 1000.0 * 100.0;
        double d5 = 0.5235987755982988 * Math.pow(d4, 3.0);
        double d6 = d3 / d5;
        return d6;
    }

    public static Optional<Image> getImageForDensity(double d, Double d2) {
        if (d > 0.0 && d2 != null && d2 > 0.0) {
            double d3 = PlanetImageUtil.calcDensity(d, d2);
            Optional<Image> optional = d3 < 1.7 ? DrawImageReaderUtil.read(DrawImage.GAS_PLANET) : DrawImageReaderUtil.read(DrawImage.ROCKY_PLANET);
            return optional;
        }
        Optional<Image> optional = d2 != null && d2 < 0.03 ? DrawImageReaderUtil.read(DrawImage.ROCKY_PLANET) : (d2 != null && d2 <= 0.25 ? DrawImageReaderUtil.read(DrawImage.PLANET_WITH_RING_SYSTEM) : (d2 == null && d < 0.15 ? DrawImageReaderUtil.read(DrawImage.ROCKY_PLANET) : (d2 == null && d < 0.86 ? DrawImageReaderUtil.read(DrawImage.PLANET_WITH_RING_SYSTEM) : DrawImageReaderUtil.read(DrawImage.GAS_PLANET))));
        return optional;
    }
}

