/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.sonnensystem.asteroiden;

import com.google.common.collect.Ordering;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.jtable.JTableExtended;
import de.planetensuche.simulationen.dbmodel.kategorien.api.SonnensystemDTO;
import de.planetensuche.simulationen.sonnensystem.asteroiden.IAsteroidenAuswahlControler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public final class AsteroidenAuswahlGui
extends Basisdialog
implements ActionListener {
    private final IAsteroidenAuswahlControler controler;
    private final String[] spalten = new String[]{this.getSprachcontainer().getString("sim_gui114"), this.getSprachcontainer().getString("sim_gui115")};
    private final Map<String, SonnensystemDTO> dtosMap;
    private JButton entfernenButton;
    private JButton hinzufuegenButton;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JTableExtended objektlisteAlle;
    private JTableExtended objektlisteAusgewaehlt;
    private JButton okButton;

    public AsteroidenAuswahlGui(IAsteroidenAuswahlControler iAsteroidenAuswahlControler, List<SonnensystemDTO> list) {
        super(BasisdialogId.SIMULATION_ASTEROIDEN_AUSWAHL);
        this.controler = iAsteroidenAuswahlControler;
        this.dtosMap = new HashMap<String, SonnensystemDTO>();
        for (SonnensystemDTO sonnensystemDTO : list) {
            this.dtosMap.put(sonnensystemDTO.getObjektname(), sonnensystemDTO);
        }
        this.initComponents();
        this.setTitle(this.i18n.getString("sim_gui116"));
        this.okButton.setText(this.i18n.getString("db_gui46"));
        this.resizeToCenter(this.getWidth(), this.getHeight());
        this.fuelleListe(list);
    }

    private void initComponents() {
        this.hinzufuegenButton = new JButton();
        this.entfernenButton = new JButton();
        this.okButton = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.objektlisteAlle = new JTableExtended();
        this.jScrollPane1 = new JScrollPane();
        this.objektlisteAusgewaehlt = new JTableExtended();
        this.setDefaultCloseOperation(2);
        this.hinzufuegenButton.setText(">");
        this.hinzufuegenButton.addActionListener(this);
        this.entfernenButton.setText("<");
        this.entfernenButton.addActionListener(this);
        this.okButton.setText("ok");
        this.okButton.addActionListener(this);
        this.objektlisteAlle.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Title 1", "Title 2"}));
        this.jScrollPane3.setViewportView(this.objektlisteAlle);
        this.objektlisteAusgewaehlt.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Title 1", "Title 2"}));
        this.jScrollPane1.setViewportView(this.objektlisteAusgewaehlt);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.okButton).addGroup(groupLayout.createSequentialGroup().addComponent(this.jScrollPane3, -1, 288, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.entfernenButton).addComponent(this.hinzufuegenButton)).addGap(18, 18, 18).addComponent(this.jScrollPane1, -2, 291, -2))).addGap(22, 22, 22)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -2, 0, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addGap(18, 18, 18)).addGroup(groupLayout.createSequentialGroup().addGap(129, 129, 129).addComponent(this.hinzufuegenButton).addGap(0, 0, 0).addComponent(this.entfernenButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 107, Short.MAX_VALUE))).addComponent(this.okButton).addGap(25, 25, 25)));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.hinzufuegenButton) {
            this.hinzufuegenButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.okButton) {
            this.okButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.entfernenButton) {
            this.entfernenButtonActionPerformed(actionEvent);
        }
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.controler.zeigeAusgewaehlteAsteroiden(this.getAuswahl());
    }

    private void hinzufuegenButtonActionPerformed(ActionEvent actionEvent) {
        this.verschiebeAusgewaehlteEintraege(this.objektlisteAlle, this.objektlisteAusgewaehlt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verschiebeAusgewaehlteEintraege(JTableExtended jTableExtended, JTableExtended jTableExtended2) {
        try {
            int[] nArray = jTableExtended.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            DefaultTableModel defaultTableModel = (DefaultTableModel)jTableExtended2.getModel();
            for (int n : nArray) {
                Object[] objectArray = new Object[]{jTableExtended.getValueAt(n, 0), jTableExtended.getValueAt(n, 1)};
                defaultTableModel.addRow(objectArray);
                arrayList.add(n);
            }
            Collections.sort(arrayList, Ordering.natural().reverse());
            Object object = (DefaultTableModel)jTableExtended.getModel();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n;
                int n2 = (Integer)iterator.next();
                n = jTableExtended.convertRowIndexToModel(n2);
                ((DefaultTableModel)object).removeRow(n);
            }
        }
        catch (RuntimeException runtimeException) {
            this.getLogger().error(runtimeException);
        }
        finally {
            if (jTableExtended.getRowSorter() != null) {
                jTableExtended.getRowSorter().allRowsChanged();
            }
            this.objektlisteAusgewaehlt.repaint();
            this.objektlisteAlle.repaint();
        }
    }

    private void entfernenButtonActionPerformed(ActionEvent actionEvent) {
        this.verschiebeAusgewaehlteEintraege(this.objektlisteAusgewaehlt, this.objektlisteAlle);
    }

    private List<SonnensystemDTO> getAuswahl() {
        ArrayList<SonnensystemDTO> arrayList = new ArrayList<SonnensystemDTO>();
        TableModel tableModel = this.objektlisteAusgewaehlt.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            String string = (String)tableModel.getValueAt(i, 0);
            arrayList.add(this.dtosMap.get(string));
        }
        return arrayList;
    }

    private void fuelleListe(List<SonnensystemDTO> list) {
        Object[][] objectArray = new String[list.size()][2];
        int n = 0;
        for (SonnensystemDTO object2 : list) {
            objectArray[n][0] = object2.getObjektname();
            objectArray[n][1] = "" + object2.getEntfernung();
            ++n;
        }
        Object object3 = new DefaultTableModel(objectArray, this.spalten);
        this.objektlisteAlle.setModel((TableModel)object3);
        this.objektlisteAlle.setColumnHeaderNamesWithSortIcon(Arrays.asList(this.spalten));
        this.objektlisteAlle.disableDragColumns();
        this.objektlisteAlle.disableEditMode();
        this.objektlisteAlle.setSelectionMode(2);
        TableRowSorter<Object> tableRowSorter = new TableRowSorter<Object>(object3);
        this.objektlisteAlle.setRowSorter(tableRowSorter);
        objectArray = new String[0][2];
        object3 = new DefaultTableModel(objectArray, this.spalten);
        this.objektlisteAusgewaehlt.setModel((TableModel)object3);
        this.objektlisteAusgewaehlt.disableDragColumns();
        this.objektlisteAusgewaehlt.disableEditMode();
    }
}

