/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.sonnensystem.asteroiden;

import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.SonnensystemDTO;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;

public final class AsteroidenBahnenGui
extends Basisdialog {
    private final List<SonnensystemDTO> objekte;
    private final int screenWidth;
    private final int screenHeigth;
    private double groessteHalbachse;
    private double groessterPeriphel;
    private double exzentritaet;
    private final Color[] colorarr = new Color[]{Color.BLUE, Color.GREEN, Color.CYAN, Color.YELLOW, Color.GRAY, Color.MAGENTA, Color.ORANGE, Color.RED, Color.WHITE, Color.PINK};

    public AsteroidenBahnenGui(List<SonnensystemDTO> list) {
        super(BasisdialogId.SIMULATION_ASTEROIDEN_BAHNEN);
        this.objekte = list;
        this.setTitle(this.i18n.getString("sim_fenster6") + " " + this.i18n.toLocalisedInt(list.size()) + " " + this.i18n.getString("ps_asteroiden"));
        this.setAlwaysOnTop(true);
        this.setBackground(new Color(0, 0, 0));
        this.setForeground(new Color(255, 255, 255));
        this.resizeToDesktopSize();
        this.screenWidth = this.getWidth();
        this.screenHeigth = this.getHeight();
        this.berechneGroesseHalbachseUndPerihel();
    }

    private void berechneGroesseHalbachseUndPerihel() {
        for (SonnensystemDTO sonnensystemDTO : this.objekte) {
            double d;
            if (sonnensystemDTO.getEntfernung() > this.groessteHalbachse) {
                this.groessteHalbachse = sonnensystemDTO.getEntfernung();
            }
            if (!(this.groessterPeriphel < (d = sonnensystemDTO.getEntfernung() - sonnensystemDTO.getEntfernung() * sonnensystemDTO.getExzentrizitaet()))) continue;
            this.groessterPeriphel = d;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setFont(this.getGuiDesigner().getFont(false));
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeigth);
        double d = (double)this.screenWidth / (this.groessteHalbachse * 3.5);
        int n = (int)(this.groessterPeriphel * d) + 100;
        int n2 = this.screenHeigth / 2;
        graphics.setColor(Color.YELLOW);
        graphics.fillOval(n, n2, 2, 2);
        int n3 = 0;
        for (SonnensystemDTO sonnensystemDTO : this.objekte) {
            graphics.setColor(this.getColor(n3));
            graphics.drawString(sonnensystemDTO.getObjektname() + ": " + this.i18n.toLocalisedDouble(sonnensystemDTO.getEntfernung()) + " " + this.i18n.getString("db_m83") + "; " + this.i18n.toLocalisedDouble(sonnensystemDTO.getExzentrizitaet()) + " e", 20, 40 + 15 * (n3 + 1));
            double d2 = sonnensystemDTO.getEntfernung() * d;
            this.exzentritaet = sonnensystemDTO.getExzentrizitaet();
            double d3 = d2 * this.exzentritaet;
            double d4 = d2 - d3;
            double d5 = d2 * Math.sqrt(1.0 - this.exzentritaet * this.exzentritaet);
            graphics.drawOval((int)((double)n - d4), (int)((double)n2 - d5), (int)(d4 + d3 + d2), (int)(d5 * 2.0));
            ++n3;
        }
    }

    private Color getColor(int n) {
        int n2;
        for (n2 = n; n2 >= this.colorarr.length; n2 -= this.colorarr.length) {
        }
        return this.colorarr[n2];
    }
}

