/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.sonnensystem.monde;

import de.planetensuche.guidesigner.IGuiDesigner;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import de.planetensuche.simulationen.dbmodel.kategorien.api.SonnensystemDTO;
import de.planetensuche.simulationen.sonnensystem.service.ISonnensystemService;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class SonnensystemGui
extends JFrame {
    private final ISonnensystemService service;
    private final ISprachcontainer i18n;
    private final IGuiDesigner guiDesigner;
    private List<SonnensystemDTO> objekte;
    private int screenx;
    private int screeny;
    private double groessteHalbachse;
    private double groessterPeriphel;
    private double exzentritaet;
    private final Color[] colorarr = new Color[]{Color.BLUE, Color.GREEN, Color.CYAN, Color.YELLOW, Color.GRAY, Color.MAGENTA, Color.ORANGE, Color.RED, Color.WHITE, Color.PINK};

    public SonnensystemGui(ISonnensystemService iSonnensystemService, ISprachcontainer iSprachcontainer, IGuiDesigner iGuiDesigner) {
        this.service = iSonnensystemService;
        this.i18n = iSprachcontainer;
        this.guiDesigner = iGuiDesigner;
        this.initComponents();
        this.setCursor(new Cursor(3));
        this.waehleMonde();
        this.setCursor(new Cursor(0));
    }

    private void initComponents() {
        this.setIconImage(IconPoolCustom.LOGO.getImageIcon().getImage());
        this.setAlwaysOnTop(true);
        this.setBackground(new Color(0, 0, 0));
        this.setForeground(new Color(255, 255, 255));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SonnensystemGui.this.formWindowClosing(windowEvent);
            }
        });
        this.setLayout(null);
        this.setExtendedState(6);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.screenx = (int)dimension.getWidth();
        this.screeny = (int)dimension.getHeight();
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    private void berechneGroesseHalbachseUndPerihel() {
        for (SonnensystemDTO sonnensystemDTO : this.objekte) {
            double d;
            if (sonnensystemDTO.getEntfernung() > this.groessteHalbachse) {
                this.groessteHalbachse = sonnensystemDTO.getEntfernung();
            }
            if (!(this.groessterPeriphel < (d = sonnensystemDTO.getEntfernung() - sonnensystemDTO.getEntfernung() * sonnensystemDTO.getExzentrizitaet()))) continue;
            this.groessterPeriphel = d;
        }
    }

    private void waehleMonde() {
        String string2;
        List<String> list = this.service.getPlanetenMitMonden();
        Object[] objectArray = new Object[list.size()];
        int n = 0;
        for (String string2 : list) {
            objectArray[n] = string2;
            ++n;
        }
        Object object = null;
        while (object == null) {
            object = JOptionPane.showInputDialog(null, this.i18n.getString("sim_m100"), this.i18n.getString("sim_m100_titel"), 3, null, objectArray, objectArray[0]);
        }
        string2 = null;
        while (string2 == null || "".equals(string2)) {
            string2 = JOptionPane.showInputDialog(this.i18n.getString("sim_m101"), (Object)"400000");
        }
        double d = this.i18n.parseDouble(string2);
        if (d < 400000.0) {
            d = 500000.0;
            JOptionPane.showMessageDialog(null, this.i18n.getString("sim_f6"), this.i18n.getString("sim_f3_titel"), 0);
        }
        this.objekte = this.service.getMonde(object.toString(), d);
        this.setTitle(this.i18n.getString("sim_m102_1") + " '" + object.toString() + "' " + this.i18n.getString("sim_m102_2") + " " + this.objekte.size() + " " + this.i18n.getString("sim_m102_3"));
        this.berechneGroesseHalbachseUndPerihel();
    }

    private Color getColor(int n) {
        int n2;
        for (n2 = n; n2 >= this.colorarr.length; n2 -= this.colorarr.length) {
        }
        return this.colorarr[n2];
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setFont(this.guiDesigner.getFont(false));
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, this.screenx, this.screeny);
        double d = (double)this.screenx / (this.groessteHalbachse * 2.25);
        int n = (int)(this.groessterPeriphel * d) + 50;
        int n2 = this.screeny / 2;
        graphics.setColor(Color.WHITE);
        graphics.fillOval(n, n2, 2, 2);
        int n3 = 0;
        for (SonnensystemDTO sonnensystemDTO : this.objekte) {
            graphics.setColor(this.getColor(n3));
            graphics.drawString(sonnensystemDTO.getObjektname() + ": " + this.i18n.toLocalisedDouble(sonnensystemDTO.getEntfernung()) + " km; " + this.i18n.toLocalisedDouble(sonnensystemDTO.getExzentrizitaet()) + " e", 20, 40 + 15 * (n3 + 1));
            double d2 = sonnensystemDTO.getEntfernung() * d;
            this.exzentritaet = sonnensystemDTO.getExzentrizitaet();
            double d3 = d2 * this.exzentritaet;
            double d4 = d2 - d3;
            double d5 = d2 * Math.sqrt(1.0 - this.exzentritaet * this.exzentritaet);
            graphics.drawOval((int)((double)n - d4), (int)((double)n2 - d5), (int)(d4 + d3 + d2), (int)(d5 * 2.0));
            ++n3;
        }
    }
}

