/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.sonnensystem.service;

import com.google.inject.Injector;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.IDAOlowAllgemein;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IAsteroidenDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IMondeDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.SonnensystemDTO;
import de.planetensuche.simulationen.sonnensystem.service.ISonnensystemService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class SonnensystemService
implements ISonnensystemService {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final IAsteroidenDAO asteroidenDao;
    private final IDAOlowAllgemein allgemeinDao;
    private final IPlanetenDAO planetenDao;
    private final IMondeDAO mondeDao;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;

    public SonnensystemService(Injector injector) {
        this.asteroidenDao = injector.getInstance(IAsteroidenDAO.class);
        this.allgemeinDao = injector.getInstance(IDAOlowAllgemein.class);
        this.planetenDao = injector.getInstance(IPlanetenDAO.class);
        this.mondeDao = injector.getInstance(IMondeDAO.class);
        this.planetensucheObjektRepository = injector.getInstance(IPlanetensucheObjektRepository.class);
        this.objektnamenRepository = injector.getInstance(IObjektnamenRepository.class);
    }

    @Override
    public SonnensystemDTO getErde() {
        SonnensystemDTO sonnensystemDTO = new SonnensystemDTO();
        try {
            Integer n = this.objektnamenRepository.getIDFuerNamen("Erde", true);
            IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(n);
            sonnensystemDTO.setObjektname(iPlanetensucheObjekt.getObjektNamen().get(0));
            sonnensystemDTO.setEntfernung(iPlanetensucheObjekt.getEntfernung());
            sonnensystemDTO.setExzentrizitaet(iPlanetensucheObjekt.getExzentritaet());
            sonnensystemDTO.setUmlaufszeitInTagen(iPlanetensucheObjekt.getUmlaufszeit());
        }
        catch (SQLException sQLException) {
            this.logging.error(sQLException);
        }
        return sonnensystemDTO;
    }

    @Override
    public List<SonnensystemDTO> getAsteroiden() {
        List<SonnensystemDTO> list = this.asteroidenDao.getAsteroidenZumStern("Sonne");
        return list;
    }

    private List<SonnensystemDTO> createDtos(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = this.allgemeinDao.getDatenFuerSonnensystem(list, arrayList);
        ArrayList<SonnensystemDTO> arrayList2 = new ArrayList<SonnensystemDTO>(arrayList.size());
        if (!bl) {
            return arrayList2;
        }
        for (String string : arrayList) {
            try {
                String[] stringArray = string.split(";");
                SonnensystemDTO sonnensystemDTO = new SonnensystemDTO();
                sonnensystemDTO.setObjektname(stringArray[0]);
                sonnensystemDTO.setEntfernung(Double.parseDouble(stringArray[1]));
                sonnensystemDTO.setExzentrizitaet(Double.parseDouble(stringArray[2]));
                sonnensystemDTO.setUmlaufszeitInTagen(Double.parseDouble(stringArray[3]));
                arrayList2.add(sonnensystemDTO);
            }
            catch (NumberFormatException numberFormatException) {
                this.logging.error(numberFormatException);
            }
        }
        return arrayList2;
    }

    @Override
    public List<String> getPlanetenMitMonden() {
        return this.planetenDao.getPlanetsWithMoons();
    }

    @Override
    public List<SonnensystemDTO> getMonde(String string, double d) {
        List<String> list = this.mondeDao.getMoonsByPlanet(string, d);
        if (list.isEmpty()) {
            return new ArrayList<SonnensystemDTO>(0);
        }
        return this.createDtos(list);
    }
}

