/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.api;

import com.google.inject.Injector;
import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.guidesigner.IPlanetensucheModul;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import de.planetensuche.sternkarte.api.ISternkarte;
import de.planetensuche.sternkarte.dao.SternkartenDaoModules;
import de.planetensuche.sternkarte.dao.SternkartenSucheRepository;
import de.planetensuche.sternkarte.dao.spi.IExoplanetenRepository;
import de.planetensuche.sternkarte.dao.spi.ISternkartenRepository;
import de.planetensuche.sternkarte.impl.Sternkartenlader;
import java.sql.SQLException;

public final class SternkartenFabrik
implements IPlanetensucheModul {
    private Sternkartenlader sternkartenlader;
    private final ISternkartenRepository repository;
    private final IExoplanetenRepository exoplanetRepo;
    private final ISprachcontainer sprache = SprachcontainerFabrik.getSprachcontainer();
    private final KoordinatenFormat koordinatenFormat;
    private final SternkartenSucheRepository suchenRepository;

    public SternkartenFabrik(KoordinatenFormat koordinatenFormat) {
        this.koordinatenFormat = koordinatenFormat;
        Injector injector = BeanFactory.getInjector().createChildInjector(new SternkartenDaoModules());
        this.repository = injector.getInstance(ISternkartenRepository.class);
        this.exoplanetRepo = injector.getInstance(IExoplanetenRepository.class);
        this.suchenRepository = injector.getInstance(SternkartenSucheRepository.class);
    }

    public ISternkartenRepository getRepository() {
        return this.repository;
    }

    public ISternkarte getInstance() throws SQLException {
        this.createAndInitializieStarMap(null);
        return this.sternkartenlader;
    }

    public ISternkarte getInstance(String string) throws SQLException {
        this.createAndInitializieStarMap(string);
        return this.sternkartenlader;
    }

    @Override
    public void showDialog() {
        if (this.sternkartenlader == null) {
            try {
                this.createAndInitializieStarMap(null);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        }
        this.sternkartenlader.show();
    }

    private void createAndInitializieStarMap(String string) throws SQLException {
        if (this.sternkartenlader == null) {
            SternkartenSucheRepository sternkartenSucheRepository = this.suchenRepository;
            this.sternkartenlader = new Sternkartenlader(this.repository, this.exoplanetRepo, this.sprache, this.koordinatenFormat, string, sternkartenSucheRepository);
        } else if (string != null) {
            this.sternkartenlader.gotoObject(string);
        }
    }
}

