/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.dao;

import com.querydsl.core.Tuple;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.impl.SternbildFinder;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.NamenDto;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sternkarte.dao.SternkartenObjektVorverarbeitungDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class DatenveredelungTask
implements Callable<List<SternkartenObjektVorverarbeitungDto>> {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final List<Tuple> liste;
    private final IObjektnamenRepository objektnamenRepository;
    private final Map<Integer, String> sternbildIdUndCode;

    public DatenveredelungTask(List<Tuple> list, IObjektnamenRepository iObjektnamenRepository, Map<Integer, String> map) {
        this.liste = list;
        this.objektnamenRepository = iObjektnamenRepository;
        this.sternbildIdUndCode = map;
    }

    @Override
    public List<SternkartenObjektVorverarbeitungDto> call() throws Exception {
        ArrayList<SternkartenObjektVorverarbeitungDto> arrayList = new ArrayList<SternkartenObjektVorverarbeitungDto>();
        SternbildFinder sternbildFinder = new SternbildFinder();
        Map<Integer, List<NamenDto>> map = this.objektnamenRepository.findNamesByDatenids(this.liste.stream().map(tuple -> tuple.get(0, Integer.class)).collect(Collectors.toList()));
        for (Tuple tuple2 : this.liste) {
            Object object;
            Object object2;
            Object object3;
            String string;
            double d;
            int n = tuple2.get(0, Integer.class);
            String string2 = tuple2.get(1, String.class);
            List<NamenDto> list = map.get(n);
            if (Check.isEmpty(list)) {
                this.logging.warn("objekt mit id " + n + " in kategorie " + string2 + " hat keine namen!");
                continue;
            }
            String string3 = tuple2.get(2, String.class);
            double d2 = tuple2.get(3, Double.class);
            double d3 = tuple2.get(4, Double.class);
            double d4 = tuple2.get(5, Double.class);
            if (d4 == -100.0) {
                d4 = 6.0;
            }
            if ((d = tuple2.get(6, Double.class).doubleValue()) == 0.0) {
                d = 1.0;
            }
            if (ObjektKategorie.STERNE.getKategorienName().equals(string2) && list.size() > 1) {
                string = null;
                object3 = null;
                object2 = null;
                for (NamenDto namenDto : list) {
                    if (namenDto.isIsCommonName()) {
                        object3 = namenDto.getIdentifier();
                        continue;
                    }
                    if (namenDto.isIsBayerFlamsteedGcvs2Name()) {
                        string = namenDto.getIdentifier();
                        continue;
                    }
                    if (object2 != null) continue;
                    object2 = namenDto.getIdentifier();
                }
                object = object3 != null && string != null ? (String)object3 + " (" + string + ")" : (object3 != null && string == null ? (String)object3 + " (" + (String)object2 + ")" : (object3 == null && string != null ? string + " (" + (String)object2 + ")" : this.getObjektnamenGekuerzt(list)));
            } else {
                object = this.getObjektnamenGekuerzt(list);
            }
            object3 = QZt.zt;
            object2 = tuple2.get(((QZt)object3).sternbildid);
            string = object2 == null ? sternbildFinder.getSternbildCodeFuerKoordinate(d2, d3) : this.sternbildIdUndCode.get(object2);
            SternkartenObjektVorverarbeitungDto sternkartenObjektVorverarbeitungDto = new SternkartenObjektVorverarbeitungDto();
            sternkartenObjektVorverarbeitungDto.setDatenId(n);
            sternkartenObjektVorverarbeitungDto.setDecl(d3);
            sternkartenObjektVorverarbeitungDto.setDurchmesser(d);
            sternkartenObjektVorverarbeitungDto.setKategorie(string2);
            sternkartenObjektVorverarbeitungDto.setObjektname((String)object);
            sternkartenObjektVorverarbeitungDto.setRa(d2);
            sternkartenObjektVorverarbeitungDto.setSh(d4);
            sternkartenObjektVorverarbeitungDto.setSptyp(string3);
            sternkartenObjektVorverarbeitungDto.setSternbild(string);
            arrayList.add(sternkartenObjektVorverarbeitungDto);
        }
        return arrayList;
    }

    private String getObjektnamenGekuerzt(List<NamenDto> list) {
        if (list.size() == 1) {
            return list.get(0).getIdentifier();
        }
        StringBuilder stringBuilder = new StringBuilder(list.get(0).getIdentifier());
        stringBuilder.append(" (");
        for (int i = 1; i < list.size() && i != 4; ++i) {
            stringBuilder.append(list.get(i).getIdentifier());
            if (i >= 3 || i >= list.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

