/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.dao;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sternkarte.dao.spi.DecimalCoordinate;
import de.planetensuche.sternkarte.dao.spi.IExoplanetenRepository;
import de.planetensuche.sternkarte.dao.spi.StarmapObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public final class ExoplanetenRepository
implements IExoplanetenRepository {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder dbConnector;
    private final IIdCacheDAO idCacheDao;

    @Inject
    public ExoplanetenRepository(IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.dbConnector = iDatenbankverbinder;
        this.idCacheDao = iIdCacheDAO;
    }

    @Override
    public List<DecimalCoordinate> findStarCoordinatesWithExoplanets(double d) {
        ArrayList<DecimalCoordinate> arrayList = new ArrayList<DecimalCoordinate>();
        try {
            QDaten qDaten = QDaten.daten;
            BooleanExpression booleanExpression = qDaten.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.selectDistinct(qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()))).and(qDaten.sh.gt(-100.0)).and(qDaten.ra.gt(0.0)).and(qDaten.decl.ne(0.0));
            if (d < 100.0) {
                booleanExpression = booleanExpression.and(qDaten.sh.loe(d));
            }
            List list = ((SQLQuery)((SQLQuery)this.dbConnector.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.ra, qDaten.decl}).from((Expression<?>)qDaten)).where(booleanExpression)).fetch();
            for (Tuple tuple : list) {
                arrayList.add(new DecimalCoordinate(tuple.get(qDaten.ra), tuple.get(qDaten.decl)));
            }
        }
        catch (Exception exception) {
            this.logging.error("findStarCoordinatesWithExoplanets(" + d + ")", exception);
        }
        return arrayList;
    }

    @Override
    public List<StarmapObject> findStarsWithExoplanets(double d) {
        ArrayList<StarmapObject> arrayList = new ArrayList<StarmapObject>();
        try {
            QDaten qDaten = QDaten.daten;
            QNamen qNamen = QNamen.namen1;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.dbConnector.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.ra, qDaten.decl, qDaten.sh, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.selectDistinct(qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()))).and(qDaten.sh.loe(d)).and(qDaten.sh.gt(-100.0)).and(qDaten.ra.gt(0.0)).and(qDaten.decl.ne(0.0)))).fetch();
            for (Tuple tuple : list) {
                StarmapObject starmapObject = new StarmapObject();
                starmapObject.setCoordinate(new DecimalCoordinate(tuple.get(qDaten.ra), tuple.get(qDaten.decl)));
                starmapObject.setVisualMag(tuple.get(qDaten.sh));
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(tuple.get(qNamen.namen));
                starmapObject.setObjectNames(arrayList2);
                arrayList.add(starmapObject);
            }
        }
        catch (Exception exception) {
            this.logging.error("findStarsWithExoplanets(" + d + ")", exception);
        }
        return arrayList;
    }

    @Override
    public LinkedHashMap<String, List<StarmapObject>> findStarsWithExoplanetsGroupByDiscovererTeamOrTelescope(double d) {
        LinkedHashMap<String, List<StarmapObject>> linkedHashMap = new LinkedHashMap<String, List<StarmapObject>>();
        try {
            Serializable serializable;
            Object object;
            Object object2;
            Object object32;
            QDaten qDaten = QDaten.daten;
            QNamen qNamen = QNamen.namen1;
            QEntdecker qEntdecker = QEntdecker.entdecker;
            QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.dbConnector.getQueryFactory().selectDistinct(new Expression[]{qDaten.zugehoerigkeit, qEntdecker.nachname}).from((Expression<?>)qDaten)).join((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).join((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid).and(qEntdecker.typ.in((Collection<Integer>)Arrays.asList(EntdeckerTyp.PROJECT.getType(), EntdeckerTyp.SPACE_TELESCOPE.getType()))))).where(qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()))).fetch();
            HashMap<Integer, ArrayList<String>> hashMap = new HashMap<Integer, ArrayList<String>>();
            for (Object object32 : list) {
                object2 = object32.get(qDaten.zugehoerigkeit);
                object = object32.get(qEntdecker.nachname);
                serializable = (ArrayList<String>)hashMap.get(object2);
                if (serializable == null) {
                    serializable = new ArrayList<String>();
                    hashMap.put((Integer)object2, (ArrayList<String>)serializable);
                }
                serializable.add((String)object);
            }
            Object object4 = qDaten.id.in(hashMap.keySet()).and(qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsSterne()).and(qDaten.sh.gt(-100.0)).and(qDaten.ra.gt(0.0)).and(qDaten.decl.ne(0.0)));
            if (d < 100.0) {
                object4 = ((BooleanExpression)object4).and(qDaten.sh.loe(d));
            }
            object32 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.dbConnector.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.ra, qDaten.decl, qDaten.sh, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where((Predicate)object4)).fetch();
            object2 = object32.iterator();
            while (object2.hasNext()) {
                object = (Tuple)object2.next();
                serializable = object.get(qDaten.id);
                List list2 = (List)hashMap.get(serializable);
                if (list2 == null) continue;
                for (String string : list2) {
                    if (linkedHashMap.get(string) == null) {
                        linkedHashMap.put(string, new ArrayList());
                    }
                    StarmapObject starmapObject = new StarmapObject();
                    starmapObject.setCoordinate(new DecimalCoordinate(object.get(qDaten.ra), object.get(qDaten.decl)));
                    starmapObject.setVisualMag(object.get(qDaten.sh));
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(object.get(qNamen.namen));
                    starmapObject.setObjectNames(arrayList);
                    linkedHashMap.get(string).add(starmapObject);
                    hashMap.remove(serializable);
                }
            }
        }
        catch (Exception exception) {
            this.logging.error("findStarsWithExoplanetsGroupByDiscovererTeamOrTelescope(" + d + ")", exception);
        }
        return linkedHashMap;
    }
}

