/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.dao;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ISternbild;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.ISternkartenBasisDao;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IObjekttypenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import de.planetensuche.datenbankkern.api.repos.IZwischentabellenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.impl.cache.IdCacheDAO;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sternkarte.dao.BayerNameToGreekService;
import de.planetensuche.sternkarte.dao.DatenveredelungTask;
import de.planetensuche.sternkarte.dao.spi.DecimalCoordinate;
import de.planetensuche.sternkarte.dao.spi.ISternkartenRepository;
import de.planetensuche.sternkarte.impl.Sternkartenobjekt;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class SternkartenRepository
implements ISternkartenRepository {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final ISternkartenBasisDao basisDao;
    private final IObjekttypenRepository objekttypenRepository;
    private final IZwischentabellenRepository zwischentabellenRepository;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final IDatenbankverbinder datenbankverbinder;
    private final ISternbilderRepository sternbilderRepository;
    private final IdCacheDAO idCacheDAO;
    private final Map<Integer, String> sternbildIdUndCode;

    @Inject
    public SternkartenRepository(ISternkartenBasisDao iSternkartenBasisDao, IObjekttypenRepository iObjekttypenRepository, IZwischentabellenRepository iZwischentabellenRepository, IPlanetensucheObjektRepository iPlanetensucheObjektRepository, IObjektnamenRepository iObjektnamenRepository, IDatenbankverbinder iDatenbankverbinder, ISternbilderRepository iSternbilderRepository, IdCacheDAO idCacheDAO) {
        this.basisDao = iSternkartenBasisDao;
        this.objekttypenRepository = iObjekttypenRepository;
        this.zwischentabellenRepository = iZwischentabellenRepository;
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.objektnamenRepository = iObjektnamenRepository;
        this.datenbankverbinder = iDatenbankverbinder;
        this.sternbilderRepository = iSternbilderRepository;
        this.idCacheDAO = idCacheDAO;
        this.sternbildIdUndCode = new HashMap<Integer, String>();
    }

    @Override
    public boolean getSternkarte(double d, double d2, Sternkartenobjekt sternkartenobjekt) {
        QDaten qDaten = QDaten.daten;
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QKategorie qKategorie = QKategorie.kategorie;
        QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
        QZt qZt = QZt.zt;
        try {
            List<Tuple> list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qKategorie.name, qSpektraltyp.typ, qDaten.ra, qDaten.decl, qDaten.sh, qDaten.durchmesser, qZt.sternbildid}).from(new Expression[]{qDaten, qKategorie, qObjekttypen})).leftJoin((EntityPath)qSpektraltyp)).on((Predicate)qDaten.spektralklasse.eq(qSpektraltyp.id))).leftJoin((EntityPath)qZt)).on((Predicate)qZt.datenid.eq(qDaten.id))).where(qDaten.sh.between(d, d2).and(qDaten.ra.ne(0.0)).and(qDaten.decl.ne(0.0)).and(qDaten.objektid.eq(qObjekttypen.id)).and(qObjekttypen.kategorieid.eq(qKategorie.id)))).fetch();
            boolean bl = this.getSternkarteObjekteFuerQuery(list, sternkartenobjekt);
            if (bl && this.getSternkarteObjekteFuerQuery(list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qKategorie.name, qSpektraltyp.typ, qDaten.ra, qDaten.decl, qDaten.sh, qDaten.durchmesser, qZt.sternbildid}).from(new Expression[]{qDaten, qKategorie, qObjekttypen})).leftJoin((EntityPath)qSpektraltyp)).on((Predicate)qDaten.spektralklasse.eq(qSpektraltyp.id))).leftJoin((EntityPath)qZt)).on((Predicate)qZt.datenid.eq(qDaten.id))).where(qObjekttypen.typ.eq("Dunkelnebel").and(qDaten.objektid.eq(qObjekttypen.id)).and(qObjekttypen.kategorieid.eq(qKategorie.id)).and(qDaten.sh.eq(-100.0)).and(qDaten.ra.ne(0.0)).and(qDaten.decl.ne(0.0)))).fetch(), sternkartenobjekt)) {
                return true;
            }
        }
        catch (Exception exception) {
            this.logger.error(exception);
        }
        return false;
    }

    private boolean getSternkarteObjekteFuerQuery(List<Tuple> list, Sternkartenobjekt sternkartenobjekt) {
        try {
            List<ISternbild> list3;
            if (this.sternbildIdUndCode.isEmpty()) {
                list3 = this.sternbilderRepository.findAll();
                list3.forEach(iSternbild -> this.sternbildIdUndCode.put(iSternbild.getId(), iSternbild.getSternbildCode()));
            }
            list3 = new ArrayList<ISternbild>();
            int n = list.size() / Runtime.getRuntime().availableProcessors();
            List<List<Tuple>> list4 = list.size() > 400 ? Lists.partition(list, n) : Arrays.asList(list);
            for (List<Tuple> list22 : list4) {
                list3.add((ISternbild)((Object)new DatenveredelungTask(list22, this.objektnamenRepository, this.sternbildIdUndCode)));
            }
            ExecutorService executorService = Executors.newFixedThreadPool(list3.size());
            List list2 = executorService.invokeAll(list3, 15L, TimeUnit.SECONDS);
            executorService.shutdown();
            for (Future future : list2) {
                List list5 = (List)future.get(20L, TimeUnit.SECONDS);
                list5.forEach(sternkartenObjektVorverarbeitungDto -> sternkartenobjekt.add(sternkartenObjektVorverarbeitungDto.getDatenId(), sternkartenObjektVorverarbeitungDto.getKategorie(), sternkartenObjektVorverarbeitungDto.getRa(), sternkartenObjektVorverarbeitungDto.getDecl(), sternkartenObjektVorverarbeitungDto.getSh(), sternkartenObjektVorverarbeitungDto.getSptyp(), sternkartenObjektVorverarbeitungDto.getDurchmesser(), sternkartenObjektVorverarbeitungDto.getObjektname(), sternkartenObjektVorverarbeitungDto.getSternbild()));
            }
            executorService.shutdownNow();
            return true;
        }
        catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException exception) {
            this.logger.error(exception);
            return false;
        }
    }

    @Override
    public List<String> getNamesSternkarte() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(this.idCacheDAO.getObjekttypenidsBraunezwerge());
        arrayList.addAll(this.idCacheDAO.getObjekttypenidsGalaxienhaufen());
        arrayList.addAll(this.idCacheDAO.getObjekttypenidsGalaxienundnebel());
        arrayList.addAll(this.idCacheDAO.getObjekttypenidsSonstiges());
        arrayList.addAll(this.idCacheDAO.getObjekttypenidsSterne());
        arrayList.addAll(this.idCacheDAO.getObjekttypenidsSternhaufen());
        QNamen qNamen = QNamen.namen1;
        QDaten qDaten = QDaten.daten;
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qNamen)).join((EntityPath)qDaten)).on((Predicate)qNamen.datenid.eq(qDaten.id))).where(qDaten.objektid.in((Collection<Integer>)arrayList).and(qDaten.sh.gt(-100.0)).and(qDaten.ra.gt(-100.0)).and(qDaten.decl.gt(-100.0)))).fetch();
    }

    @Override
    public List<String> getSternbilderNamen(SternbildSprache sternbildSprache) throws SQLException {
        return this.basisDao.getSternbilderNamen(sternbildSprache);
    }

    @Override
    public boolean getSternbildDatenMinimal(ISternbild iSternbild, String string) throws SQLException {
        return this.basisDao.getSternbildDatenMinimal(iSternbild, string);
    }

    @Override
    public SternbildSprache getSternbildsprache() {
        return this.basisDao.getSternbildsprache();
    }

    @Override
    public Map<String, DecimalCoordinate> loadStarsUpTo6Mag() {
        try {
            QDaten qDaten = QDaten.daten;
            QNamen qNamen = QNamen.namen1;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.ra, qDaten.decl, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qNamen.datenid.eq(qDaten.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsSterne()).and(qDaten.sh.between(-2.0, 6.01)))).fetch();
            this.logger.debug("found " + list.size() + " star names between -2 and 6 mag");
            HashMap<String, DecimalCoordinate> hashMap = new HashMap<String, DecimalCoordinate>();
            for (Tuple tuple : list) {
                Double d = tuple.get(qDaten.ra);
                Double d2 = tuple.get(qDaten.decl);
                DecimalCoordinate decimalCoordinate = new DecimalCoordinate(d, d2);
                String string = tuple.get(qNamen.namen);
                if (string != null) {
                    hashMap.put(string, decimalCoordinate);
                    continue;
                }
                Integer n = tuple.get(qDaten.id);
                List<String> list2 = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.KEINE_SORTIERUNG);
                if (list2 == null || list2.isEmpty()) {
                    this.logger.error("Objekt mit id " + n + " hat keine namen?", null);
                    continue;
                }
                this.logger.warn("objekt id " + n + " (" + Arrays.toString(list2.toArray()) + ") falsch gejoint?");
                hashMap.put(list2.getFirst(), decimalCoordinate);
            }
            return hashMap;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("loadStarsUpTo6Mag()", runtimeException);
            return null;
        }
    }

    @Override
    public String getObjekttypForObjekt(String string) throws SQLException {
        return this.objekttypenRepository.getObjekttypFuerObjekt(string);
    }

    @Override
    public Integer getIDFuerNamen(String string) throws SQLException {
        return this.objektnamenRepository.getIDFuerNamen(string, true);
    }

    @Override
    public Set<String> getBilderFuerDatenid(int n) throws SQLException {
        return this.zwischentabellenRepository.getBilder(n);
    }

    @Override
    public IPlanetensucheObjekt read(Integer n) throws SQLException {
        return this.planetensucheObjektRepository.read(n);
    }

    @Override
    public IPlanetensucheObjekt readCoordsShOnly(String string) throws SQLException {
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        Daten daten = (Daten)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qNamen.namen.eq(string))).fetchFirst();
        if (daten == null) {
            return null;
        }
        PlanetensucheObjekt planetensucheObjekt = new PlanetensucheObjekt();
        planetensucheObjekt.setScheinbareHelligkeit(daten.getSh());
        planetensucheObjekt.setRA(daten.getRa());
        planetensucheObjekt.setDECL(daten.getDecl());
        return planetensucheObjekt;
    }

    @Override
    public List<IPlanetensucheObjekt> readCoordsShOnly(List<String> list) throws SQLException {
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qNamen.namen.in(list))).fetch();
        if (list2 == null) {
            return null;
        }
        ArrayList<IPlanetensucheObjekt> arrayList = new ArrayList<IPlanetensucheObjekt>();
        for (Daten daten : list2) {
            PlanetensucheObjekt planetensucheObjekt = new PlanetensucheObjekt();
            planetensucheObjekt.setScheinbareHelligkeit(daten.getSh());
            planetensucheObjekt.setRA(daten.getRa());
            planetensucheObjekt.setDECL(daten.getDecl());
            arrayList.add(planetensucheObjekt);
        }
        return arrayList;
    }

    @Override
    public Map<Integer, String> loadBayerFlamsteedGcvs2Names() {
        try {
            QNamen qNamen = QNamen.namen1;
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qNamen.datenid, qNamen.namen}).from((Expression<?>)qNamen)).where(qNamen.isbayerflamsteedgcvs2.isTrue().and(qNamen.namen.endsWith(" b").not()))).fetch();
            this.logger.debug("found " + list.size() + " bayer and flamsteed stars");
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            BayerNameToGreekService bayerNameToGreekService = new BayerNameToGreekService();
            for (Tuple tuple : list) {
                Integer n = tuple.get(qNamen.datenid);
                String string = tuple.get(qNamen.namen);
                string = this.resolveShortName(string, bayerNameToGreekService);
                String string2 = (String)hashMap.get(n);
                if (string2 == null) {
                    hashMap.put(n, string);
                    continue;
                }
                if (Character.isLetter(string2.charAt(0))) continue;
                hashMap.put(n, string);
            }
            return hashMap;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("loadBayerFlamsteedNames()", runtimeException);
            return Collections.emptyMap();
        }
    }

    private String resolveShortName(String string, BayerNameToGreekService bayerNameToGreekService) {
        String string2 = string;
        String[] stringArray = string2.split(" ");
        if (stringArray.length > 0 && Character.isLetter((string2 = stringArray[0]).charAt(0)) && string2.length() >= 2) {
            string2 = bayerNameToGreekService.resolveFromBayerName(string2);
            this.logger.trace("aus '" + string + "' wird '" + string2 + "'");
        }
        return string2;
    }
}

