/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.dao;

import com.google.inject.Inject;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.core.db.SearchableDataSource;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.repos.ObjektnamenRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SternkartenSucheRepository
implements SearchableDataSource {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final ObjektnamenRepository objektnamenRepository;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public SternkartenSucheRepository(ObjektnamenRepository objektnamenRepository, IDatenbankverbinder iDatenbankverbinder) {
        this.objektnamenRepository = objektnamenRepository;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public int count(String string) throws SQLException {
        return this.objektnamenRepository.count(string);
    }

    @Override
    public List<String> search(String string) throws SQLException {
        if (Check.isEmpty(string)) {
            return new ArrayList<String>();
        }
        long l = System.currentTimeMillis();
        QNamen qNamen = QNamen.namen1;
        QDaten qDaten = QDaten.daten;
        List<String> list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qNamen)).leftJoin((EntityPath)qDaten)).on((Predicate)qNamen.datenid.eq(qDaten.id))).where(qNamen.namen.lower().startsWith(string.trim().toLowerCase()).and(qDaten.sh.goe(-2.0)).and(qDaten.ra.gt(0.0).and(qDaten.decl.gt(-100.0))))).fetch();
        if (this.logger.isDebugEnabled()) {
            long l2 = System.currentTimeMillis() - l;
            this.logger.trace("search(" + string + ") needs " + l2 + " ms, result=" + Arrays.toString(list.toArray()));
        }
        return list;
    }
}

