/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.impl;

import com.google.common.io.Files;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sternkarte.dao.spi.DecimalCoordinate;
import de.planetensuche.sternkarte.dao.spi.ISternkartenRepository;
import de.planetensuche.sternkarte.impl.Konfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SternbilderfigurenLader {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final ISternkartenRepository repository;
    private final Konfiguration sternkarteKonfiguration;

    public SternbilderfigurenLader(ISternkartenRepository iSternkartenRepository, Konfiguration konfiguration) {
        this.repository = iSternkartenRepository;
        this.sternkarteKonfiguration = konfiguration;
    }

    public void ladeSternbilderDefinitionen(List<List<Double>> list, List<List<Double>> list2) throws IOException {
        Map<String, DecimalCoordinate> map = this.repository.loadStarsUpTo6Mag();
        this.logger.debug("process map of " + map.size() + " star names");
        List<String> list3 = Files.readLines(new File("database" + File.separator + "sternbilder.dat"), Charset.forName("UTF-8"));
        for (String string : list3) {
            String[] stringArray;
            if (string.startsWith("//") || (stringArray = string.split("-->")).length != 2) continue;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            DecimalCoordinate decimalCoordinate = map.get(string2);
            DecimalCoordinate decimalCoordinate2 = map.get(string3);
            if (decimalCoordinate == null) {
                decimalCoordinate = this.ladeStern(string2);
            }
            if (decimalCoordinate2 == null) {
                decimalCoordinate2 = this.ladeStern(string3);
            }
            if (decimalCoordinate == null) {
                this.logger.error("star " + string2 + " not found!", null);
                continue;
            }
            if (decimalCoordinate2 == null) {
                this.logger.error("star " + string3 + " not found!", null);
                continue;
            }
            arrayList.add(decimalCoordinate.getRa());
            arrayList.add(decimalCoordinate.getDecl() * (double)this.sternkarteKonfiguration.getTeilerDECL());
            arrayList2.add(decimalCoordinate2.getRa());
            arrayList2.add(decimalCoordinate2.getDecl() * (double)this.sternkarteKonfiguration.getTeilerDECL());
            if (arrayList.size() != 2 || arrayList2.size() != 2) continue;
            if ((Double)arrayList.get(1) < 0.0) {
                arrayList.set(1, (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0 - (Double)arrayList.get(1) * -1.0);
            } else if ((Double)arrayList.get(1) >= 0.0) {
                arrayList.set(1, (Double)arrayList.get(1) + (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0);
            }
            if ((Double)arrayList2.get(1) < 0.0) {
                arrayList2.set(1, (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0 - (Double)arrayList2.get(1) * -1.0);
            } else if ((Double)arrayList2.get(1) >= 0.0) {
                arrayList2.set(1, (Double)arrayList2.get(1) + (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0);
            }
            arrayList.set(0, (Double)arrayList.get(0) * (double)this.sternkarteKonfiguration.getTeilerRA());
            arrayList2.set(0, (Double)arrayList2.get(0) * (double)this.sternkarteKonfiguration.getTeilerRA());
            list.add(arrayList);
            list2.add(arrayList2);
        }
    }

    private DecimalCoordinate ladeStern(String string) {
        try {
            IPlanetensucheObjekt iPlanetensucheObjekt = this.repository.readCoordsShOnly(string);
            if (iPlanetensucheObjekt == null) {
                return null;
            }
            DecimalCoordinate decimalCoordinate = new DecimalCoordinate(iPlanetensucheObjekt.getRA(), iPlanetensucheObjekt.getDECL());
            return decimalCoordinate;
        }
        catch (IllegalArgumentException | SQLException exception) {
            return null;
        }
    }
}

