/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.impl;

import com.google.common.io.Files;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;

public final class SternkarteSETI {
    private final ISprachcontainer sprache;
    private final ILogging logging;
    private File verzeichnisWUs;
    private List<Double> ra;
    private List<Double> decl;
    private boolean isGeladen;

    public SternkarteSETI(ISprachcontainer iSprachcontainer) {
        this.sprache = iSprachcontainer;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.verzeichnisWUs = new File("C:" + File.separator + "Dokumente und Einstellungen" + File.separator + "All Users" + File.separator + "Anwendungsdaten" + File.separator + "BOINC" + File.separator + "projects" + File.separator + "setiathome.berkeley.edu");
        this.ra = new ArrayList<Double>();
        this.decl = new ArrayList<Double>();
        try {
            File file = new File("conf" + File.separator + "seti.conf");
            if (file.exists()) {
                List<String> list = Files.readLines(file, Charset.forName("UTF-8"));
                this.verzeichnisWUs = new File(list.get(0));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logging.error(fileNotFoundException);
        }
        catch (IOException iOException) {
            this.logging.error(iOException);
        }
    }

    public boolean isGeladen() {
        return this.isGeladen;
    }

    public List<Double> getDecl() {
        return this.decl;
    }

    public List<Double> getRa() {
        return this.ra;
    }

    public boolean ladeKoordinaten() {
        try {
            File[] fileArray;
            block17: {
                if (!this.verzeichnisWUs.exists()) {
                    fileArray = new JFileChooser();
                    File file = new File("");
                    fileArray.setCurrentDirectory(file);
                    fileArray.setSize(250, 250);
                    fileArray.setVisible(true);
                    fileArray.setDialogTitle(this.sprache.getString("sim_m131"));
                    fileArray.setFileSelectionMode(1);
                    fileArray.setMultiSelectionEnabled(false);
                    fileArray.setSelectedFile(null);
                    fileArray.setFileFilter(this.createFileFilterForSetiFolder());
                    int n = fileArray.showOpenDialog(null);
                    if (n == 0) {
                        this.verzeichnisWUs = fileArray.getSelectedFile();
                        try {
                            File file2 = new File("conf" + File.separator + "seti.conf");
                            if (!file2.exists()) break block17;
                            try (OutputStreamWriter object = new OutputStreamWriter((OutputStream)new FileOutputStream(file2, false), Charset.forName("UTF-8"));){
                                object.write(fileArray.getSelectedFile().getAbsolutePath());
                            }
                        }
                        catch (IOException iOException) {
                            this.logging.error(iOException);
                        }
                    }
                }
            }
            fileArray = this.verzeichnisWUs.listFiles(this.createFileFilterForSetiWorkUnits());
            if (this.verzeichnisWUs.exists()) {
                block11: for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        List<String> list = Files.readLines(fileArray[i], Charset.forName("UTF-8"));
                        for (String string : list) {
                            double d;
                            String string2 = string.trim();
                            if (string2.startsWith("<start_ra>")) {
                                d = Double.parseDouble(string2.substring(10, string2.length() - 11));
                                this.ra.add(d);
                                continue;
                            }
                            if (!string2.startsWith("<start_dec>")) continue;
                            d = Double.parseDouble(string2.substring(11, string2.length() - 12));
                            this.decl.add(d);
                            continue block11;
                        }
                        continue;
                    }
                    catch (IOException iOException) {
                        this.logging.error(iOException);
                    }
                }
                this.isGeladen = true;
                return true;
            }
        }
        catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
            this.logging.error(runtimeException);
        }
        return false;
    }

    private FileFilter createFileFilterForSetiWorkUnits() {
        return new FileFilter(this){

            @Override
            public boolean accept(File file) {
                return file.isFile() && this.isFileAnSetiWorkUnit(file.getName());
            }

            private boolean isFileAnSetiWorkUnit(String string) {
                for (int i = 0; i < 10; ++i) {
                    if (!string.endsWith(Integer.toString(i))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private javax.swing.filechooser.FileFilter createFileFilterForSetiFolder() {
        return new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || "setiathome.berkeley.edu".equals(file.getName());
            }

            @Override
            public String getDescription() {
                return SternkarteSETI.this.sprache.getString("sim_m132");
            }
        };
    }
}

