/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.impl;

import com.google.common.io.Files;
import de.planetensuche.core.db.SearchableDataSource;
import de.planetensuche.datamodel.api.ISternbild;
import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.impl.Sternbild;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.statusfenster.StatusGui;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sternkarte.api.ISternkarte;
import de.planetensuche.sternkarte.dao.spi.DecimalCoordinate;
import de.planetensuche.sternkarte.dao.spi.IExoplanetenRepository;
import de.planetensuche.sternkarte.dao.spi.ISternkartenRepository;
import de.planetensuche.sternkarte.dao.spi.StarmapObject;
import de.planetensuche.sternkarte.impl.Konfiguration;
import de.planetensuche.sternkarte.impl.SternbilderfigurenLader;
import de.planetensuche.sternkarte.impl.Sternkartenobjekt;
import de.planetensuche.sternkarte.impl.SternmusterJahreszeit;
import de.planetensuche.sternkarte.impl.gui.SternkarteGui;
import de.planetensuche.sternkarte.impl.gui.SternkarteParameterDto;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.tuple.Pair;

public final class Sternkartenlader
extends Thread
implements ISternkarte {
    private final ISternkartenRepository repository;
    private final IExoplanetenRepository exoplanetRepo;
    private final ISprachcontainer sprache;
    private final ILogging logging;
    private final List<List<Double>> sterneLinkeSeiteSternbilder;
    private final List<List<Double>> sterneRechteSeiteSternbilder;
    private final Map<SternmusterJahreszeit, List<Pair<Double, Double>>> datenpunkteSternmuster;
    private final Konfiguration sternkarteKonfiguration;
    private final KoordinatenFormat koordinatenFormat;
    private SternkarteGui sternkarte;
    private final String objektnameNachLadenAnzeigen;
    private final SearchableDataSource searchableDataSource;

    public Sternkartenlader(ISternkartenRepository iSternkartenRepository, IExoplanetenRepository iExoplanetenRepository, ISprachcontainer iSprachcontainer, KoordinatenFormat koordinatenFormat, String string, SearchableDataSource searchableDataSource) {
        this.repository = iSternkartenRepository;
        this.exoplanetRepo = iExoplanetenRepository;
        this.sprache = iSprachcontainer;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.koordinatenFormat = koordinatenFormat;
        this.objektnameNachLadenAnzeigen = string;
        this.sterneLinkeSeiteSternbilder = new ArrayList<List<Double>>(600);
        this.sterneRechteSeiteSternbilder = new ArrayList<List<Double>>(600);
        this.datenpunkteSternmuster = new HashMap<SternmusterJahreszeit, List<Pair<Double, Double>>>();
        this.sternkarteKonfiguration = new Konfiguration();
        this.searchableDataSource = searchableDataSource;
    }

    @Override
    public void run() {
        StatusGui statusGui = new StatusGui();
        statusGui.setTitle(this.sprache.getString("sim_m139"));
        statusGui.setVisible(true);
        try {
            Object object;
            long l = System.currentTimeMillis();
            statusGui.setLauftext(this.sprache.getString("sim_m140"));
            List<ISternbild> list = this.ladeSternbilderBezeichnungen();
            statusGui.setFortschritt(10);
            this.logging.info("Sternbilder geladen nach " + (System.currentTimeMillis() - l) + " ms");
            statusGui.setLauftext(this.sprache.getString("sim_m141"));
            List<DecimalCoordinate> list2 = this.exoplanetRepo.findStarCoordinatesWithExoplanets(100.0);
            this.logging.info(list2.size() + " Exoplaneten geladen nach " + (System.currentTimeMillis() - l) + " ms");
            LinkedHashMap<String, List<StarmapObject>> linkedHashMap = this.exoplanetRepo.findStarsWithExoplanetsGroupByDiscovererTeamOrTelescope(100.0);
            this.logging.info(linkedHashMap.size() + " Entdeckerteams und Weltraumteleskope von Exoplaneten geladen nach " + (System.currentTimeMillis() - l) + " ms");
            statusGui.setFortschritt(20);
            statusGui.setLauftext(this.sprache.getString("sim_m161"));
            Map<Integer, String> map = this.repository.loadBayerFlamsteedGcvs2Names();
            statusGui.setFortschritt(30);
            this.logging.info("bayer und flamsteed namen geladen nach " + (System.currentTimeMillis() - l) + " ms");
            statusGui.setLauftext(this.sprache.getString("sim_m142"));
            Sternkartenobjekt sternkartenobjekt = new Sternkartenobjekt();
            this.repository.getSternkarte(-2.0, 7.25, sternkartenobjekt);
            sternkartenobjekt.setBisMagGeladen(7.25);
            statusGui.setFortschritt(60);
            this.logging.info(sternkartenobjekt.getNumberOfEntries() + " Objekte geladen nach " + (System.currentTimeMillis() - l) + " ms");
            statusGui.setLauftext(this.sprache.getString("sim_m144"));
            try {
                object = new SternbilderfigurenLader(this.repository, this.sternkarteKonfiguration);
                ((SternbilderfigurenLader)object).ladeSternbilderDefinitionen(this.sterneLinkeSeiteSternbilder, this.sterneRechteSeiteSternbilder);
            }
            catch (IOException | IndexOutOfBoundsException exception) {
                this.zeigeUndLoggeFehlermeldungBeimSternbilderladen(exception);
            }
            statusGui.setFortschritt(85);
            this.logging.info("Sternbilderfiguren mit " + this.sterneLinkeSeiteSternbilder.size() + " Linien geladen nach " + (System.currentTimeMillis() - l) + " ms");
            this.ladeSternmusterDefinitionen();
            statusGui.setFortschritt(95);
            this.logging.info("Sternmuster geladen nach " + (System.currentTimeMillis() - l) + " ms");
            object = new SternkarteParameterDto();
            ((SternkarteParameterDto)object).setRepository(this.repository);
            ((SternkarteParameterDto)object).setIsprache(this.sprache);
            ((SternkarteParameterDto)object).setSternbildObjekteListe(list);
            ((SternkarteParameterDto)object).setPlanetenListe(list2);
            ((SternkarteParameterDto)object).setExoplanetsByDiscoverer(linkedHashMap);
            ((SternkarteParameterDto)object).setSternkartenObjekt(sternkartenobjekt);
            ((SternkarteParameterDto)object).setSterneLinkeSeiteSternbild(this.sterneLinkeSeiteSternbilder);
            ((SternkarteParameterDto)object).setSterneRechteSeiteSternbild(this.sterneRechteSeiteSternbilder);
            ((SternkarteParameterDto)object).setDatenpunkteSternmuster(this.datenpunkteSternmuster);
            ((SternkarteParameterDto)object).setSternkartenkonfiguration(this.sternkarteKonfiguration);
            ((SternkarteParameterDto)object).setKoordinatenFormat(this.koordinatenFormat);
            ((SternkarteParameterDto)object).setSearchableDataSource(this.searchableDataSource);
            ((SternkarteParameterDto)object).setBayerFlamsteedNames(map);
            this.sternkarte = new SternkarteGui((SternkarteParameterDto)object);
            this.logging.info("Sternenkarte komplett geladen in insgesamt " + (System.currentTimeMillis() - l) + " ms");
            if (this.objektnameNachLadenAnzeigen != null) {
                this.sternkarte.springeZuObjekt(this.objektnameNachLadenAnzeigen);
            }
            this.sternkarte.setVisible(true);
        }
        catch (IOException | SQLException exception) {
            this.loggeUndZeigeFehlermeldungBeimSternkarteladen(exception);
        }
        statusGui.dispose();
    }

    public SternkarteGui getSternkarte() {
        return this.sternkarte;
    }

    private void loggeUndZeigeFehlermeldungBeimSternkarteladen(Exception exception) {
        this.logging.error(exception);
        JOptionPane.showMessageDialog(null, this.sprache.getString("sim_f8"), this.sprache.getString("sim_f8_titel"), 0);
    }

    private List<ISternbild> ladeSternbilderBezeichnungen() throws SQLException {
        List<String> list = this.repository.getSternbilderNamen(this.repository.getSternbildsprache());
        list.remove("unbekannt");
        list.remove("unknown");
        ArrayList<ISternbild> arrayList = new ArrayList<ISternbild>(list.size());
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            Sternbild sternbild = new Sternbild();
            String string = iterator.next();
            if (!this.repository.getSternbildDatenMinimal(sternbild, string)) continue;
            arrayList.add(sternbild);
        }
        return arrayList;
    }

    private void ladeSternmusterDefinitionen() throws IOException {
        try {
            File file = new File("database" + File.separator + "sternmuster.dat");
            if (!file.exists()) {
                this.logging.warn("keine Sternmuster-Datei gefunden!");
                return;
            }
            Map<String, DecimalCoordinate> map = this.repository.loadStarsUpTo6Mag();
            this.logging.debug("process map of " + map.size() + " star names");
            String[] stringArray = null;
            List<String> list = Files.readLines(file, Charset.forName("UTF-8"));
            for (String string : list) {
                String[] stringArray2;
                if (string.startsWith("//")) {
                    stringArray2 = SternmusterJahreszeit.ausKommentarText(string);
                    if (stringArray2 == null) continue;
                    stringArray = stringArray2;
                    continue;
                }
                if (stringArray == null || (stringArray2 = string.split("-->")).length != 2) continue;
                String string2 = stringArray2[0];
                String string3 = stringArray2[1];
                DecimalCoordinate decimalCoordinate = map.get(string2);
                DecimalCoordinate decimalCoordinate2 = map.get(string3);
                if (decimalCoordinate == null) {
                    this.logging.error("star " + string2 + " not found!", null);
                    continue;
                }
                if (decimalCoordinate2 == null) {
                    this.logging.error("star " + string3 + " not found!", null);
                    continue;
                }
                double d = decimalCoordinate.getRa();
                double d2 = decimalCoordinate.getDecl() * (double)this.sternkarteKonfiguration.getTeilerDECL();
                double d3 = decimalCoordinate2.getRa();
                double d4 = decimalCoordinate2.getDecl() * (double)this.sternkarteKonfiguration.getTeilerDECL();
                if (d2 < 0.0) {
                    d2 = (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0 - d2 * -1.0;
                } else if (d2 >= 0.0) {
                    d2 += (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0;
                }
                if (d4 < 0.0) {
                    d4 = (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0 - d4 * -1.0;
                } else if (d4 >= 0.0) {
                    d4 += (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0;
                }
                d *= (double)this.sternkarteKonfiguration.getTeilerRA();
                d3 *= (double)this.sternkarteKonfiguration.getTeilerRA();
                List<Pair<Double, Double>> list2 = this.datenpunkteSternmuster.get(stringArray);
                if (list2 == null) {
                    list2 = new ArrayList<Pair<Double, Double>>();
                    this.datenpunkteSternmuster.put((SternmusterJahreszeit)stringArray, list2);
                }
                list2.add(Pair.of(d, d2));
                list2.add(Pair.of(d3, d4));
            }
            this.logging.debug(this.datenpunkteSternmuster.size() + " jahreszeiten/sternmuster geladen");
        }
        catch (IOException | IndexOutOfBoundsException exception) {
            this.zeigeUndLoggeFehlermeldungBeimSternbilderladen(exception);
        }
    }

    private void zeigeUndLoggeFehlermeldungBeimSternbilderladen(Exception exception) {
        this.logging.error("ladeSternbilderFiguren()", exception);
        JOptionPane.showMessageDialog(null, this.sprache.getString("sim_f7"), this.sprache.getString("sim_f7_titel"), 0);
    }

    @Override
    public void hide() {
        this.sternkarte.setVisible(false);
    }

    @Override
    public void show() {
        if (this.sternkarte == null) {
            this.start();
        } else {
            this.sternkarte.setVisible(true);
        }
    }

    @Override
    public void gotoObject(String string) throws SQLException {
        this.show();
        this.sternkarte.springeZuObjekt(string);
    }
}

