/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.impl.gui;

import de.planetensuche.datamodel.api.ISternbild;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.guidesigner.GuiDesignerFabrik;
import de.planetensuche.sternkarte.dao.spi.ISternkartenRepository;
import de.planetensuche.sternkarte.impl.Konfiguration;
import de.planetensuche.sternkarte.impl.gui.SternkarteParameterDto;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;

public final class ConstellationNamesPainter {
    private final Konfiguration sternkarteKonfiguration;
    private final ISternkartenRepository repository;
    private final List<ISternbild> sternbildObjekte;

    public ConstellationNamesPainter(SternkarteParameterDto sternkarteParameterDto) {
        this.repository = sternkarteParameterDto.getRepository();
        this.sternkarteKonfiguration = sternkarteParameterDto.getSternkartenkonfiguration();
        this.sternbildObjekte = sternkarteParameterDto.getSternbildObjekteListe();
    }

    void zeigeSternbildernamen(Graphics graphics, int n, int n2, double d, double d2) {
        graphics.setFont(GuiDesignerFabrik.getInstance().getFont(false));
        graphics.setColor(Color.GRAY);
        for (ISternbild iSternbild : this.sternbildObjekte) {
            double d3 = iSternbild.getSternbildVonRA() > iSternbild.getSternbildBisRA() ? iSternbild.getSternbildVonRA() : (iSternbild.getSternbildVonRA() + iSternbild.getSternbildBisRA()) / 2.0;
            d3 *= (double)this.sternkarteKonfiguration.getTeilerRA();
            double d4 = (iSternbild.getSternbildVonDECL() + iSternbild.getSternbildBisDECL()) / 2.0;
            if ((d4 *= (double)this.sternkarteKonfiguration.getTeilerDECL()) < 0.0) {
                d4 = (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0 - d4 * -1.0;
            } else if (d4 >= 0.0) {
                d4 += (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0;
            }
            if (!(d3 <= (double)this.sternkarteKonfiguration.getVonRA()) || !(d3 >= (double)this.sternkarteKonfiguration.getBisRA()) || !(d4 <= (double)this.sternkarteKonfiguration.getVonDECL()) || !(d4 >= (double)this.sternkarteKonfiguration.getBisDECL())) continue;
            int n3 = n + (int)Math.round(((double)this.sternkarteKonfiguration.getVonRA() - d3) * d);
            int n4 = n2 + (int)Math.round(((double)this.sternkarteKonfiguration.getVonDECL() - d4) * d2);
            String string = SternbildSprache.DEUTSCH.equals((Object)this.repository.getSternbildsprache()) ? iSternbild.getSternbildDTBezeichnung() : (SternbildSprache.ENGLISCH.equals((Object)this.repository.getSternbildsprache()) ? iSternbild.getSternbildENGBezeichnung() : iSternbild.getSternbildLATBezeichnung());
            graphics.drawString(string, n3 - iSternbild.getSternbildDTBezeichnung().length() * 3, n4);
        }
    }
}

