/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.impl.gui;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sternkarte.impl.Konfiguration;
import de.planetensuche.sternkarte.impl.SternkarteSETI;
import de.planetensuche.sternkarte.impl.gui.SternkarteParameterDto;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;

public final class SetiWorkUnitPainter {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final ISprachcontainer sprache;
    private final Konfiguration sternkarteKonfiguration;
    private final SternkarteSETI seti;

    public SetiWorkUnitPainter(SternkarteParameterDto sternkarteParameterDto) {
        this.sternkarteKonfiguration = sternkarteParameterDto.getSternkartenkonfiguration();
        this.sprache = sternkarteParameterDto.getIsprache();
        this.seti = new SternkarteSETI(this.sprache);
    }

    void zeigeSetiWorkUnits(Graphics graphics, int n, int n2, double d, double d2) {
        graphics.setColor(Color.WHITE);
        List<Double> list = this.seti.getRa();
        List<Double> list2 = this.seti.getDecl();
        if (list.isEmpty()) {
            this.logging.warn("keine SETI WUs gefunden?");
        }
        for (int i = 0; i < list.size(); ++i) {
            double d3 = list.get(i) * (double)this.sternkarteKonfiguration.getTeilerRA();
            double d4 = list2.get(i) * (double)this.sternkarteKonfiguration.getTeilerDECL();
            if (d4 < 0.0) {
                d4 = (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0 - d4 * -1.0;
            } else if (d4 >= 0.0) {
                d4 += (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0;
            }
            if (!(d3 <= (double)this.sternkarteKonfiguration.getVonRA()) || !(d3 >= (double)this.sternkarteKonfiguration.getBisRA()) || !(d4 <= (double)this.sternkarteKonfiguration.getVonDECL()) || !(d4 >= (double)this.sternkarteKonfiguration.getBisDECL())) continue;
            int n3 = n + (int)Math.round(((double)this.sternkarteKonfiguration.getVonRA() - d3) * d);
            int n4 = n2 + (int)Math.round(((double)this.sternkarteKonfiguration.getVonDECL() - d4) * d2);
            graphics.drawOval(n3 - 4, n4 - 4, 8, 8);
        }
    }
}

