/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.impl.gui;

import de.planetensuche.sternkarte.dao.spi.DecimalCoordinate;
import de.planetensuche.sternkarte.dao.spi.StarmapObject;
import de.planetensuche.sternkarte.impl.Konfiguration;
import de.planetensuche.sternkarte.impl.gui.SternkarteParameterDto;
import de.planetensuche.sternkarte.impl.gui.TrianglePainter;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StarsWithExoplanetsPainter {
    private final Konfiguration sternkarteKonfiguration;
    private final List<DecimalCoordinate> starsWithExoplanets;
    private final Map<String, List<StarmapObject>> starsWithExoplanetsByAllDiscoverer;

    public StarsWithExoplanetsPainter(SternkarteParameterDto sternkarteParameterDto) {
        this.sternkarteKonfiguration = sternkarteParameterDto.getSternkartenkonfiguration();
        this.starsWithExoplanets = sternkarteParameterDto.getPlanetenListe();
        this.starsWithExoplanetsByAllDiscoverer = sternkarteParameterDto.getExoplanetsByDiscoverer();
    }

    public Map<String, Color> paintStarsWithExoplanetsByDiscoverer(Graphics graphics, List<String> list) {
        HashMap<String, Color> hashMap = new HashMap<String, Color>();
        float f = 0.0f;
        for (Map.Entry<String, List<StarmapObject>> entry : this.starsWithExoplanetsByAllDiscoverer.entrySet()) {
            List<StarmapObject> list2 = entry.getValue();
            if (!list.contains(entry.getKey())) continue;
            String string = entry.getKey();
            Color color = Color.getHSBColor(f, 1.0f, 1.0f);
            graphics.setColor(color);
            f += 0.1f;
            if (f > 1.0f) {
                f = 0.05f;
            }
            hashMap.put(string, color);
            for (StarmapObject starmapObject : list2) {
                double d;
                double d2 = starmapObject.getCoordinate().getRa() * (double)this.sternkarteKonfiguration.getTeilerRA();
                if (!this.isInVisibleArea(d2, d = this.declTo360Degre(starmapObject.getCoordinate().getDecl()))) continue;
                int n = this.calculateCenterXInPixel(d2);
                int n2 = this.calculateCenterYInPixel(d);
                new TrianglePainter().drawTriangle(graphics, n, n2);
            }
        }
        return hashMap;
    }

    public void paintStarsWithExoplanets(Graphics graphics) throws NumberFormatException {
        graphics.setColor(Color.BLUE);
        for (DecimalCoordinate decimalCoordinate : this.starsWithExoplanets) {
            double d;
            double d2 = decimalCoordinate.getRa() * (double)this.sternkarteKonfiguration.getTeilerRA();
            if (!this.isInVisibleArea(d2, d = this.declTo360Degre(decimalCoordinate.getDecl()))) continue;
            int n = this.calculateCenterXInPixel(d2);
            int n2 = this.calculateCenterYInPixel(d);
            graphics.drawOval(n - 4, n2 - 4, 8, 8);
        }
    }

    private double declTo360Degre(double d) {
        double d2 = d * (double)this.sternkarteKonfiguration.getTeilerDECL();
        if (d2 < 0.0) {
            d2 = (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0 - d2 * -1.0;
        } else if (d2 >= 0.0) {
            d2 += (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0;
        }
        return d2;
    }

    private int calculateCenterXInPixel(double d) {
        int n = this.sternkarteKonfiguration.getVonX();
        double d2 = this.sternkarteKonfiguration.getAbschnittRaInPixel();
        int n2 = n + (int)Math.round(((double)this.sternkarteKonfiguration.getVonRA() - d) * d2);
        return n2;
    }

    private int calculateCenterYInPixel(double d) {
        int n = this.sternkarteKonfiguration.getVonY();
        double d2 = this.sternkarteKonfiguration.getAbschnittDeclInPixel();
        int n2 = n + (int)Math.round(((double)this.sternkarteKonfiguration.getVonDECL() - d) * d2);
        return n2;
    }

    private boolean isInVisibleArea(double d, double d2) {
        return d <= (double)this.sternkarteKonfiguration.getVonRA() && d >= (double)this.sternkarteKonfiguration.getBisRA() && d2 <= (double)this.sternkarteKonfiguration.getVonDECL() && d2 >= (double)this.sternkarteKonfiguration.getBisDECL();
    }
}

