/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.impl.gui;

import de.planetensuche.core.db.SearchableDataSource;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.guidesigner.icons.IconPoolNavigation;
import de.planetensuche.sternkarte.impl.SternkarteSETI;
import de.planetensuche.sternkarte.impl.gui.SternkarteInnen;
import de.planetensuche.sternkarte.impl.gui.SternkarteParameterDto;
import de.planetensuche.sternkarte.impl.gui.SuchenDialog;
import de.planetensuche.sternkarte.impl.gui.settingdialog.ExoplanetOptionDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;

public final class SternkarteGui
extends Basisdialog {
    private final SternkarteParameterDto parameter;
    private SternkarteSETI seti;
    private JMenuBar menuBar;
    private JMenu objectsMenu;
    private JMenuItem starsMenu;
    private JMenuItem clustersMenu;
    private JMenuItem galaxyMenu;
    private JMenuItem brownDwarfMenu;
    private JMenuItem planetsMenu;
    private JMenuItem planetsByDiscovererMenu;
    private JMenuItem otherMenu;
    private JMenuItem closeMenu;
    private JMenu otherOptionsMenu;
    private JMenuItem showLegendMenu;
    private JMenuItem constellationNamesMenu;
    private JMenuItem constellationLinesMenu;
    private JMenuItem seasonLinesMenu;
    private JMenuItem showSptypesMenu;
    private JMenuItem gotoObjectMenu;
    private JMenuItem zeigeSetiWuMenu;
    private JMenuItem showBayerFlamsteedNamesMenu;
    private JMenu helpMenu;
    private JMenuItem showHelpMenu;
    private final SternkarteInnen sternkarteInnen;
    private ExoplanetOptionDialog exoplanetOptionDialog;

    public SternkarteGui(SternkarteParameterDto sternkarteParameterDto) {
        super(BasisdialogId.STERNKARTE_HAUPTFENSTER);
        this.parameter = sternkarteParameterDto;
        this.sternkarteInnen = new SternkarteInnen(sternkarteParameterDto);
        try {
            this.seti = new SternkarteSETI(this.i18n);
            this.resizeToDesktopSize();
            this.setResizable(false);
            this.setBackground(Color.black);
            this.addMenu();
            this.addToolBar();
            this.add((Component)this.sternkarteInnen, "Center");
            this.addListener();
            this.setFocusable(false);
            this.setTitle(this.i18n.getString("sim_gui67"));
        }
        catch (HeadlessException headlessException) {
            this.protokolliereUndZeigeFehlerBeimStarten(headlessException);
        }
    }

    private void addToolBar() {
        JButton jButton = new JButton();
        jButton.setIcon(IconPoolNavigation.BACK.getImageIcon());
        jButton.setFocusable(false);
        jButton.setVisible(true);
        jButton.addActionListener(actionEvent -> this.sternkarteInnen.scrollRight());
        JButton jButton2 = new JButton();
        jButton2.setIcon(IconPoolNavigation.FORWARD.getImageIcon());
        jButton2.setFocusable(false);
        jButton2.setVisible(true);
        jButton2.addActionListener(actionEvent -> this.sternkarteInnen.scrollLeft());
        JButton jButton3 = new JButton();
        jButton3.setIcon(IconPoolNavigation.DOWN.getImageIcon());
        jButton3.setFocusable(false);
        jButton3.setVisible(true);
        jButton3.addActionListener(actionEvent -> this.sternkarteInnen.scrollDown());
        JButton jButton4 = new JButton();
        jButton4.setIcon(IconPoolNavigation.UP.getImageIcon());
        jButton4.setFocusable(false);
        jButton4.setVisible(true);
        jButton4.addActionListener(actionEvent -> this.sternkarteInnen.scrollUp());
        JButton jButton5 = new JButton();
        jButton5.setIcon(IconPoolDefault.ZOOM_IN.getImageIcon());
        jButton5.setFocusable(false);
        jButton5.setVisible(true);
        jButton5.addActionListener(actionEvent -> this.sternkarteInnen.zoomIn());
        JButton jButton6 = new JButton();
        jButton6.setIcon(IconPoolDefault.ZOOM_OUT.getImageIcon());
        jButton6.setFocusable(false);
        jButton6.setVisible(true);
        jButton6.addActionListener(actionEvent -> this.sternkarteInnen.zoomOut());
        JButton jButton7 = new JButton();
        jButton7.setIcon(IconPoolDefault.FIND.getImageIcon());
        jButton7.setFocusable(false);
        jButton7.setVisible(true);
        jButton7.addActionListener(actionEvent -> {
            SearchableDataSource searchableDataSource = this.parameter.getSearchableDataSource();
            SuchenDialog suchenDialog = new SuchenDialog(searchableDataSource, this.sternkarteInnen);
            suchenDialog.setVisible(true);
        });
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        jToolBar.add(jButton4);
        jToolBar.addSeparator();
        jToolBar.add(jButton5);
        jToolBar.add(jButton6);
        jToolBar.addSeparator();
        jToolBar.add(jButton7);
        this.add((Component)jToolBar, "North");
        jToolBar.setVisible(true);
    }

    private void protokolliereUndZeigeFehlerBeimStarten(Exception exception) {
        this.getLogger().error(exception);
        this.getLogger().showErrorMessageBox(null, this.i18n.getString("db_f91") + "\n" + exception.toString(), this.i18n.getString("db_f4_titel"));
    }

    private void addMenu() {
        this.objectsMenu = new JMenu();
        this.objectsMenu.setText(this.i18n.getString("sim_gui84"));
        this.starsMenu = new JMenuItem();
        this.starsMenu.setText(this.i18n.getString("ps_sterne"));
        this.objectsMenu.add(this.starsMenu);
        this.clustersMenu = new JMenuItem();
        this.clustersMenu.setText(this.i18n.getString("ps_sternhaufen"));
        this.objectsMenu.add(this.clustersMenu);
        this.galaxyMenu = new JMenuItem();
        this.galaxyMenu.setText(this.i18n.getString("ps_glx_neb"));
        this.objectsMenu.add(this.galaxyMenu);
        this.brownDwarfMenu = new JMenuItem();
        this.brownDwarfMenu.setText(this.i18n.getString("ps_br_zwerge"));
        this.objectsMenu.add(this.brownDwarfMenu);
        this.planetsMenu = new JMenuItem();
        this.planetsMenu.setText(this.i18n.getString("sim_gui129"));
        this.objectsMenu.add(this.planetsMenu);
        this.planetsByDiscovererMenu = new JMenuItem();
        this.planetsByDiscovererMenu.setText(this.i18n.getString("sim_gui130"));
        this.objectsMenu.add(this.planetsByDiscovererMenu);
        this.otherMenu = new JMenuItem();
        this.otherMenu.setText(this.i18n.getString("ps_sonstiges"));
        this.objectsMenu.add(this.otherMenu);
        this.closeMenu = new JMenuItem();
        this.closeMenu.setText(this.i18n.getString("sim_gui128"));
        this.objectsMenu.add(this.closeMenu);
        this.otherOptionsMenu = new JMenu();
        this.otherOptionsMenu.setText(this.i18n.getString("sim_gui85"));
        this.showLegendMenu = new JMenuItem(this.i18n.getString("stk_gui3"));
        this.otherOptionsMenu.add(this.showLegendMenu);
        this.constellationNamesMenu = new JMenuItem(this.i18n.getString("sim_gui86"));
        this.otherOptionsMenu.add(this.constellationNamesMenu);
        this.constellationLinesMenu = new JMenuItem(this.i18n.getString("sim_gui87"));
        this.otherOptionsMenu.add(this.constellationLinesMenu);
        this.seasonLinesMenu = new JMenuItem(this.i18n.getString("sim_gui135"));
        this.otherOptionsMenu.add(this.seasonLinesMenu);
        this.showBayerFlamsteedNamesMenu = new JMenuItem(this.i18n.getString("sim_m162"));
        this.otherOptionsMenu.add(this.showBayerFlamsteedNamesMenu);
        this.showSptypesMenu = new JMenuItem(this.i18n.getString("sim_gui88"));
        this.otherOptionsMenu.add(this.showSptypesMenu);
        this.gotoObjectMenu = new JMenuItem(this.i18n.getString("sim_m105"));
        this.otherOptionsMenu.add(this.gotoObjectMenu);
        this.zeigeSetiWuMenu = new JMenuItem(this.i18n.getString("sim_gui104"));
        this.otherOptionsMenu.add(this.zeigeSetiWuMenu);
        this.helpMenu = new JMenu();
        this.helpMenu.setText(this.i18n.getString("db_menu_19"));
        this.showHelpMenu = new JMenuItem();
        this.showHelpMenu.setText(this.i18n.getString("sim_m106"));
        this.helpMenu.add(this.showHelpMenu);
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.objectsMenu);
        this.menuBar.add(this.otherOptionsMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    private void addListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SternkarteGui.this.setVisible(false);
            }
        });
        this.starsMenu.addActionListener(actionEvent -> {
            this.sternkarteInnen.setSterneAnzeigen(!this.sternkarteInnen.isSterneAnzeigen());
            this.sternkarteInnen.repaint();
        });
        this.clustersMenu.addActionListener(actionEvent -> {
            this.sternkarteInnen.setSternhaufenAnzeigen(!this.sternkarteInnen.isSternhaufenAnzeigen());
            this.sternkarteInnen.repaint();
        });
        this.galaxyMenu.addActionListener(actionEvent -> {
            this.sternkarteInnen.setNebelgalaxienAnzeigen(!this.sternkarteInnen.isNebelgalaxienAnzeigen());
            this.sternkarteInnen.repaint();
        });
        this.brownDwarfMenu.addActionListener(actionEvent -> {
            this.sternkarteInnen.setBraunezwergeAnzeigen(!this.sternkarteInnen.isBraunezwergeAnzeigen());
            this.sternkarteInnen.repaint();
        });
        this.planetsMenu.addActionListener(actionEvent -> {
            this.sternkarteInnen.setExoplanetenAnzeigen(!this.sternkarteInnen.isExoplanetenAnzeigen());
            this.sternkarteInnen.repaint();
        });
        this.planetsByDiscovererMenu.addActionListener(actionEvent -> {
            if (this.exoplanetOptionDialog == null) {
                EventQueue.invokeLater(() -> {
                    Map<String, Integer> map = this.parameter.getExoplanetsByDiscoverer().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((List)entry.getValue()).size()));
                    this.exoplanetOptionDialog = new ExoplanetOptionDialog(this.sternkarteInnen, map);
                    this.exoplanetOptionDialog.setVisible(true);
                });
            } else {
                this.exoplanetOptionDialog.setVisible(true);
            }
        });
        this.otherMenu.addActionListener(actionEvent -> {
            this.sternkarteInnen.setSonstigesAnzeigen(!this.sternkarteInnen.isSonstigesAnzeigen());
            this.sternkarteInnen.repaint();
        });
        this.closeMenu.addActionListener(actionEvent -> this.dispose());
        this.constellationNamesMenu.addActionListener(actionEvent -> {
            this.sternkarteInnen.setSternbildernamenAnzeigen(!this.sternkarteInnen.isSternbildernamenAnzeigen());
            this.sternkarteInnen.repaint();
        });
        this.constellationLinesMenu.addActionListener(actionEvent -> {
            this.sternkarteInnen.setSternbilderAnzeigen(!this.sternkarteInnen.isSternbilderAnzeigen());
            this.sternkarteInnen.repaint();
        });
        this.seasonLinesMenu.addActionListener(actionEvent -> {
            this.sternkarteInnen.setSternmusterJahreszeitAnzeigen(!this.sternkarteInnen.isSternmusterJahreszeitAnzeigen());
            this.sternkarteInnen.repaint();
        });
        this.showBayerFlamsteedNamesMenu.addActionListener(actionEvent -> {
            this.sternkarteInnen.setBayerFlamsteedNamenAnzeigen(!this.sternkarteInnen.isBayerFlamsteedNamenAnzeigen());
            this.sternkarteInnen.repaint();
        });
        this.showSptypesMenu.addActionListener(actionEvent -> {
            this.sternkarteInnen.setSpektraltypenAnzeigen(!this.sternkarteInnen.isSpektraltypenAnzeigen());
            this.sternkarteInnen.repaint();
        });
        this.gotoObjectMenu.addActionListener(actionEvent -> {
            SearchableDataSource searchableDataSource = this.parameter.getSearchableDataSource();
            SuchenDialog suchenDialog = new SuchenDialog(searchableDataSource, this.sternkarteInnen);
            suchenDialog.setVisible(true);
        });
        this.zeigeSetiWuMenu.addActionListener(actionEvent -> {
            if (this.seti.isGeladen() || this.seti.ladeKoordinaten()) {
                this.sternkarteInnen.setSetiAnzeigen(!this.sternkarteInnen.isSetiAnzeigen());
                this.sternkarteInnen.repaint();
            } else {
                this.getLogger().warn("Konnte keine SETI WUs finden/laden!");
            }
        });
        this.showHelpMenu.addActionListener(actionEvent -> JOptionPane.showMessageDialog(null, this.i18n.getString("sim_m107"), this.i18n.getString("db_m191_titel"), 1));
        this.showLegendMenu.addActionListener(actionEvent -> this.sternkarteInnen.showLegendDialog(!this.sternkarteInnen.isLegendDialogVisible()));
    }

    public void springeZuObjekt(String string) throws SQLException {
        this.sternkarteInnen.springeZuObjekt(string);
    }
}

