/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.impl.gui;

import de.planetensuche.core.Check;
import de.planetensuche.core.db.SearchableDataSource;
import de.planetensuche.datamodel.api.IKoordinatenKonverter;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.api.KoordinatenFormatI18n;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.impl.KoordinatenKonverter;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.GuiDesignerFabrik;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sternkarte.dao.spi.ISternkartenRepository;
import de.planetensuche.sternkarte.impl.Konfiguration;
import de.planetensuche.sternkarte.impl.Sternkartenobjekt;
import de.planetensuche.sternkarte.impl.gui.ConstellationNamesPainter;
import de.planetensuche.sternkarte.impl.gui.ConstellationPainter;
import de.planetensuche.sternkarte.impl.gui.SetiWorkUnitPainter;
import de.planetensuche.sternkarte.impl.gui.StarsWithExoplanetsPainter;
import de.planetensuche.sternkarte.impl.gui.SternkarteParameterDto;
import de.planetensuche.sternkarte.impl.gui.SternmusterZeichner;
import de.planetensuche.sternkarte.impl.gui.SuchenDialog;
import de.planetensuche.sternkarte.impl.gui.info.ClickOnObjectMouseListener;
import de.planetensuche.sternkarte.impl.gui.legende.LegendeOptionsDto;
import de.planetensuche.sternkarte.impl.gui.legende.LegendePopupGui;
import de.planetensuche.sternkarte.impl.gui.util.ObjektdimensionRechner;
import de.planetensuche.sternkarte.impl.gui.util.SpTypColorHelper;
import de.planetensuche.sternkarte.impl.gui.util.ZoomRechner;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class SternkarteInnen
extends JPanel {
    private final ISternkartenRepository repository;
    private final ISprachcontainer i18n;
    private final ILogging logger;
    private int bildhoeheInPixel;
    private int bildbreiteInPixel;
    private double abschnittRaInPixel;
    private double abschnittDeclInPixel;
    private final int vonX = 10;
    private int bisX;
    private final int vonY = 10;
    private int bisY;
    private final Sternkartenobjekt sternkartenobjekt;
    private boolean sternbilderAnzeigen;
    private boolean sternbildernamenAnzeigen;
    private boolean sternmusterJahreszeitAnzeigen;
    private boolean nebelgalaxienAnzeigen;
    private boolean sternhaufenAnzeigen;
    private boolean braunezwergeAnzeigen;
    private boolean sonstigesAnzeigen;
    private boolean exoplanetenAnzeigen;
    private List<String> exoplanetenEntdeckerprojekteAnzeigen;
    private boolean spektraltypenAnzeigen;
    private boolean sterneAnzeigen;
    private boolean bayerFlamsteedNamenAnzeigen;
    private boolean setiAnzeigen;
    private List<Double> raZentral;
    private List<Double> declZentral;
    private final SearchableDataSource searchableDataSource;
    private final Konfiguration sternkarteKonfiguration;
    private final ZoomRechner zoomRechner;
    private final ObjektdimensionRechner objektdimensionRechner;
    private final SpTypColorHelper spTypColorHelper;
    private final ConstellationPainter constellationPainter;
    private final ConstellationNamesPainter constellationNamesPainter;
    private final SternmusterZeichner sternmusterZeichner;
    private final SetiWorkUnitPainter setiWorkUnitPainter;
    private final StarsWithExoplanetsPainter starsWithExoplanetsPainter;
    private final LegendePopupGui legendePopup;
    private final Map<Integer, String> bayerFlamsteedNames;
    private final KoordinatenFormat koordinatenFormat;
    private final IKoordinatenKonverter coordinateConverter;

    public SternkarteInnen(SternkarteParameterDto sternkarteParameterDto) {
        this.repository = sternkarteParameterDto.getRepository();
        this.i18n = sternkarteParameterDto.getIsprache();
        this.koordinatenFormat = sternkarteParameterDto.getKoordinatenFormat();
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.sternkartenobjekt = sternkarteParameterDto.getSternkartenObjekt();
        this.sternkarteKonfiguration = sternkarteParameterDto.getSternkartenkonfiguration();
        this.searchableDataSource = sternkarteParameterDto.getSearchableDataSource();
        this.bayerFlamsteedNames = sternkarteParameterDto.getBayerFlamsteedNames();
        this.spTypColorHelper = new SpTypColorHelper();
        this.constellationPainter = new ConstellationPainter(sternkarteParameterDto);
        this.constellationNamesPainter = new ConstellationNamesPainter(sternkarteParameterDto);
        this.sternmusterZeichner = new SternmusterZeichner(sternkarteParameterDto);
        this.setiWorkUnitPainter = new SetiWorkUnitPainter(sternkarteParameterDto);
        this.starsWithExoplanetsPainter = new StarsWithExoplanetsPainter(sternkarteParameterDto);
        this.coordinateConverter = new KoordinatenKonverter(this.i18n);
        this.sternmusterJahreszeitAnzeigen = false;
        this.sternbildernamenAnzeigen = false;
        this.nebelgalaxienAnzeigen = true;
        this.sternhaufenAnzeigen = true;
        this.exoplanetenAnzeigen = false;
        this.spektraltypenAnzeigen = false;
        this.braunezwergeAnzeigen = false;
        this.sonstigesAnzeigen = true;
        this.sterneAnzeigen = true;
        this.bayerFlamsteedNamenAnzeigen = false;
        this.legendePopup = new LegendePopupGui(sternkarteParameterDto);
        LegendeOptionsDto legendeOptionsDto = this.createOptionDto(Map.of());
        this.legendePopup.setLegendeOptionsDto(legendeOptionsDto);
        this.legendePopup.setVisible(true);
        this.zoomRechner = new ZoomRechner();
        this.objektdimensionRechner = new ObjektdimensionRechner();
        try {
            this.setBackground(Color.black);
            this.addListener();
            this.setFocusable(true);
        }
        catch (HeadlessException headlessException) {
            this.protokolliereUndZeigeFehlerBeimStarten(headlessException);
        }
    }

    public boolean isLegendDialogVisible() {
        return this.legendePopup.isVisible();
    }

    public void showLegendDialog(boolean bl) {
        this.legendePopup.setVisible(bl);
        if (bl) {
            this.legendePopup.repaint();
        }
    }

    private void protokolliereUndZeigeFehlerBeimStarten(Exception exception) {
        this.logger.error(exception);
        this.logger.showErrorMessageBox(null, this.i18n.getString("db_f91") + "\n" + exception.toString(), this.i18n.getString("db_f4_titel"));
    }

    private void addListener() {
        this.addMouseListener(new ClickOnObjectMouseListener(this.sternkartenobjekt, this.sternkarteKonfiguration, this.i18n, this.repository, this.koordinatenFormat));
        this.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getWheelRotation() > 0) {
                    SternkarteInnen.this.zoomOut();
                } else if (mouseWheelEvent.getWheelRotation() < 0) {
                    SternkarteInnen.this.zoomIn();
                }
            }
        });
        final SternkarteInnen sternkarteInnen = this;
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 109 || keyEvent.getKeyCode() == 45) {
                    SternkarteInnen.this.zoomOut();
                } else if (keyEvent.getKeyCode() == 521 || keyEvent.getKeyCode() == 107) {
                    SternkarteInnen.this.zoomIn();
                } else if (keyEvent.getKeyCode() == 224 || keyEvent.getKeyCode() == 38) {
                    SternkarteInnen.this.scrollUp();
                } else if (keyEvent.getKeyCode() == 225 || keyEvent.getKeyCode() == 40) {
                    SternkarteInnen.this.scrollDown();
                } else if (keyEvent.getKeyCode() == 227 || keyEvent.getKeyCode() == 39) {
                    SternkarteInnen.this.scrollLeft();
                } else if (keyEvent.getKeyCode() == 226 || keyEvent.getKeyCode() == 37) {
                    SternkarteInnen.this.scrollRight();
                } else if (keyEvent.getKeyCode() == 70) {
                    SuchenDialog suchenDialog = new SuchenDialog(SternkarteInnen.this.searchableDataSource, sternkarteInnen);
                    suchenDialog.setVisible(true);
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    public void springeZuObjekten(List<String> list) throws SQLException {
        List<IPlanetensucheObjekt> list2 = this.repository.readCoordsShOnly(list);
        this.raZentral = new ArrayList<Double>();
        this.declZentral = new ArrayList<Double>();
        double d = 24.0;
        double d2 = 0.0;
        double d3 = 90.0;
        double d4 = -90.0;
        double d5 = -3.0;
        for (IPlanetensucheObjekt iPlanetensucheObjekt : list2) {
            this.raZentral.add(this.umrechnenRaInSternkartenRa(iPlanetensucheObjekt.getRA()));
            this.declZentral.add(this.umrechnenDeclInSternkartenDecl(iPlanetensucheObjekt.getDECL()));
            if (d2 < iPlanetensucheObjekt.getRA()) {
                d2 = iPlanetensucheObjekt.getRA();
            }
            if (d > iPlanetensucheObjekt.getRA()) {
                d = iPlanetensucheObjekt.getRA();
            }
            if (d4 < iPlanetensucheObjekt.getDECL()) {
                d4 = iPlanetensucheObjekt.getDECL();
            }
            if (d3 > iPlanetensucheObjekt.getDECL()) {
                d3 = iPlanetensucheObjekt.getDECL();
            }
            if (!(d5 < iPlanetensucheObjekt.getScheinbareHelligkeit())) continue;
            d5 = iPlanetensucheObjekt.getScheinbareHelligkeit();
        }
        this.logger.debug("RA min=" + d + " & RA max=" + d2);
        this.logger.debug("DECL min=" + d3 + " & DECL max=" + d4);
        this.setSternbildKartenausschnitt(this.umrechnenRaInSternkartenRa(d2), this.umrechnenRaInSternkartenRa(d), this.umrechnenDeclInSternkartenDecl(d4), this.umrechnenDeclInSternkartenDecl(d3));
        double d6 = Math.rint(d5 * 10.0) / 10.0 + 0.5;
        this.logger.debug("neue sternkarten-grenzgr\u00f6\u00dfe: " + d6 + " mag");
        if (this.sternkarteKonfiguration.getAktuelleMagnitude() < d6) {
            boolean bl = this.repository.getSternkarte(this.sternkarteKonfiguration.getAktuelleMagnitude(), d6, this.sternkartenobjekt);
            if (bl) {
                this.sternkarteKonfiguration.setAktuelleMagnitude(d6);
                this.sternkartenobjekt.setBisMagGeladen(d6);
            } else {
                this.logger.warn("Sternkartendaten nachladen ist gescheitert!");
            }
        }
        this.repaint();
    }

    private void setSternbildKartenausschnitt(double d, double d2, double d3, double d4) {
        this.sternkarteKonfiguration.setVonRA((int)Math.round(d) + 1);
        if (this.sternkarteKonfiguration.getVonRA() > 144) {
            this.sternkarteKonfiguration.setVonRA(144);
        }
        this.sternkarteKonfiguration.setBisRA((int)Math.round(d2) - 1);
        if (this.sternkarteKonfiguration.getBisRA() < 0) {
            this.sternkarteKonfiguration.setBisRA(0);
        }
        this.sternkarteKonfiguration.setVonDECL((int)Math.round(d3) + 5);
        if (this.sternkarteKonfiguration.getVonDECL() > 720) {
            this.sternkarteKonfiguration.setVonDECL(720);
        }
        this.sternkarteKonfiguration.setBisDECL((int)Math.round(d4) - 5);
        if (this.sternkarteKonfiguration.getBisDECL() < 0) {
            this.sternkarteKonfiguration.setBisDECL(0);
        }
    }

    public void springeZuObjekt(String string) throws SQLException {
        IPlanetensucheObjekt iPlanetensucheObjekt = this.repository.readCoordsShOnly(string);
        this.raZentral = Arrays.asList(this.umrechnenRaInSternkartenRa(iPlanetensucheObjekt.getRA()));
        this.declZentral = Arrays.asList(this.umrechnenDeclInSternkartenDecl(iPlanetensucheObjekt.getDECL()));
        this.setSternbildKartenausschnitt(this.raZentral.get(0), this.raZentral.get(0), this.declZentral.get(0), this.declZentral.get(0));
        double d = Math.rint(iPlanetensucheObjekt.getScheinbareHelligkeit() * 10.0) / 10.0 + 0.5;
        if (this.sternkarteKonfiguration.getAktuelleMagnitude() < d) {
            boolean bl = this.repository.getSternkarte(this.sternkarteKonfiguration.getAktuelleMagnitude(), d, this.sternkartenobjekt);
            if (bl) {
                this.sternkarteKonfiguration.setAktuelleMagnitude(d);
                this.sternkartenobjekt.setBisMagGeladen(d);
            } else {
                this.logger.warn("Sternkartendaten nachladen ist gescheitert!");
            }
        }
        this.repaint();
    }

    private double umrechnenRaInSternkartenRa(double d) {
        return d * (double)this.sternkarteKonfiguration.getTeilerRA();
    }

    private double umrechnenDeclInSternkartenDecl(double d) {
        double d2 = d;
        if (d2 < 0.0) {
            d2 = (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0 - d2 * -1.0 * (double)this.sternkarteKonfiguration.getTeilerDECL();
        } else if (d2 >= 0.0) {
            d2 = (d2 + 90.0) * (double)this.sternkarteKonfiguration.getTeilerDECL();
        }
        return d2;
    }

    protected void zoomIn() {
        boolean bl = this.zoomRechner.zoomIn(this.sternkarteKonfiguration);
        if (bl) {
            this.setCursor(new Cursor(3));
            this.repaint();
            double d = this.sternkarteKonfiguration.getAktuelleMagnitude();
            if (d >= this.sternkartenobjekt.getBisMagGeladen()) {
                long l = System.currentTimeMillis();
                boolean bl2 = this.repository.getSternkarte(d, d + 0.1, this.sternkartenobjekt);
                long l2 = System.currentTimeMillis() - l;
                this.logger.debug("Daten f\u00fcr Sternkarte in " + l2 + " ms nachgeladen");
                if (bl2) {
                    this.sternkartenobjekt.setBisMagGeladen(d + 0.1);
                    this.logger.debug("Auf " + this.sternkartenobjekt.getNumberOfEntries() + " Objekte erhoeht.");
                }
            }
            this.setCursor(new Cursor(1));
        }
    }

    protected void zoomOut() {
        boolean bl = this.zoomRechner.zoomOut(this.sternkarteKonfiguration);
        if (bl) {
            this.setCursor(new Cursor(3));
            this.repaint();
            this.setCursor(new Cursor(1));
        }
    }

    private void paintXAchse(Graphics graphics) {
        graphics.setFont(GuiDesignerFabrik.getInstance().getFont(false));
        graphics.drawLine(10, this.bisY, this.bisX, this.bisY);
        for (int i = this.sternkarteKonfiguration.getVonRA() - this.sternkarteKonfiguration.getBisRA(); i >= 0; --i) {
            graphics.drawLine(10 + this.bildbreiteInPixel - (int)((double)i * this.abschnittRaInPixel), this.bisY, 10 + this.bildbreiteInPixel - (int)((double)i * this.abschnittRaInPixel), this.bisY + 5);
            if (this.sternkarteKonfiguration.getVonRA() - this.sternkarteKonfiguration.getBisRA() > 30 && i % this.sternkarteKonfiguration.getTeilerRA() != 0) continue;
            double d = (double)(i + this.sternkarteKonfiguration.getBisRA()) / (double)this.sternkarteKonfiguration.getTeilerRA();
            this.coordinateConverter.setRa(d);
            String string = this.coordinateConverter.toRaString(this.koordinatenFormat, KoordinatenFormatI18n.SHORT);
            graphics.drawString(string, 10 + this.bildbreiteInPixel - (int)((double)i * this.abschnittRaInPixel), this.bisY + 20);
        }
    }

    private void paintYAchse(Graphics graphics) {
        graphics.setFont(GuiDesignerFabrik.getInstance().getFont(false));
        graphics.drawLine(this.bisX, 10, this.bisX, this.bisY);
        for (int i = this.sternkarteKonfiguration.getVonDECL() - this.sternkarteKonfiguration.getBisDECL(); i >= 0; --i) {
            if (this.sternkarteKonfiguration.getVonDECL() - this.sternkarteKonfiguration.getBisDECL() > 80 && i % 10 != 0) continue;
            graphics.drawLine(this.bisX, 10 + this.bildhoeheInPixel - (int)((double)i * this.abschnittDeclInPixel), this.bisX + 5, 10 + this.bildhoeheInPixel - (int)((double)i * this.abschnittDeclInPixel));
            if (this.sternkarteKonfiguration.getVonDECL() - this.sternkarteKonfiguration.getBisDECL() > 50 && i % 15 != 0) continue;
            double d = (double)(i + this.sternkarteKonfiguration.getBisDECL()) / (double)this.sternkarteKonfiguration.getTeilerDECL() - 90.0;
            this.coordinateConverter.setDecl(d);
            String string = this.coordinateConverter.toDeclString(this.koordinatenFormat, KoordinatenFormatI18n.SHORT);
            graphics.drawString(string, this.bisX + 15, 15 + this.bildhoeheInPixel - (int)((double)i * this.abschnittDeclInPixel));
        }
    }

    @Override
    public void paint(Graphics graphics) {
        long l = System.currentTimeMillis();
        try {
            Object object;
            if (this.getCursor().getType() == 0) {
                this.setCursor(new Cursor(1));
            }
            if (this.bisX == 0) {
                this.bisX = this.getWidth() - 200;
                this.bisY = this.getHeight() - 70;
                this.sternkarteKonfiguration.setBisX(this.bisX);
                this.sternkarteKonfiguration.setBisY(this.bisY);
                this.bildhoeheInPixel = this.bisY - 10;
                this.bildbreiteInPixel = this.bisX - 10;
            }
            super.paint(graphics);
            this.setBackground(Color.black);
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 10, this.bisX + 200, this.bisY + 70);
            graphics.setFont(GuiDesignerFabrik.getInstance().getFont(false));
            this.abschnittRaInPixel = (double)this.bildbreiteInPixel / ((double)(this.sternkarteKonfiguration.getVonRA() - this.sternkarteKonfiguration.getBisRA()) * 1.0);
            this.abschnittDeclInPixel = (double)this.bildhoeheInPixel / ((double)(this.sternkarteKonfiguration.getVonDECL() - this.sternkarteKonfiguration.getBisDECL()) * 1.0);
            this.sternkarteKonfiguration.setAbschnittRaInPixel(this.abschnittRaInPixel);
            this.sternkarteKonfiguration.setAbschnittDeclInPixel(this.abschnittDeclInPixel);
            graphics.setColor(Color.WHITE);
            graphics.setFont(new Font("Serif", 1, 12));
            if (this.sternbilderAnzeigen) {
                this.constellationPainter.zeichneSternbilder(graphics, 10, this.bisX, 10, this.abschnittRaInPixel, this.abschnittDeclInPixel);
            }
            if (this.sternbildernamenAnzeigen) {
                this.constellationNamesPainter.zeigeSternbildernamen(graphics, 10, 10, this.abschnittRaInPixel, this.abschnittDeclInPixel);
            }
            if (this.sternmusterJahreszeitAnzeigen) {
                this.sternmusterZeichner.zeichneSternmuster(graphics, 10, this.bisX, 10, this.abschnittRaInPixel, this.abschnittDeclInPixel);
            }
            if (this.sternbilderAnzeigen || this.sternbildernamenAnzeigen) {
                graphics.setColor(Color.BLACK);
                graphics.fillRect(10, this.bisY, this.bisX + 200, this.bisY + 70);
                graphics.fillRect(this.bisX, 10, this.bisX + 200, this.bisY + 70);
                graphics.setColor(Color.WHITE);
            }
            if (this.bayerFlamsteedNamenAnzeigen && this.bayerFlamsteedNames.size() > 0 && this.bayerFlamsteedNames.values().contains("?")) {
                object = this.i18n.getString("sim_m163");
                JOptionPane.showMessageDialog(this, object, this.i18n.getString("db_gui55"), 1);
            }
            this.paintStarsAndDeepSky(graphics);
            if (this.exoplanetenAnzeigen) {
                this.starsWithExoplanetsPainter.paintStarsWithExoplanets(graphics);
            }
            object = null;
            if (Check.isFilled(this.exoplanetenEntdeckerprojekteAnzeigen)) {
                object = this.starsWithExoplanetsPainter.paintStarsWithExoplanetsByDiscoverer(graphics, this.exoplanetenEntdeckerprojekteAnzeigen);
            }
            if (this.setiAnzeigen) {
                this.setiWorkUnitPainter.zeigeSetiWorkUnits(graphics, 10, 10, this.abschnittRaInPixel, this.abschnittDeclInPixel);
            }
            if (Check.isFilled(this.raZentral) && Check.isFilled(this.declZentral)) {
                this.paintCircleAroundSearchObjects(graphics);
            }
            graphics.setColor(Color.BLACK);
            graphics.fillRect(10, this.bisY, this.bisX + 200, this.bisY + 70);
            graphics.fillRect(this.bisX, 10, this.bisX + 200, this.bisY + 70);
            graphics.setColor(Color.WHITE);
            this.paintXAchse(graphics);
            this.paintYAchse(graphics);
            LegendeOptionsDto legendeOptionsDto = this.createOptionDto((Map<String, Color>)object);
            this.legendePopup.setLegendeOptionsDto(legendeOptionsDto);
            if (this.legendePopup.isVisible()) {
                EventQueue.invokeLater(() -> this.legendePopup.repaint());
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("Fehler beim Zeichnen der Sternkarte", runtimeException);
        }
        if (this.logger.isDebugEnabled()) {
            long l2 = System.currentTimeMillis() - l;
            this.logger.debug("paint Sternenkarte in " + l2 + " ms");
        }
    }

    private LegendeOptionsDto createOptionDto(Map<String, Color> map) {
        LegendeOptionsDto legendeOptionsDto = new LegendeOptionsDto();
        legendeOptionsDto.setAreBrownDwarfsVisible(this.braunezwergeAnzeigen);
        legendeOptionsDto.setAreClustersVisible(this.sternhaufenAnzeigen);
        legendeOptionsDto.setAreExoplanetsVisible(this.exoplanetenAnzeigen);
        legendeOptionsDto.setAreGalaxiesVisible(this.nebelgalaxienAnzeigen);
        legendeOptionsDto.setAreOtherVisible(this.sonstigesAnzeigen);
        legendeOptionsDto.setSetiVisible(this.setiAnzeigen);
        legendeOptionsDto.setStarFilamentSeasonsVisible(this.sternmusterJahreszeitAnzeigen);
        legendeOptionsDto.setAreStarsVisible(this.sterneAnzeigen);
        legendeOptionsDto.setDiscovererAndColor(map);
        return legendeOptionsDto;
    }

    private void paintStarsAndDeepSky(Graphics graphics) {
        this.sternkartenobjekt.setIndexToNull();
        while (this.sternkartenobjekt.hasNext()) {
            double d;
            boolean bl;
            boolean bl2 = (this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.GALAXIE_NEBEL.getKategorienName()) || this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.GALAXIENHAUFEN.getKategorienName())) && this.nebelgalaxienAnzeigen || this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.STERNHAUFEN.getKategorienName()) && this.sternhaufenAnzeigen;
            boolean bl3 = this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.STERNE.getKategorienName()) && this.sterneAnzeigen;
            boolean bl4 = this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.SONSTIGES.getKategorienName()) && this.sonstigesAnzeigen;
            boolean bl5 = bl = this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.BR_ZWERGE.getKategorienName()) && this.braunezwergeAnzeigen;
            if (!bl2 && !bl3 && !bl4 && !bl || !((d = this.sternkartenobjekt.getMag()) <= this.sternkarteKonfiguration.getAktuelleMagnitude())) continue;
            double d2 = this.sternkartenobjekt.getRa() * (double)this.sternkarteKonfiguration.getTeilerRA();
            double d3 = this.sternkartenobjekt.getDECL() * (double)this.sternkarteKonfiguration.getTeilerDECL();
            if (d3 < 0.0) {
                d3 = (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0 - d3 * -1.0;
            } else if (d3 >= 0.0) {
                d3 += (double)this.sternkarteKonfiguration.getTeilerDECL() * 90.0;
            }
            if (!this.isObjectInVisibleArea(d2, d3)) continue;
            int n = 10 + (int)Math.round(((double)this.sternkarteKonfiguration.getVonRA() - d2) * this.abschnittRaInPixel);
            int n2 = 10 + (int)Math.round(((double)this.sternkarteKonfiguration.getVonDECL() - d3) * this.abschnittDeclInPixel);
            this.sternkartenobjekt.set(n, n2);
            int n3 = this.objektdimensionRechner.getDurchmesser(this.sternkartenobjekt, this.sternkarteKonfiguration, this.abschnittDeclInPixel);
            if (this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.STERNE.getKategorienName())) {
                this.paintStar(graphics, d, n, n3, n2);
                continue;
            }
            if (this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.STERNHAUFEN.getKategorienName()) || this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.BR_ZWERGE.getKategorienName())) {
                this.paintClusterAndBrownDwarf(graphics, n, n3, n2);
                continue;
            }
            if (this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.GALAXIE_NEBEL.getKategorienName()) || this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.GALAXIENHAUFEN.getKategorienName())) {
                this.paintGalaxyAndNebula(graphics, n, n3, n2);
                continue;
            }
            if (!this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.SONSTIGES.getKategorienName())) continue;
            this.paintOtherObject(graphics, n, n3, n2);
        }
    }

    private void paintOtherObject(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(Color.GREEN);
        graphics.drawRect((int)Math.round((double)n - (double)n2 / 2.0), (int)Math.round((double)n3 - (double)n2 / 2.0), n2, n2);
    }

    private void paintGalaxyAndNebula(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(Color.RED);
        graphics.drawOval((int)Math.round((double)n - (double)n2 / 2.0), (int)Math.round((double)n3 - (double)n2 / 4.0), n2, (int)Math.round((double)n2 / 2.0));
    }

    private boolean isObjectInVisibleArea(double d, double d2) {
        return d <= (double)this.sternkarteKonfiguration.getVonRA() && d >= (double)this.sternkarteKonfiguration.getBisRA() && d2 <= (double)this.sternkarteKonfiguration.getVonDECL() && d2 >= (double)this.sternkarteKonfiguration.getBisDECL();
    }

    private void paintStar(Graphics graphics, double d, int n, int n2, int n3) {
        double d2 = this.sternkarteKonfiguration.getAktuelleMagnitude();
        if (this.spektraltypenAnzeigen) {
            graphics.setColor(this.spTypColorHelper.getFarbeZuSptyp(this.sternkartenobjekt.getSptyp()));
        } else if (d + 0.5 >= d2) {
            graphics.setColor(Color.DARK_GRAY);
        } else if (d + 1.0 >= d2) {
            graphics.setColor(Color.GRAY);
        } else if (d + 1.5 >= d2) {
            graphics.setColor(Color.LIGHT_GRAY);
        } else {
            graphics.setColor(Color.WHITE);
        }
        graphics.fillOval((int)Math.round((double)n - (double)n2 / 2.0), (int)Math.round((double)n3 - (double)n2 / 2.0), n2, n2);
        if (this.bayerFlamsteedNamenAnzeigen) {
            this.showBayerFlamsteedName(graphics, n, n3);
        }
    }

    private void paintClusterAndBrownDwarf(Graphics graphics, int n, int n2, int n3) {
        if (this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.STERNHAUFEN.getKategorienName())) {
            graphics.setColor(Color.YELLOW);
        } else if (this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.BR_ZWERGE.getKategorienName())) {
            graphics.setColor(Color.CYAN);
        }
        graphics.drawOval((int)Math.round((double)n - (double)n2 / 2.0), (int)Math.round((double)n3 - (double)n2 / 2.0), n2, n2);
    }

    private void showBayerFlamsteedName(Graphics graphics, int n, int n2) {
        String string = this.bayerFlamsteedNames.get(this.sternkartenobjekt.getDatenId());
        if (string != null) {
            graphics.setFont(new Font("Serif", 0, 12));
            graphics.setColor(Color.WHITE);
            graphics.drawString(string, n + 10, n2);
        }
    }

    private void paintCircleAroundSearchObjects(Graphics graphics) {
        for (int i = 0; i < this.raZentral.size(); ++i) {
            int n = 10 + (int)Math.round(((double)this.sternkarteKonfiguration.getVonRA() - this.raZentral.get(i)) * this.abschnittRaInPixel);
            int n2 = 10 + (int)Math.round(((double)this.sternkarteKonfiguration.getVonDECL() - this.declZentral.get(i)) * this.abschnittDeclInPixel);
            graphics.setColor(Color.WHITE);
            graphics.drawOval(n - 15, n2 - 15, 30, 30);
            graphics.drawLine(n - 15, n2 - 15, n - 5, n2 - 5);
            graphics.drawLine(n + 5, n2 + 5, n + 15, n2 + 15);
            graphics.drawLine(n - 15, n2 + 15, n - 5, n2 + 5);
            graphics.drawLine(n + 5, n2 - 5, n + 15, n2 - 15);
        }
    }

    protected void scrollRight() {
        if (this.sternkarteKonfiguration.getVonRA() <= this.sternkarteKonfiguration.getTeilerRA() * 24 - 1) {
            this.setCursor(new Cursor(3));
            this.sternkarteKonfiguration.setVonRA(this.sternkarteKonfiguration.getVonRA() + 1);
            this.sternkarteKonfiguration.setBisRA(this.sternkarteKonfiguration.getBisRA() + 1);
            this.repaint();
            this.setCursor(new Cursor(1));
        }
    }

    protected void scrollLeft() {
        if (this.sternkarteKonfiguration.getBisRA() >= 1) {
            this.setCursor(new Cursor(3));
            this.sternkarteKonfiguration.setVonRA(this.sternkarteKonfiguration.getVonRA() - 1);
            this.sternkarteKonfiguration.setBisRA(this.sternkarteKonfiguration.getBisRA() - 1);
            this.repaint();
            this.setCursor(new Cursor(1));
        }
    }

    protected void scrollDown() {
        if (this.sternkarteKonfiguration.getBisDECL() >= 5) {
            this.setCursor(new Cursor(3));
            this.sternkarteKonfiguration.setVonDECL(this.sternkarteKonfiguration.getVonDECL() - 5);
            this.sternkarteKonfiguration.setBisDECL(this.sternkarteKonfiguration.getBisDECL() - 5);
            this.repaint();
            this.setCursor(new Cursor(1));
        }
    }

    protected void scrollUp() {
        if (this.sternkarteKonfiguration.getVonDECL() <= this.sternkarteKonfiguration.getTeilerDECL() * 180 - 5) {
            this.setCursor(new Cursor(3));
            this.sternkarteKonfiguration.setVonDECL(this.sternkarteKonfiguration.getVonDECL() + 5);
            this.sternkarteKonfiguration.setBisDECL(this.sternkarteKonfiguration.getBisDECL() + 5);
            this.repaint();
            this.setCursor(new Cursor(1));
        }
    }

    public void setSterneAnzeigen(boolean bl) {
        this.sterneAnzeigen = bl;
    }

    public void setBraunezwergeAnzeigen(boolean bl) {
        this.braunezwergeAnzeigen = bl;
    }

    public void setExoplanetenAnzeigen(boolean bl) {
        this.exoplanetenAnzeigen = bl;
    }

    public void setExoplanetenEntdeckerprojekteAnzeigen(List<String> list) {
        this.exoplanetenEntdeckerprojekteAnzeigen = list;
    }

    public void setNebelgalaxienAnzeigen(boolean bl) {
        this.nebelgalaxienAnzeigen = bl;
    }

    public void setSetiAnzeigen(boolean bl) {
        this.setiAnzeigen = bl;
    }

    public void setSonstigesAnzeigen(boolean bl) {
        this.sonstigesAnzeigen = bl;
    }

    public void setBayerFlamsteedNamenAnzeigen(boolean bl) {
        this.bayerFlamsteedNamenAnzeigen = bl;
    }

    public boolean isBayerFlamsteedNamenAnzeigen() {
        return this.bayerFlamsteedNamenAnzeigen;
    }

    public void setSpektraltypenAnzeigen(boolean bl) {
        this.spektraltypenAnzeigen = bl;
    }

    public void setSternbilderAnzeigen(boolean bl) {
        this.sternbilderAnzeigen = bl;
    }

    public void setSternbildernamenAnzeigen(boolean bl) {
        this.sternbildernamenAnzeigen = bl;
    }

    public void setSternhaufenAnzeigen(boolean bl) {
        this.sternhaufenAnzeigen = bl;
    }

    public boolean isBraunezwergeAnzeigen() {
        return this.braunezwergeAnzeigen;
    }

    public boolean isExoplanetenAnzeigen() {
        return this.exoplanetenAnzeigen;
    }

    public boolean isNebelgalaxienAnzeigen() {
        return this.nebelgalaxienAnzeigen;
    }

    public boolean isSonstigesAnzeigen() {
        return this.sonstigesAnzeigen;
    }

    public boolean isSpektraltypenAnzeigen() {
        return this.spektraltypenAnzeigen;
    }

    public boolean isSternbilderAnzeigen() {
        return this.sternbilderAnzeigen;
    }

    public boolean isSternbildernamenAnzeigen() {
        return this.sternbildernamenAnzeigen;
    }

    public boolean isSterneAnzeigen() {
        return this.sterneAnzeigen;
    }

    public boolean isSternhaufenAnzeigen() {
        return this.sternhaufenAnzeigen;
    }

    public boolean isSetiAnzeigen() {
        return this.setiAnzeigen;
    }

    public boolean isSternmusterJahreszeitAnzeigen() {
        return this.sternmusterJahreszeitAnzeigen;
    }

    public void setSternmusterJahreszeitAnzeigen(boolean bl) {
        this.sternmusterJahreszeitAnzeigen = bl;
    }
}

