/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.impl.gui;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.GuiDesignerFabrik;
import de.planetensuche.sternkarte.impl.SternmusterJahreszeit;
import de.planetensuche.sternkarte.impl.gui.AbstractSternlinieZeichner;
import de.planetensuche.sternkarte.impl.gui.SternkarteParameterDto;
import de.planetensuche.sternkarte.impl.gui.util.SternmusterJahreszeitColorUtil;
import java.awt.Graphics;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class SternmusterZeichner
extends AbstractSternlinieZeichner {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final Map<SternmusterJahreszeit, List<Pair<Double, Double>>> datenpunkteSternmuster;

    public SternmusterZeichner(SternkarteParameterDto sternkarteParameterDto) {
        super(sternkarteParameterDto);
        this.datenpunkteSternmuster = sternkarteParameterDto.getDatenpunkteSternmuster();
    }

    void zeichneSternmuster(Graphics graphics, int n, int n2, int n3, double d, double d2) {
        try {
            if (this.datenpunkteSternmuster == null || this.datenpunkteSternmuster.isEmpty()) {
                this.logging.info("keine Daten f\u00fcr Sternmuster verf\u00fcgbar");
                return;
            }
            graphics.setFont(GuiDesignerFabrik.getInstance().getFont(false));
            for (Map.Entry<SternmusterJahreszeit, List<Pair<Double, Double>>> entry : this.datenpunkteSternmuster.entrySet()) {
                graphics.setColor(SternmusterJahreszeitColorUtil.getColor(entry.getKey()));
                List<Pair<Double, Double>> list = entry.getValue();
                for (int i = 0; i < list.size() - 1; ++i) {
                    Pair<Double, Double> pair = list.get(i);
                    Pair<Double, Double> pair2 = list.get(i + 1);
                    double d3 = pair.getLeft();
                    double d4 = pair.getRight();
                    double d5 = pair2.getLeft();
                    double d6 = pair2.getRight();
                    this.zeichneLinie(graphics, n, n2, n3, d, d2, d3, d4, d5, d6);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logging.error("zeichneSternmuster(" + graphics.toString() + ")", numberFormatException);
        }
    }
}

