/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.impl.gui.info;

import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.impl.KoordinatenKonverter;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sternkarte.dao.spi.ISternkartenRepository;
import de.planetensuche.sternkarte.impl.Konfiguration;
import de.planetensuche.sternkarte.impl.Sternkartenobjekt;
import de.planetensuche.sternkarte.impl.gui.info.StarMapPictureViewerController;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class ClickOnObjectMouseListener
extends MouseAdapter {
    private final ISprachcontainer i18n;
    private final ILogging logger;
    private final Sternkartenobjekt sternkartenobjekt;
    private final Konfiguration sternkarteKonfiguration;
    private final KoordinatenFormat koordinatenFormat;
    private final StarMapPictureViewerController starMapPictureViewer;
    private final ISternkartenRepository repository;

    public ClickOnObjectMouseListener(Sternkartenobjekt sternkartenobjekt, Konfiguration konfiguration, ISprachcontainer iSprachcontainer, ISternkartenRepository iSternkartenRepository, KoordinatenFormat koordinatenFormat) {
        this.sternkartenobjekt = sternkartenobjekt;
        this.sternkarteKonfiguration = konfiguration;
        this.koordinatenFormat = koordinatenFormat;
        this.repository = iSternkartenRepository;
        this.i18n = iSprachcontainer;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.starMapPictureViewer = new StarMapPictureViewerController(iSprachcontainer, iSternkartenRepository);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        this.sternkartenobjekt.setIndexToNull();
        while (this.sternkartenobjekt.hasNext()) {
            if (!(this.sternkartenobjekt.getMag() <= this.sternkarteKonfiguration.getAktuelleMagnitude())) continue;
            double d = this.sternkartenobjekt.getRaPixel();
            double d2 = this.sternkartenobjekt.getDECLPixel();
            if (!(d > -1.0) || !(d + 6.0 > (double)mouseEvent.getX()) || !(d - 6.0 < (double)mouseEvent.getX()) || !(d2 + 6.0 > (double)mouseEvent.getY()) || !(d2 - 6.0 < (double)mouseEvent.getY())) continue;
            arrayList.add(this.sternkartenobjekt.getName());
        }
        if (!arrayList.isEmpty()) {
            if (arrayList.size() == 1) {
                this.zeigeDaten((String)arrayList.get(0));
            } else {
                Object[] objectArray = new String[arrayList.size()];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = (String)arrayList.get(i);
                }
                Object object = JOptionPane.showInputDialog(null, this.i18n.getString("sim_m120"), this.i18n.getString("sim_m120_titel"), 3, null, objectArray, objectArray[0]);
                if (object != null) {
                    String string = object.toString();
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!((String)objectArray[i]).equals(string)) continue;
                        this.zeigeDaten((String)arrayList.get(i));
                        break;
                    }
                }
            }
        }
    }

    private void zeigeDaten(String string) {
        try {
            String string2 = string;
            if (string2.indexOf(40) > 0) {
                string2 = string2.substring(0, string2.indexOf(40) - 1).trim();
            }
            this.sternkartenobjekt.setIndex(string);
            KoordinatenKonverter koordinatenKonverter = new KoordinatenKonverter(this.i18n);
            koordinatenKonverter.setRa(this.sternkartenobjekt.getRa());
            koordinatenKonverter.setDecl(this.sternkartenobjekt.getDECL());
            String string3 = koordinatenKonverter.toString(this.koordinatenFormat, true);
            String string4 = koordinatenKonverter.toString(this.koordinatenFormat, false);
            String string5 = this.repository.getObjekttypForObjekt(string2);
            this.starMapPictureViewer.zeigeBild(string2);
            String string6 = this.sternkartenobjekt.getDurchmesser() > 0.0 && (this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.GALAXIE_NEBEL.getKategorienName()) || this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.STERNHAUFEN.getKategorienName()) || this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.GALAXIENHAUFEN.getKategorienName()) || this.sternkartenobjekt.getKategorie().equals(ObjektKategorie.SONSTIGES.getKategorienName())) ? this.i18n.getString("stk_m1", string, this.sternkartenobjekt.getSternbildname(), string3, string4, this.i18n.toLocalisedDouble(this.sternkartenobjekt.getMag()), this.i18n.toLocalisedDouble(this.sternkartenobjekt.getDurchmesser()) + "'") : this.i18n.getString("stk_m2", string, this.sternkartenobjekt.getSternbildname(), string3, string4, this.i18n.toLocalisedDouble(this.sternkartenobjekt.getMag()));
            JOptionPane.showMessageDialog(null, string6, string5, 1);
        }
        catch (SQLException sQLException) {
            this.logger.error("zeigeDaten(" + string + ")", sQLException);
        }
    }
}

