/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.impl.gui.info;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.LocalPicturesDataSource;
import de.planetensuche.guidesigner.components.PictureViewer;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sternkarte.dao.spi.ISternkartenRepository;
import de.planetensuche.sternkarte.impl.gui.info.StarMapPictureViewerDialog;
import java.sql.SQLException;
import java.util.Set;

public final class StarMapPictureViewerController {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final ISprachcontainer i18n;
    private final ISternkartenRepository repository;

    public StarMapPictureViewerController(ISprachcontainer iSprachcontainer, ISternkartenRepository iSternkartenRepository) {
        this.i18n = iSprachcontainer;
        this.repository = iSternkartenRepository;
    }

    void zeigeBild(String string) {
        try {
            Integer n = this.repository.getIDFuerNamen(string);
            if (n == null) {
                this.logger.error("Kein Objekt mit dem Namen '" + string + "' gefunden!", null);
                return;
            }
            Set<String> set = this.repository.getBilderFuerDatenid(n);
            if (set != null && !set.isEmpty()) {
                LocalPicturesDataSource localPicturesDataSource = new LocalPicturesDataSource(set);
                PictureViewer pictureViewer = new PictureViewer(BasisdialogId.STERNKARTE_PICTURE_VIEWER, this.i18n.getString("db_bild_gut"), localPicturesDataSource);
                new StarMapPictureViewerDialog(pictureViewer);
            }
        }
        catch (SQLException sQLException) {
            this.logger.error("zeigeBild(" + string + ")", sQLException);
        }
    }
}

