/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.impl.gui.legende;

import de.planetensuche.guidesigner.GuiDesignerFabrik;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sternkarte.impl.Konfiguration;
import de.planetensuche.sternkarte.impl.SternmusterJahreszeit;
import de.planetensuche.sternkarte.impl.gui.SternkarteParameterDto;
import de.planetensuche.sternkarte.impl.gui.TrianglePainter;
import de.planetensuche.sternkarte.impl.gui.legende.LegendeOptionsDto;
import de.planetensuche.sternkarte.impl.gui.util.ObjektdimensionRechner;
import de.planetensuche.sternkarte.impl.gui.util.SternmusterJahreszeitColorUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.Map;

public final class LegendePainter {
    private final Konfiguration sternkarteKonfiguration;
    private final ISprachcontainer i18n;
    private final ObjektdimensionRechner objektdimensionRechner;

    public LegendePainter(SternkarteParameterDto sternkarteParameterDto, ISprachcontainer iSprachcontainer) {
        this.sternkarteKonfiguration = sternkarteParameterDto.getSternkartenkonfiguration();
        this.i18n = iSprachcontainer;
        this.objektdimensionRechner = new ObjektdimensionRechner();
    }

    public void paintLegende(Graphics graphics, LegendeOptionsDto legendeOptionsDto) {
        Map<String, Color> map = legendeOptionsDto.getDiscovererAndColor();
        if (map == null || map.isEmpty()) {
            this.paintDefaultLegend(graphics, legendeOptionsDto);
        } else {
            this.paintExoplanetProjectLegend(graphics, map);
        }
    }

    private void paintDefaultLegend(Graphics graphics, LegendeOptionsDto legendeOptionsDto) {
        double d = this.sternkarteKonfiguration.getAktuelleMagnitude();
        int n = 20;
        int n2 = 20;
        graphics.setColor(Color.white);
        graphics.setFont(GuiDesignerFabrik.getInstance().getFont(false));
        graphics.setFont(new Font("Serif", 1, 20));
        graphics.drawString(this.i18n.getString("sim_gui89"), n, n2);
        graphics.setFont(new Font("Serif", 1, 14));
        n2 += 40;
        if (legendeOptionsDto.isAreStarsVisible()) {
            this.paintStarLegend(graphics, n, n2, d);
            n2 += 75;
        }
        if (legendeOptionsDto.isAreClustersVisible()) {
            this.paintStarClusterLegend(graphics, n, n2 += 50);
            n2 += 10;
        }
        if (legendeOptionsDto.isAreGalaxiesVisible()) {
            this.paintGalaxiesLegend(graphics, n, n2 += 50);
            n2 += 25;
        }
        if (legendeOptionsDto.isAreOtherVisible()) {
            this.paintOtherObjectsLegend(graphics, n, n2 += 50);
            n2 += 15;
        }
        if (legendeOptionsDto.isAreBrownDwarfsVisible()) {
            this.paintBrownDwarftLegend(graphics, n, n2 += 50);
            n2 += 15;
        }
        if (legendeOptionsDto.isAreExoplanetsVisible()) {
            this.paintExoplanetLegend(graphics, n, n2 += 50);
            n2 += 25;
        }
        if (legendeOptionsDto.isStarFilamentSeasonsVisible()) {
            this.paintStarFilamentSeasonsLegend(graphics, n, n2 += 50);
            n2 += 100;
        }
        if (legendeOptionsDto.isSetiVisible()) {
            this.paintSetiLegend(graphics, n, n2 += 50);
        }
    }

    private void paintStarFilamentSeasonsLegend(Graphics graphics, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        for (SternmusterJahreszeit sternmusterJahreszeit : SternmusterJahreszeit.values()) {
            graphics.setColor(Color.white);
            graphics.drawString(this.i18n.getString(sternmusterJahreszeit.getBezeichner()) + ":", n3, n4);
            n4 += 10;
            Color color = SternmusterJahreszeitColorUtil.getColor(sternmusterJahreszeit);
            graphics.setColor(color);
            switch (sternmusterJahreszeit) {
                case FRUEHLING: {
                    new TrianglePainter().drawTriangle(graphics, n3 + 10, n4);
                    break;
                }
                case SOMMER: {
                    new TrianglePainter().drawTriangle(graphics, n3 + 10, n4);
                    break;
                }
                case HERBST: {
                    graphics.drawRect(n3, n4, 8, 8);
                    break;
                }
                case WINTER: {
                    Polygon polygon = new Polygon();
                    polygon.addPoint(n3 + 4, n4);
                    polygon.addPoint(n3 + 2, n4 + 4);
                    polygon.addPoint(n3 + 3, n4 + 6);
                    polygon.addPoint(n3 - 3, n4 + 5);
                    polygon.addPoint(n3 - 2, n4 + 2);
                    polygon.addPoint(n3 + 4, n4);
                    graphics.drawPolygon(polygon);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unbekannte Jahreszeit: " + String.valueOf((Object)sternmusterJahreszeit));
                }
            }
            n4 += 25;
        }
    }

    private void paintSetiLegend(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.WHITE);
        graphics.drawString(this.i18n.getString("sim_gui105") + ":", n, n2);
        graphics.drawOval(n, n2 + 20, 8, 8);
    }

    private void paintExoplanetLegend(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.white);
        graphics.drawString(this.i18n.getString("sim_gui91"), n, n2);
        graphics.drawString(this.i18n.getString("sim_m16") + ":", n, n2 + 15);
        graphics.setColor(Color.BLUE);
        graphics.drawOval(n, n2 + 25, 6, 6);
    }

    private void paintBrownDwarftLegend(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.white);
        graphics.drawString(this.i18n.getString("ps_br_zwerge") + ":", n, n2);
        graphics.setColor(Color.CYAN);
        graphics.drawOval(n, n2 + 15, 8, 8);
    }

    private void paintOtherObjectsLegend(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.white);
        graphics.drawString(this.i18n.getString("ps_sonstiges") + ":", n, n2);
        graphics.setColor(Color.GREEN);
        graphics.drawRect(n, n2 + 15, 8, 8);
    }

    private void paintGalaxiesLegend(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.white);
        graphics.drawString(this.i18n.getString("sim_gui92"), n, n2);
        graphics.drawString(this.i18n.getString("sim_gui93") + ":", n, n2 + 15);
        graphics.setColor(Color.RED);
        graphics.drawOval(n, n2 + 25, 10, 6);
    }

    private void paintStarClusterLegend(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.white);
        graphics.drawString(this.i18n.getString("ps_sternhaufen") + ":", n, n2);
        graphics.setColor(Color.YELLOW);
        graphics.drawOval(n, n2 + 10, 8, 8);
    }

    private void paintStarLegend(Graphics graphics, int n, int n2, double d) {
        graphics.drawString(this.i18n.getString("ps_sterne") + ":", n, n2);
        graphics.drawString("Sirius (-1,47)", n, n2 + 15);
        int n3 = this.objektdimensionRechner.getDurchmesserFuerStern(d, -1.47);
        graphics.fillOval(170, n2 + 4, n3, n3);
        graphics.drawString("Rigel (0,12)", n, n2 + 30);
        n3 = this.objektdimensionRechner.getDurchmesserFuerStern(d, 0.12);
        graphics.fillOval(170, n2 + 22, n3, n3);
        graphics.drawString("Mira (3,04)", n, n2 + 45);
        n3 = this.objektdimensionRechner.getDurchmesserFuerStern(d, 3.04);
        graphics.fillOval(170, n2 + 37, n3, n3);
        graphics.drawString("Sirius B (8,44)", n, n2 + 60);
        if (d >= 8.44) {
            n3 = this.objektdimensionRechner.getDurchmesserFuerStern(d, 8.44);
            graphics.fillOval(170, n2 + 52, n3, n3);
        }
        graphics.drawString(this.i18n.getString("sim_gui90") + ": " + this.i18n.toLocalisedDouble(d) + " mag", n, n2 + 75);
    }

    private void paintExoplanetProjectLegend(Graphics graphics, Map<String, Color> map) {
        int n = 20;
        int n2 = 20;
        graphics.setFont(GuiDesignerFabrik.getInstance().getFont(false));
        graphics.setFont(new Font("Serif", 1, 20));
        graphics.drawString(this.i18n.getString("sim_gui89"), n, n2);
        graphics.setFont(new Font("Serif", 1, 14));
        for (Map.Entry<String, Color> entry : map.entrySet()) {
            n2 += 40;
            graphics.setColor(Color.white);
            String string = entry.getKey();
            String[] stringArray = string.split(" ");
            int n3 = 0;
            while (n3 < stringArray.length) {
                String string2;
                String string3 = string2 = stringArray.length > n3 + 1 ? stringArray[n3] + " " + stringArray[n3 + 1] : stringArray[n3];
                if (string2.length() > 15) {
                    graphics.drawString(stringArray[n3], n, n2);
                    ++n3;
                } else {
                    graphics.drawString(string2, n, n2);
                    n3 += 2;
                }
                n2 += 15;
            }
            graphics.setColor(entry.getValue());
            new TrianglePainter().drawTriangle(graphics, n + 10, n2);
        }
    }
}

