/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sternkarte.impl.gui.settingdialog;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

public class ListItemTransferHandler
extends TransferHandler {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private int[] indices = null;

    public ListItemTransferHandler() {
        super(null);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (!transferSupport.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            this.logger.error("nicht importierbar", null);
            return false;
        }
        return true;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        JList jList = (JList)jComponent;
        this.indices = jList.getSelectedIndices();
        Object[] objectArray = jList.getSelectedValues();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object == null ? "" : object.toString());
            if (i == objectArray.length - 1) continue;
            stringBuilder.append("\n");
        }
        String string = stringBuilder.toString();
        return new StringSelection(string);
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!transferSupport.isDrop()) {
            this.logger.warn("kein drop!");
            return false;
        }
        try {
            String string;
            JList jList = (JList)transferSupport.getComponent();
            DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
            JList.DropLocation dropLocation = (JList.DropLocation)transferSupport.getDropLocation();
            int n = dropLocation.getIndex();
            boolean bl = dropLocation.isInsert();
            Transferable transferable = transferSupport.getTransferable();
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                this.logger.error(exception);
                return false;
            }
            String[] stringArray = string.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                if (bl) {
                    defaultListModel.add(n++, stringArray[i]);
                    continue;
                }
                if (n < defaultListModel.getSize()) {
                    defaultListModel.set(n++, stringArray[i]);
                    continue;
                }
                defaultListModel.add(n++, stringArray[i]);
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
            return false;
        }
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        JList jList = (JList)jComponent;
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        if (n == 2) {
            for (int i = this.indices.length - 1; i >= 0; --i) {
                defaultListModel.remove(this.indices[i]);
            }
        }
        this.indices = null;
    }
}

