/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.umrechner;

import de.planetensuche.guidesigner.IPlanetensucheModul;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.umrechner.helfer.AEUmrechner;
import de.planetensuche.umrechner.helfer.KmUmrechner;
import de.planetensuche.umrechner.helfer.LyUmrechner;
import de.planetensuche.umrechner.helfer.PcUmrechner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class StartGui
extends Basisdialog
implements IPlanetensucheModul {
    private final KmUmrechner kmUmrechnen;
    private final AEUmrechner aeUmrechnen;
    private final LyUmrechner lyUmrechnen;
    private final PcUmrechner pcUmrechnen;
    private final boolean runden;
    private final String astronomischeEinheiten;
    private final String bitteAuswaehlen;
    private JTextField ae;
    private JTextField ausgabe;
    private JButton calculateButton;
    private JTextField eingabe;
    private JComboBox einheitAusgabe;
    private JComboBox einheitEingabe;
    private JTextField ionen;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JTextArea legende;
    private JLabel legendeLabel;
    private JTextField licht;
    private JTextField spaceshuttle;

    public StartGui(KonfigurationDTO konfigurationDTO) throws IOException {
        super(BasisdialogId.UMRECHNER_HAUPTFENSTER);
        this.runden = konfigurationDTO.isErgebnisseRunden();
        this.astronomischeEinheiten = this.i18n.getString("db_m83");
        this.bitteAuswaehlen = this.i18n.getString("um_gui1");
        this.kmUmrechnen = new KmUmrechner(this.astronomischeEinheiten);
        this.aeUmrechnen = new AEUmrechner();
        this.lyUmrechnen = new LyUmrechner(this.astronomischeEinheiten);
        this.pcUmrechnen = new PcUmrechner(this.astronomischeEinheiten);
    }

    @Override
    public void showDialog() {
        if (this.eingabe != null) {
            this.setVisible(true);
            return;
        }
        this.getLogger().info("Umrechner gestartet");
        this.initComponents();
        this.setTitle(this.i18n.getString("um_fenster"));
        this.jLabel1.setText(this.i18n.getString("sim_gui79") + ":");
        this.jLabel2.setText(this.i18n.getString("leb_gui9") + ":");
        this.legendeLabel.setText(this.i18n.getString("sim_gui89") + ":");
        this.calculateButton.setText(this.i18n.getString("fs_gui6"));
        this.legende.setText(this.i18n.getString("um_gui2") + "\n" + this.i18n.getString("um_gui3") + "\n" + this.i18n.getString("um_gui4") + "\n" + this.i18n.getString("um_gui5") + "\n" + this.i18n.getString("um_gui6") + "\n" + this.i18n.getString("um_gui7") + "\n" + this.i18n.getString("um_gui8"));
        this.jLabel4.setText(this.i18n.getString("um_gui9"));
        this.jLabel6.setText(this.i18n.getString("um_gui10"));
        this.jLabel7.setText(this.i18n.getString("um_gui11"));
        this.jLabel5.setText(this.i18n.getString("um_gui12"));
        this.jLabel8.setText(this.i18n.getString("um_gui13"));
        this.einheitEingabe.removeAllItems();
        this.einheitEingabe.addItem(this.bitteAuswaehlen);
        this.einheitEingabe.addItem("km");
        this.einheitEingabe.addItem(this.astronomischeEinheiten);
        this.einheitEingabe.addItem("ly");
        this.einheitEingabe.addItem("pc");
        this.einheitEingabe.addItem("Kpc");
        this.einheitEingabe.addItem("Mpc");
        this.einheitEingabe.addItem("Gpc");
        this.einheitAusgabe.removeAllItems();
        this.einheitAusgabe.addItem(this.bitteAuswaehlen);
        this.einheitAusgabe.addItem("km");
        this.einheitAusgabe.addItem(this.astronomischeEinheiten);
        this.einheitAusgabe.addItem("ly");
        this.einheitAusgabe.addItem("pc");
        this.einheitAusgabe.addItem("Kpc");
        this.einheitAusgabe.addItem("Mpc");
        this.einheitAusgabe.addItem("Gpc");
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(10);
        for (Component component : this.getComponents()) {
            arrayList.add((JComponent)component);
        }
        for (Component component : this.jPanel1.getComponents()) {
            arrayList.add((JComponent)component);
        }
        this.getGuiDesigner().addComponents(arrayList, false);
        this.setVisible(true);
    }

    private void berechneAnzahlAstronomischerEinheiten(String string, double d) {
        double d2 = 0.0;
        if ("km".equals(string)) {
            d2 = d / 1.4959787E8;
        } else if (this.astronomischeEinheiten.equals(string)) {
            d2 = d;
        } else if ("ly".equals(string)) {
            d2 = d / 1.581E-5;
        } else if ("pc".equals(string)) {
            d2 = d / 4.848E-6;
        } else if ("Kpc".equals(string)) {
            d2 = d / 4.848E-9;
        } else if ("Mpc".equals(string)) {
            d2 = d / 4.848E-12;
        } else if ("Gpc".equals(string)) {
            d2 = d / 4.848E-15;
        }
        d2 = (double)Math.round(d2 * 100.0) / 100.0;
        this.ae.setText(this.i18n.toLocalisedDouble(d2) + " " + this.i18n.getString("um_m1"));
    }

    private void berechneDauerFuerIonentriebwerk(String string, double d) {
        String string2;
        double d2 = 0.0;
        double d3 = 35.0;
        if ("km".equals(string)) {
            d2 = d / d3;
        } else if (this.astronomischeEinheiten.equals(string)) {
            d2 = d * 1.49597871E8 / d3;
        } else if ("ly".equals(string)) {
            d2 = d * 9.461E12 / d3;
        } else if ("pc".equals(string)) {
            d2 = d * 3.086E13 / d3;
        } else if ("Kpc".equals(string)) {
            d2 = d * 3.086E16 / d3;
        } else if ("Mpc".equals(string)) {
            d2 = d * 3.086E19 / d3;
        } else if ("Gpc".equals(string)) {
            d2 = d * 3.086E22 / d3;
        }
        if (d2 < 1.0E8) {
            d2 /= 86400.0;
            string2 = " " + this.i18n.getString("um_m5");
        } else {
            d2 /= 3.15576E7;
            string2 = " " + this.i18n.getString("um_m4");
        }
        d2 = (double)Math.round(d2 * 100.0) / 100.0;
        this.ionen.setText(this.i18n.toLocalisedDouble(d2) + string2);
    }

    private void berechneDauerFuerLichtgeschwindigkeit(String string, double d) {
        String string2;
        double d2 = 0.0;
        if ("km".equals(string)) {
            d2 = d / 299792.458;
        } else if (this.astronomischeEinheiten.equals(string)) {
            d2 = d * 1.4959787E8 / 299792.458;
        } else if ("ly".equals(string)) {
            d2 = d * 9.461E12 / 299792.458;
        } else if ("pc".equals(string)) {
            d2 = d * 3.086E13 / 299792.458;
        } else if ("Kpc".equals(string)) {
            d2 = d * 3.086E16 / 299792.458;
        } else if ("Mpc".equals(string)) {
            d2 = d * 3.086E19 / 299792.458;
        } else if ("Gpc".equals(string)) {
            d2 = d * 3.086E22 / 299792.458;
        }
        if (d2 < 10000.0) {
            d2 /= 60.0;
            string2 = " " + this.i18n.getString("um_m2");
        } else if (d2 < 5000000.0 && d2 > 10000.0) {
            d2 /= 3600.0;
            string2 = " " + this.i18n.getString("um_m3");
        } else {
            d2 /= 3.15576E7;
            string2 = " " + this.i18n.getString("um_m4");
        }
        d2 = (double)Math.round(d2 * 100.0) / 100.0;
        this.licht.setText(this.i18n.toLocalisedDouble(d2) + string2);
    }

    private void calculateDurationForChemicalEngine(String string, double d) {
        String string2;
        double d2 = 0.0;
        double d3 = 20.0;
        if ("km".equals(string)) {
            d2 = d / d3;
        } else if (this.astronomischeEinheiten.equals(string)) {
            d2 = d * 1.4959787E8 / d3;
        } else if ("ly".equals(string)) {
            d2 = d * 9.461E12 / d3;
        } else if ("pc".equals(string)) {
            d2 = d * 3.086E13 / d3;
        } else if ("Kpc".equals(string)) {
            d2 = d * 3.086E16 / d3;
        } else if ("Mpc".equals(string)) {
            d2 = d * 3.086E19 / d3;
        } else if ("Gpc".equals(string)) {
            d2 = d * 3.086E22 / d3;
        }
        if (d2 < 1.0E8) {
            d2 /= 86400.0;
            string2 = " " + this.i18n.getString("um_m5");
        } else {
            d2 /= 3.15576E7;
            string2 = " " + this.i18n.getString("um_m4");
        }
        d2 = (double)Math.round(d2 * 100.0) / 100.0;
        this.spaceshuttle.setText(this.i18n.toLocalisedDouble(d2) + string2);
    }

    private void initComponents() {
        this.eingabe = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.ausgabe = new JTextField();
        this.einheitEingabe = new JComboBox();
        this.einheitAusgabe = new JComboBox();
        this.calculateButton = new JButton();
        this.legendeLabel = new JLabel();
        this.legende = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.ae = new JTextField();
        this.jLabel6 = new JLabel();
        this.licht = new JTextField();
        this.jLabel7 = new JLabel();
        this.spaceshuttle = new JTextField();
        this.jLabel5 = new JLabel();
        this.ionen = new JTextField();
        this.jLabel8 = new JLabel();
        this.setTitle("Umrechner");
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.getContentPane().add(this.eingabe);
        this.eingabe.setBounds(20, 30, 160, 24);
        this.jLabel1.setText("Entfernung:");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(20, 10, 100, 24);
        this.jLabel2.setText("Ergebnis:");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(20, 80, 120, 24);
        this.ausgabe.setEditable(false);
        this.getContentPane().add(this.ausgabe);
        this.ausgabe.setBounds(20, 100, 160, 24);
        this.getContentPane().add(this.einheitEingabe);
        this.einheitEingabe.setBounds(210, 30, 140, 24);
        this.getContentPane().add(this.einheitAusgabe);
        this.einheitAusgabe.setBounds(210, 100, 140, 24);
        this.calculateButton.setText("rechne um");
        this.calculateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartGui.this.calculateButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.calculateButton);
        this.calculateButton.setBounds(240, 130, 110, 24);
        this.legendeLabel.setText("Legende:");
        this.getContentPane().add(this.legendeLabel);
        this.legendeLabel.setBounds(370, 10, 110, 24);
        this.legende.setEditable(false);
        this.legende.setColumns(20);
        this.legende.setFont(new Font("Arial", 0, 12));
        this.legende.setRows(5);
        this.legende.setText("km - ein Kilometer\nAE - eine Astronomische Einheit\nly - ein Lichtjahr\npc - ein Parsec\nKpc - 1.000 Parsec\nMpc - eine Million Parsec\nGpc - eine Milliarde Parsec");
        this.legende.setAutoscrolls(false);
        this.legende.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.getContentPane().add(this.legende);
        this.legende.setBounds(370, 30, 250, 130);
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setLayout(null);
        this.jLabel4.setText("Entfernung zwischen Sonne und Erde (1 AE):");
        this.jPanel1.add(this.jLabel4);
        this.jLabel4.setBounds(10, 10, 560, 24);
        this.ae.setEditable(false);
        this.jPanel1.add(this.ae);
        this.ae.setBounds(20, 30, 240, 24);
        this.jLabel6.setText("die Zeit, die das Licht dafuer benoetigt:");
        this.jPanel1.add(this.jLabel6);
        this.jLabel6.setBounds(10, 60, 520, 24);
        this.licht.setEditable(false);
        this.jPanel1.add(this.licht);
        this.licht.setBounds(20, 80, 240, 24);
        this.jLabel7.setText("* die Zeit, die ein SpaceShuttle mit einem chemischen Antrieb dafuer benoetigt (7,9 km/s):");
        this.jPanel1.add(this.jLabel7);
        this.jLabel7.setBounds(10, 110, 600, 24);
        this.spaceshuttle.setEditable(false);
        this.jPanel1.add(this.spaceshuttle);
        this.spaceshuttle.setBounds(20, 130, 240, 24);
        this.jLabel5.setText("* die Zeit, die ein Raumschiff/Raumsonde mit einem Ionentriebwerk dafuer benoetigt (20 km/s):");
        this.jPanel1.add(this.jLabel5);
        this.jLabel5.setBounds(10, 160, 600, 24);
        this.ionen.setEditable(false);
        this.jPanel1.add(this.ionen);
        this.ionen.setBounds(20, 180, 240, 24);
        this.jLabel8.setText("* grobe Abschaetzung, da die Geschwindigkeit u.a. abhaengig von der Gesamtmasse ist");
        this.jPanel1.add(this.jLabel8);
        this.jLabel8.setBounds(10, 220, 600, 24);
        this.getContentPane().add(this.jPanel1);
        this.jPanel1.setBounds(10, 170, 610, 250);
        this.setSize(new Dimension(639, 463));
        this.setLocationRelativeTo(null);
    }

    void setInputNumberAsString(String string) {
        this.eingabe.setText(string);
    }

    void setInputUnit(String string) {
        this.einheitEingabe.setSelectedItem(string);
    }

    void setOutputUnit(String string) {
        this.einheitAusgabe.setSelectedItem(string);
    }

    String getOutputNumberAsString() {
        return this.ausgabe.getText();
    }

    private void calculateButtonActionPerformed(ActionEvent actionEvent) {
        this.calculate();
    }

    void calculate() throws HeadlessException {
        try {
            double d = this.i18n.parseDouble(this.eingabe.getText());
            double d2 = 0.0;
            if (this.einheitEingabe.getSelectedIndex() < 1 || this.einheitAusgabe.getSelectedIndex() < 1) {
                JOptionPane.showMessageDialog(this, this.i18n.getString("um_f3"), this.i18n.getString("um_f3_titel"), 0);
            } else {
                String string = this.einheitEingabe.getSelectedItem().toString();
                if (this.einheitEingabe.getSelectedIndex() == this.einheitAusgabe.getSelectedIndex()) {
                    this.ausgabe.setText(this.eingabe.getText());
                } else {
                    String string2 = this.einheitAusgabe.getSelectedItem().toString();
                    if ("km".equals(string)) {
                        d2 = this.kmUmrechnen.getErgebnis(d, string2);
                    } else if (this.astronomischeEinheiten.equals(string)) {
                        d2 = this.aeUmrechnen.getErgebnis(d, string2);
                    } else if ("ly".equals(string)) {
                        d2 = this.lyUmrechnen.getErgebnis(d, string2);
                    } else if ("pc".equals(string)) {
                        d2 = this.pcUmrechnen.getErgebnis(d, string2);
                    } else if ("Kpc".equals(string)) {
                        d2 = this.pcUmrechnen.getErgebnis(d, string2) * 1000.0;
                    } else if ("Mpc".equals(string)) {
                        d2 = this.pcUmrechnen.getErgebnis(d, string2) * 1000000.0;
                    } else if ("Gpc".equals(string)) {
                        d2 = this.pcUmrechnen.getErgebnis(d, string2) * 1.0E9;
                    }
                }
                if (this.runden) {
                    d2 = (double)Math.round(d2 * 100.0) / 100.0;
                }
                this.ausgabe.setText(this.i18n.toLocalisedDouble(d2));
                this.berechneAnzahlAstronomischerEinheiten(string, d);
                this.berechneDauerFuerLichtgeschwindigkeit(string, d);
                this.calculateDurationForChemicalEngine(string, d);
                this.berechneDauerFuerIonentriebwerk(string, d);
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(this, this.i18n.getString("db_f16") + "\n" + exception.toString(), this.i18n.getString("db_f56_titel"), 0);
        }
    }
}

