/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.web.connector.bugreport;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.web.connector.bugreport.ErrorReportDtoV1;
import de.planetensuche.web.connector.config.MyRestTemplate;
import de.planetensuche.web.connector.config.RemoteEchoHelper;
import de.planetensuche.web.connector.internal.AbstractRestClient;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

public final class ErrorReportClientService
extends AbstractRestClient {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final String reportUrl;

    public ErrorReportClientService(char[] cArray, KonfigurationDTO konfigurationDTO) {
        super(cArray);
        this.reportUrl = "https://" + konfigurationDTO.getHomepageHostname() + ":" + konfigurationDTO.getPort() + "/errorReport";
    }

    @RemoteEchoHelper
    public ErrorReportDtoV1 getLast() {
        try {
            String string = this.reportUrl + "/lastReport";
            MyRestTemplate myRestTemplate = new MyRestTemplate(this.arrayToString(this.sslProvider), this.arrayToString((Object[])this.feuerOld()));
            ErrorReportDtoV1 errorReportDtoV1 = myRestTemplate.getForObject(new URI(string), ErrorReportDtoV1.class);
            return errorReportDtoV1;
        }
        catch (URISyntaxException | RestClientException exception) {
            this.logger.error(exception);
            return null;
        }
    }

    public boolean send(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("content is null");
        }
        try {
            String string3 = this.reportUrl + "/addReport";
            ErrorReportDtoV1 errorReportDtoV1 = new ErrorReportDtoV1();
            errorReportDtoV1.setContent(string2);
            errorReportDtoV1.setEmail(string);
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl(string3);
            HttpEntity<ErrorReportDtoV1> httpEntity = new HttpEntity<ErrorReportDtoV1>(errorReportDtoV1);
            MyRestTemplate myRestTemplate = new MyRestTemplate(this.arrayToString(this.sslProvider), this.arrayToString((Object[])this.feuerOld()));
            myRestTemplate.exchange(uriComponentsBuilder.build().encode().toUri(), HttpMethod.PUT, httpEntity, Boolean.class);
            return true;
        }
        catch (RestClientException restClientException) {
            this.logger.error("Report senden fehlgeschlagen", restClientException);
            return false;
        }
    }

    public boolean send(String string) {
        return this.send(null, string);
    }
}

