/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.web.connector.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public final class MyRestTemplate
extends RestTemplate {
    public MyRestTemplate(String string, String string2) {
        this.setRequestFactory(string, string2);
        ArrayList arrayList = new ArrayList();
        arrayList.add(new MappingJackson2HttpMessageConverter());
        this.setMessageConverters(arrayList);
    }

    private void setRequestFactory(String string, String string2) {
        if (string == null) {
            return;
        }
        List<ClientHttpRequestInterceptor> list = Collections.singletonList(new BasicAuthorizationInterceptor(string, string2));
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        simpleClientHttpRequestFactory.setReadTimeout(6000);
        simpleClientHttpRequestFactory.setConnectTimeout(6000);
        super.setRequestFactory(simpleClientHttpRequestFactory);
        this.setInterceptors(list);
    }

    private static class BasicAuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        private final String jola;
        private final String pandola;

        public BasicAuthorizationInterceptor(String string, String string2) {
            this.jola = string;
            this.pandola = string2 == null ? "" : string2;
        }

        @Override
        public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] byArray, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
            String string = this.jola + ":" + this.pandola;
            byte[] byArray2 = Base64.getEncoder().encode(string.getBytes());
            httpRequest.getHeaders().add("Authorization", "Basic " + new String(byArray2));
            return clientHttpRequestExecution.execute(httpRequest, byArray);
        }
    }
}

