/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.web.connector.featurerequest;

import de.planetensuche.core.Check;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.web.connector.config.MyRestTemplate;
import de.planetensuche.web.connector.config.RemoteEchoHelper;
import de.planetensuche.web.connector.featurerequest.FeatureRequestDtoV1;
import de.planetensuche.web.connector.featurerequest.FeatureRequestSaveFailedException;
import de.planetensuche.web.connector.internal.AbstractRestClient;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

public final class FeatureRequestClientService
extends AbstractRestClient {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final String baseUrl;

    public FeatureRequestClientService(KonfigurationDTO konfigurationDTO) {
        super(new char[]{'f', 'e', 'a', 't', 'u', 'r', 'e'});
        this.baseUrl = "https://" + konfigurationDTO.getHomepageHostname() + ":" + konfigurationDTO.getPort() + "/feature-request";
    }

    @RemoteEchoHelper
    public void save(FeatureRequestDtoV1 featureRequestDtoV1) throws FeatureRequestSaveFailedException {
        if (featureRequestDtoV1 == null || Check.isEmpty(featureRequestDtoV1.getPlanetensucheVersion())) {
            throw new IllegalArgumentException("dto is null");
        }
        try {
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl(this.baseUrl);
            HttpEntity<FeatureRequestDtoV1> httpEntity = new HttpEntity<FeatureRequestDtoV1>(featureRequestDtoV1);
            MyRestTemplate myRestTemplate = new MyRestTemplate(this.findUrl(), this.checkResponse());
            ResponseEntity<Void> responseEntity = myRestTemplate.exchange(uriComponentsBuilder.build().encode().toUri(), HttpMethod.POST, httpEntity, Void.class);
            if (responseEntity.getStatusCodeValue() != 200) {
                FeatureRequestSaveFailedException featureRequestSaveFailedException = new FeatureRequestSaveFailedException();
                this.logger.error("Senden der Feature Anfrage fehlgeschlagen (http code " + responseEntity.getStatusCodeValue() + "): " + featureRequestDtoV1.toString(), featureRequestSaveFailedException);
                throw featureRequestSaveFailedException;
            }
        }
        catch (RestClientException restClientException) {
            this.logger.error("Senden der Feature Anfrage fehlgeschlagen: " + featureRequestDtoV1.toString(), restClientException);
            throw new FeatureRequestSaveFailedException();
        }
    }

    private String findUrl() {
        return this.arrayToString(this.sslProvider);
    }

    private String checkResponse() {
        return "4Jn-L50n6LR.gXPf_5";
    }
}

