/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.web.connector.install;

import de.planetensuche.core.Check;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.web.connector.config.MyRestTemplate;
import de.planetensuche.web.connector.config.RemoteEchoHelper;
import de.planetensuche.web.connector.install.InstallationCountDtoV1;
import de.planetensuche.web.connector.internal.AbstractRestClient;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

public final class InstallationCountClientService
extends AbstractRestClient {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final String baseUrl;

    public InstallationCountClientService(KonfigurationDTO konfigurationDTO) {
        super(new char[]{'i', 'n', 's', 't', 'a', 'l', 'l', 'e', 'r'});
        this.baseUrl = "https://" + konfigurationDTO.getHomepageHostname() + ":" + konfigurationDTO.getPort() + "/installation-count";
    }

    @RemoteEchoHelper
    public boolean save(InstallationCountDtoV1 installationCountDtoV1) {
        if (installationCountDtoV1 == null || Check.isEmpty(installationCountDtoV1.getPlanetensucheVersion())) {
            throw new IllegalArgumentException("dto is null");
        }
        try {
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl(this.baseUrl);
            HttpEntity<InstallationCountDtoV1> httpEntity = new HttpEntity<InstallationCountDtoV1>(installationCountDtoV1);
            MyRestTemplate myRestTemplate = new MyRestTemplate(this.findYz(), this.findAbc());
            ResponseEntity<Boolean> responseEntity = myRestTemplate.exchange(uriComponentsBuilder.build().encode().toUri(), HttpMethod.POST, httpEntity, Boolean.class);
            return (Boolean)responseEntity.getBody();
        }
        catch (RestClientException restClientException) {
            this.logger.error("Senden der Installationsz\u00e4hlung fehlgeschlagen", restClientException);
            return false;
        }
    }

    private String findYz() {
        return this.arrayToString(this.sslProvider);
    }

    private String findAbc() {
        return "54nfjqwoRsdsjkTg2N.4v";
    }
}

