/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.web.connector.statistic;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.web.connector.config.MyRestTemplate;
import de.planetensuche.web.connector.config.RemoteEchoHelper;
import de.planetensuche.web.connector.internal.AbstractRestClient;
import de.planetensuche.web.connector.statistic.UserStatisticDtoV1;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

public final class UserStatisticClientService
extends AbstractRestClient {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final String userStatisticUrl;

    public UserStatisticClientService(char[] cArray, KonfigurationDTO konfigurationDTO) {
        super(cArray);
        this.userStatisticUrl = "https://" + konfigurationDTO.getHomepageHostname() + ":" + konfigurationDTO.getPort() + "/user-statistic";
    }

    @RemoteEchoHelper
    public UserStatisticDtoV1 getRecent() {
        try {
            String string = this.userStatisticUrl + "/latest";
            MyRestTemplate myRestTemplate = new MyRestTemplate(this.arrayToString(this.sslProvider), this.arrayToString((Object[])this.feuerOld()));
            UserStatisticDtoV1 userStatisticDtoV1 = myRestTemplate.getForObject(new URI(string), UserStatisticDtoV1.class);
            return userStatisticDtoV1;
        }
        catch (URISyntaxException | RestClientException exception) {
            this.logger.error(exception);
            return null;
        }
    }

    @RemoteEchoHelper
    public boolean save(UserStatisticDtoV1 userStatisticDtoV1) {
        if (userStatisticDtoV1 == null) {
            throw new IllegalArgumentException("dto is null");
        }
        try {
            String string = this.userStatisticUrl;
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl(string);
            HttpEntity<UserStatisticDtoV1> httpEntity = new HttpEntity<UserStatisticDtoV1>(userStatisticDtoV1);
            MyRestTemplate myRestTemplate = new MyRestTemplate(this.arrayToString(this.sslProvider), this.arrayToString((Object[])this.feuerOld()));
            ResponseEntity<Boolean> responseEntity = myRestTemplate.exchange(uriComponentsBuilder.build().encode().toUri(), HttpMethod.POST, httpEntity, Boolean.class);
            return (Boolean)responseEntity.getBody();
        }
        catch (RestClientException restClientException) {
            this.logger.error("Senden der anonymen user statistic fehlgeschlagen", restClientException);
            return false;
        }
    }
}

