/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.web.connector.voting;

import com.fasterxml.jackson.databind.json.JsonMapper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.web.connector.config.MyRestTemplate;
import de.planetensuche.web.connector.config.RemoteEchoHelper;
import de.planetensuche.web.connector.internal.AbstractRestClient;
import de.planetensuche.web.connector.internal.BasicUrlService;
import de.planetensuche.web.connector.internal.RestHelperFactory;
import de.planetensuche.web.connector.internal.VotingServerUrlService;
import de.planetensuche.web.connector.util.HttpClientFactory;
import de.planetensuche.web.connector.voting.VotingCategory;
import de.planetensuche.web.connector.voting.VotingDtoV1;
import de.planetensuche.web.connector.voting.VotingService;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

public final class RemoteVotingService
extends AbstractRestClient
implements VotingService {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final VotingServerUrlService votingServerUrlService;
    private final RestHelperFactory helperFactory;

    public RemoteVotingService(char[] cArray, String string, int n) {
        super(cArray);
        this.votingServerUrlService = new BasicUrlService(string, n);
        this.helperFactory = new RestHelperFactory(cArray);
    }

    public VotingDtoV1 getLastWithJavaHttpClient() throws URISyntaxException, IOException, InterruptedException, NoSuchAlgorithmException, KeyManagementException {
        HttpClient httpClient = HttpClientFactory.create();
        byte[] byArray = Base64.getEncoder().encode((this.helperFactory.getC() + ":" + this.helperFactory.getGetter()).getBytes());
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(this.votingServerUrlService.getLastVotingUrl())).header("Authorization", "Basic " + new String(byArray)).header("Accept", "application/json").GET().timeout(Duration.ofSeconds(6L)).build();
        HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString(Charset.forName("utf8")));
        JsonMapper jsonMapper = new JsonMapper();
        return jsonMapper.readValue(httpResponse.body(), VotingDtoV1.class);
    }

    @Override
    @RemoteEchoHelper
    public VotingDtoV1 getLast() {
        try {
            String string = this.votingServerUrlService.getLastVotingUrl();
            this.logger.debug("url='" + string + "'");
            MyRestTemplate myRestTemplate = new MyRestTemplate(this.helperFactory.getC(), this.helperFactory.getGetter());
            VotingDtoV1 votingDtoV1 = myRestTemplate.getForObject(new URI(string), VotingDtoV1.class);
            return votingDtoV1;
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        catch (IOException | URISyntaxException | RestClientException exception) {
            if (!(exception.getCause() instanceof UnknownHostException) && !(exception.getCause() instanceof SocketTimeoutException)) {
                this.logger.error(exception);
            }
            return null;
        }
    }

    @Override
    public boolean isVotingAllowed(VotingCategory votingCategory, String string) {
        try {
            String string2 = this.votingServerUrlService.getIsVotingAllowedUrl();
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl(string2).queryParam("votingCategory", votingCategory.name()).queryParam("username", string);
            URI uRI = uriComponentsBuilder.build().encode().toUri();
            MyRestTemplate myRestTemplate = new MyRestTemplate(this.helperFactory.getC(), this.helperFactory.getGetter());
            Boolean bl = myRestTemplate.getForObject(uRI, Boolean.class);
            this.logger.debug("result for category " + votingCategory.name() + " and user " + string + " is " + bl);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        catch (RestClientException restClientException) {
            if (!(restClientException.getCause() instanceof UnknownHostException) && !(restClientException.getCause() instanceof SocketTimeoutException)) {
                this.logger.error("Voting Status abfragen ist fehlgeschlagen", restClientException);
            }
            return false;
        }
    }

    @Override
    public boolean addNewVoting(String string, VotingCategory votingCategory, String string2) {
        if (string == null || string.isEmpty()) {
            this.logger.warn("addNewVoting called for empty objectname");
            return false;
        }
        if (votingCategory == null) {
            this.logger.warn("addNewVoting called for empty votingCategory");
            return false;
        }
        if (string2 == null || string2.isEmpty()) {
            this.logger.warn("addNewVoting called for empty username");
            return false;
        }
        try {
            String string3 = this.votingServerUrlService.getAddVotingUrl();
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl(string3);
            VotingDtoV1 votingDtoV1 = new VotingDtoV1();
            votingDtoV1.setCategory(votingCategory);
            votingDtoV1.setCountryCode(System.getProperty("user.country"));
            votingDtoV1.setCreated(new Date());
            votingDtoV1.setObjectName(string);
            votingDtoV1.setUsername(string2);
            MyRestTemplate myRestTemplate = new MyRestTemplate(this.helperFactory.getC(), this.helperFactory.getGetter());
            URI uRI = uriComponentsBuilder.build().encode().toUri();
            myRestTemplate.exchange(uRI, HttpMethod.POST, new HttpEntity<VotingDtoV1>(votingDtoV1), Boolean.class);
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        catch (RestClientException restClientException) {
            this.logger.error("Voting fehlgeschlagen", restClientException);
            return false;
        }
    }

    @Override
    public boolean addNewPictureVoting(String string, String string2, String string3) {
        if (string2 == null || string2.isEmpty()) {
            this.logger.warn("addNewVoting called for empty objectname");
            return false;
        }
        if (string == null || string.isEmpty()) {
            this.logger.warn("addNewVoting called for empty picture");
            return false;
        }
        if (string3 == null || string3.isEmpty()) {
            this.logger.warn("addNewVoting called for empty username");
            return false;
        }
        try {
            String string4 = this.votingServerUrlService.getAddVotingUrl();
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl(string4);
            VotingDtoV1 votingDtoV1 = new VotingDtoV1();
            votingDtoV1.setCategory(VotingCategory.PICTURE);
            votingDtoV1.setCountryCode(System.getProperty("user.country"));
            votingDtoV1.setCreated(new Date());
            votingDtoV1.setObjectName(string + "@" + string2);
            votingDtoV1.setUsername(string3);
            MyRestTemplate myRestTemplate = new MyRestTemplate(this.helperFactory.getC(), this.helperFactory.getGetter());
            URI uRI = uriComponentsBuilder.build().encode().toUri();
            ResponseEntity<Boolean> responseEntity = myRestTemplate.exchange(uRI, HttpMethod.POST, new HttpEntity<VotingDtoV1>(votingDtoV1), Boolean.class);
            this.logger.debug("result: " + responseEntity.toString());
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        catch (RestClientException restClientException) {
            this.logger.error("Voting fehlgeschlagen", restClientException);
            return false;
        }
    }

    @Override
    public List<VotingDtoV1> getTop10(VotingCategory votingCategory) {
        try {
            String string = this.votingServerUrlService.getTopVotingUrl();
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl(string).queryParam("votingCategory", votingCategory.name());
            MyRestTemplate myRestTemplate = new MyRestTemplate(this.helperFactory.getC(), this.helperFactory.getGetter());
            ParameterizedTypeReference<Collection<VotingDtoV1>> parameterizedTypeReference = new ParameterizedTypeReference<Collection<VotingDtoV1>>(this){};
            URI uRI = uriComponentsBuilder.build().encode().toUri();
            ResponseEntity<Collection<VotingDtoV1>> responseEntity = myRestTemplate.exchange(uRI, HttpMethod.GET, HttpEntity.EMPTY, parameterizedTypeReference);
            Collection collection = (Collection)responseEntity.getBody();
            return new ArrayList<VotingDtoV1>(collection);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        catch (RestClientException restClientException) {
            if (!(restClientException.getCause() instanceof UnknownHostException) && !(restClientException.getCause() instanceof SocketTimeoutException)) {
                this.logger.error(restClientException);
            }
            return null;
        }
    }
}

