/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.web.connector.windowaccess;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.web.connector.config.MyRestTemplate;
import de.planetensuche.web.connector.config.RemoteEchoHelper;
import de.planetensuche.web.connector.internal.AbstractRestClient;
import de.planetensuche.web.connector.windowaccess.WindowAccessDto;
import de.planetensuche.web.connector.windowaccess.WindowAccessRestException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

public class WindowAccessRestClient
extends AbstractRestClient {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final String windowAccessUrl;

    public WindowAccessRestClient(KonfigurationDTO konfigurationDTO) {
        super(new char[]{'w', 'i', 'n', 'd', 'o', 'w', '-', 'a', 'c', 'c', 'e', 's', 's'});
        this.windowAccessUrl = "https://" + konfigurationDTO.getHomepageHostname() + ":" + konfigurationDTO.getPort() + "/window-access";
    }

    @RemoteEchoHelper
    public void save(WindowAccessDto windowAccessDto) throws WindowAccessRestException {
        if (windowAccessDto == null || windowAccessDto.getWindowId() == null) {
            throw new IllegalArgumentException("dto is null");
        }
        try {
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString(this.windowAccessUrl);
            HttpEntity<WindowAccessDto> httpEntity = new HttpEntity<WindowAccessDto>(windowAccessDto);
            MyRestTemplate myRestTemplate = new MyRestTemplate(this.findUrl(), this.checkResponse());
            ResponseEntity<Void> responseEntity = myRestTemplate.exchange(uriComponentsBuilder.build().encode().toUri(), HttpMethod.POST, httpEntity, Void.class);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                WindowAccessRestException windowAccessRestException = new WindowAccessRestException();
                this.logger.error("Senden des Fenster Aufrufs fehlgeschlagen (http code " + responseEntity.getStatusCode().value() + "): " + windowAccessDto.toString(), windowAccessRestException);
                throw windowAccessRestException;
            }
            this.logger.debug("Senden des Fenster Aufrufs mit id " + windowAccessDto.getWindowId() + " erfolgreich abgeschlossen");
        }
        catch (RestClientException restClientException) {
            this.logger.error("Senden des Fenster Aufrufs fehlgeschlagen: " + windowAccessDto.toString(), restClientException);
            throw new WindowAccessRestException();
        }
    }

    private String findUrl() {
        return this.arrayToString(this.sslProvider);
    }

    private String checkResponse() {
        return "nig349as#\u00a7VJsd9q34";
    }
}

