/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.hc.client5.http.entity.mime.AbstractContentBody;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.util.Args;

public class PathBody
extends AbstractContentBody {
    private final String fileName;
    private final Path path;

    private static String getFileName(Path path) {
        return path != null ? Objects.toString(path.getFileName(), null) : null;
    }

    public PathBody(Path path) {
        this(path, ContentType.DEFAULT_BINARY, PathBody.getFileName(path));
    }

    public PathBody(Path path, ContentType contentType) {
        this(path, contentType, PathBody.getFileName(path));
    }

    public PathBody(Path path, ContentType contentType, String fileName) {
        super(contentType);
        this.path = Args.notNull(path, "path");
        this.fileName = fileName == null ? PathBody.getFileName(path) : fileName;
    }

    @Override
    public long getContentLength() {
        try {
            return Files.size(this.path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String getFilename() {
        return this.fileName;
    }

    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Files.copy(this.path, Args.notNull(out, "Output stream"));
    }
}

