/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import org.apache.hc.client5.http.EarlyHintsListener;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;

public final class EarlyHintsAsyncExec
implements AsyncExecChainHandler {
    private final EarlyHintsListener listener;

    public EarlyHintsAsyncExec(EarlyHintsListener listener) {
        this.listener = listener;
    }

    @Override
    public void execute(HttpRequest request, AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback callback) throws HttpException, IOException {
        if (this.listener == null) {
            chain.proceed(request, entityProducer, scope, callback);
            return;
        }
        chain.proceed(request, entityProducer, scope, new AsyncExecCallback(){

            @Override
            public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                if (response.getCode() == 103) {
                    EarlyHintsAsyncExec.this.listener.onEarlyHints(response, scope.clientContext);
                }
                callback.handleInformationResponse(response);
            }

            @Override
            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                return callback.handleResponse(response, entityDetails);
            }

            @Override
            public void completed() {
                callback.completed();
            }

            @Override
            public void failed(Exception cause) {
                callback.failed(cause);
            }
        });
    }
}

