/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.SaslPrep;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.UNSAFE)
@Experimental
public final class ScramScheme
implements AuthScheme {
    private static final Logger LOG = LoggerFactory.getLogger(ScramScheme.class);
    private static final String GS2_HEADER = "n,,";
    private static final String C_BIND_B64 = "biws";
    private static final Base64.Encoder B64 = Base64.getEncoder().withoutPadding();
    private static final Base64.Decoder B64D = Base64.getDecoder();
    private final SecureRandom secureRandom;
    private final int warnMinIterations;
    private final int minIterationsRequired;
    private State state = State.INIT;
    private boolean complete;
    private String realm;
    private String sid;
    private String username;
    private char[] password;
    private Principal principal;
    private String clientNonce;
    private String clientFirstBare;
    private String serverFirstRaw;
    private String serverNonce;
    private byte[] salt;
    private int iterations;
    private byte[] expectedV;

    public ScramScheme() {
        this(4096, 0, null);
    }

    public ScramScheme(int warnMinIterations, int minIterationsRequired, SecureRandom rnd) {
        this.warnMinIterations = Math.max(0, warnMinIterations);
        this.minIterationsRequired = Math.max(0, minIterationsRequired);
        this.secureRandom = rnd != null ? rnd : new SecureRandom();
    }

    @Override
    public String getName() {
        return "SCRAM-SHA-256";
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public boolean isChallengeExpected() {
        return true;
    }

    @Override
    public void processChallenge(AuthChallenge authChallenge, HttpContext context) throws MalformedChallengeException {
        try {
            this.processChallenge(null, true, authChallenge, context);
        }
        catch (AuthenticationException ex) {
            throw new MalformedChallengeException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processChallenge(HttpHost host, boolean challenged, AuthChallenge authChallenge, HttpContext context) throws MalformedChallengeException, AuthenticationException {
        boolean match;
        Args.notNull(context, "HTTP context");
        if (authChallenge == null) {
            if (!challenged) {
                return;
            }
            throw new MalformedChallengeException("Null SCRAM challenge");
        }
        Map<String, String> params = ScramScheme.toParamMap(authChallenge.getParams());
        if (challenged) {
            String decoded;
            String scheme = authChallenge.getSchemeName();
            if (scheme == null || !"SCRAM-SHA-256".equalsIgnoreCase(scheme)) {
                throw new MalformedChallengeException("Unexpected scheme: " + scheme);
            }
            String data = params.get("data");
            if (data == null) {
                this.realm = params.get("realm");
                this.state = State.ANNOUNCED;
                this.complete = false;
                this.zeroAndClearExpectedV();
                return;
            }
            this.serverFirstRaw = decoded = ScramScheme.b64ToString(data);
            Map<String, String> attrs = ScramScheme.parseAttrs(decoded);
            String r = attrs.get("r");
            String s = attrs.get("s");
            String i = attrs.get("i");
            if (r == null || r.isEmpty() || s == null || s.isEmpty() || i == null || i.isEmpty()) {
                this.state = State.FAILED;
                throw new MalformedChallengeException("SCRAM server-first missing r/s/i");
            }
            if (this.clientNonce == null || !r.startsWith(this.clientNonce)) {
                this.state = State.FAILED;
                throw new AuthenticationException("SCRAM server nonce does not start with client nonce");
            }
            this.sid = params.get("sid");
            try {
                this.salt = B64D.decode(s);
                if (this.salt.length == 0) {
                    throw new IllegalArgumentException("empty salt");
                }
            }
            catch (IllegalArgumentException e) {
                this.state = State.FAILED;
                throw new MalformedChallengeException("Invalid base64 salt", e);
            }
            try {
                this.iterations = Integer.parseInt(i);
                if (this.iterations <= 0) {
                    throw new NumberFormatException("i<=0");
                }
            }
            catch (NumberFormatException e) {
                this.state = State.FAILED;
                throw new MalformedChallengeException("Invalid iteration count", e);
            }
            if (this.minIterationsRequired > 0 && this.iterations < this.minIterationsRequired) {
                this.state = State.FAILED;
                throw new AuthenticationException("SCRAM iteration count below required minimum: " + this.iterations + " < " + this.minIterationsRequired);
            }
            if (this.warnMinIterations > 0 && this.iterations < this.warnMinIterations && LOG.isWarnEnabled()) {
                LOG.warn("SCRAM iteration count ({}) lower than recommended ({})", (Object)this.iterations, (Object)this.warnMinIterations);
            }
            this.serverNonce = r;
            this.state = State.SERVER_FIRST_RCVD;
            this.complete = false;
            this.zeroAndClearExpectedV();
            return;
        }
        String data = params.get("data");
        if (data == null) {
            return;
        }
        String decoded = ScramScheme.b64ToString(data);
        Map<String, String> attrs = ScramScheme.parseAttrs(decoded);
        String err = attrs.get("e");
        if (err != null) {
            this.state = State.FAILED;
            if (err.isEmpty()) {
                throw new MalformedChallengeException("SCRAM server error attribute 'e' is empty");
            }
            throw new AuthenticationException("SCRAM server error: " + err);
        }
        String vB64 = attrs.get("v");
        if (vB64 == null) {
            return;
        }
        byte[] expected = this.expectedV;
        this.expectedV = null;
        byte[] vBytes = null;
        try {
            vBytes = B64D.decode(vB64);
            match = expected != null && MessageDigest.isEqual(expected, vBytes);
        }
        catch (IllegalArgumentException e) {
            match = false;
        }
        finally {
            ScramScheme.zero(vBytes);
            ScramScheme.zero(expected);
        }
        if (!match) {
            this.state = State.FAILED;
            throw new MalformedChallengeException("SCRAM server signature mismatch");
        }
        this.complete = true;
        this.state = State.COMPLETE;
    }

    @Override
    public boolean isChallengeComplete() {
        return this.complete || this.state == State.COMPLETE || this.state == State.FAILED;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public boolean isResponseReady(HttpHost host, CredentialsProvider credentialsProvider, HttpContext context) throws AuthenticationException {
        Args.notNull(credentialsProvider, "Credentials provider");
        HttpClientContext clientContext = HttpClientContext.cast(context);
        AuthScope scope = new AuthScope(host, this.realm, this.getName());
        Credentials creds = credentialsProvider.getCredentials(scope, clientContext);
        if (!(creds instanceof UsernamePasswordCredentials)) {
            return false;
        }
        UsernamePasswordCredentials up = (UsernamePasswordCredentials)creds;
        char[] passChars = up.getUserPassword() != null ? (char[])up.getUserPassword().clone() : null;
        try {
            String preppedUser = SaslPrep.INSTANCE.prepAsQueryString(up.getUserName());
            String preppedPassStr = SaslPrep.INSTANCE.prepAsStoredString(passChars != null ? new String(passChars) : null);
            this.username = preppedUser;
            this.password = preppedPassStr != null ? preppedPassStr.toCharArray() : null;
        }
        catch (Exception e) {
            throw new AuthenticationException("SASLprep failed", e);
        }
        finally {
            if (passChars != null) {
                Arrays.fill(passChars, '\u0000');
            }
        }
        this.principal = new SimplePrincipal(this.username);
        switch (this.state) {
            case INIT: 
            case ANNOUNCED: 
            case SERVER_FIRST_RCVD: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String generateAuthResponse(HttpHost host, HttpRequest request, HttpContext context) throws AuthenticationException {
        switch (this.state) {
            case INIT: {
                if (this.username == null) {
                    this.state = State.FAILED;
                    throw new AuthenticationException("SCRAM state out of sequence: INIT without credentials");
                }
                return this.buildClientFirst();
            }
            case ANNOUNCED: {
                return this.buildClientFirst();
            }
            case SERVER_FIRST_RCVD: {
                return this.buildClientFinalAndExpectV();
            }
        }
        this.state = State.FAILED;
        throw new AuthenticationException("SCRAM state out of sequence: " + (Object)((Object)this.state));
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    private String buildClientFirst() {
        this.clientNonce = this.genNonce();
        String escUser = ScramScheme.escapeUser(this.username);
        this.clientFirstBare = "n=" + escUser + ",r=" + this.clientNonce;
        String data = ScramScheme.stringToB64(GS2_HEADER + this.clientFirstBare);
        StringBuilder sb = new StringBuilder(64);
        sb.append("SCRAM-SHA-256").append(' ');
        if (this.realm != null) {
            sb.append("realm=").append(ScramScheme.quoteParam(this.realm)).append(", ");
        }
        sb.append("data=").append(ScramScheme.quoteParam(data));
        this.state = State.CLIENT_FIRST_SENT;
        this.complete = false;
        this.zeroAndClearExpectedV();
        return sb.toString();
    }

    private String buildClientFinalAndExpectV() throws AuthenticationException {
        String string;
        byte[] serverSignature;
        byte[] serverKey;
        byte[] clientProof;
        byte[] clientSignature;
        byte[] storedKey;
        byte[] clientKey;
        byte[] salted;
        block6: {
            salted = null;
            clientKey = null;
            storedKey = null;
            clientSignature = null;
            clientProof = null;
            serverKey = null;
            serverSignature = null;
            try {
                String clientFinalNoProof = "c=biws,r=" + this.serverNonce;
                String authMessage = this.clientFirstBare + "," + this.serverFirstRaw + "," + clientFinalNoProof;
                salted = ScramScheme.hiPBKDF2(this.password, this.salt, this.iterations, 32);
                clientKey = ScramScheme.hmac(salted, "Client Key");
                storedKey = ScramScheme.sha256(clientKey);
                clientSignature = ScramScheme.hmac(storedKey, authMessage);
                clientProof = ScramScheme.xor(clientKey, clientSignature);
                String pB64 = B64.encodeToString(clientProof);
                serverKey = ScramScheme.hmac(salted, "Server Key");
                serverSignature = ScramScheme.hmac(serverKey, authMessage);
                this.zeroAndClearExpectedV();
                this.expectedV = (byte[])serverSignature.clone();
                String clientFinal = clientFinalNoProof + ",p=" + pB64;
                String data = ScramScheme.stringToB64(clientFinal);
                StringBuilder sb = new StringBuilder(64);
                sb.append("SCRAM-SHA-256").append(' ');
                if (this.sid != null) {
                    sb.append("sid=").append(ScramScheme.quoteParam(this.sid)).append(", ");
                }
                sb.append("data=").append(ScramScheme.quoteParam(data));
                this.state = State.CLIENT_FINAL_SENT;
                this.complete = false;
                string = sb.toString();
                if (this.password == null) break block6;
            }
            catch (GeneralSecurityException e) {
                try {
                    this.state = State.FAILED;
                    throw new AuthenticationException("SCRAM crypto failure", e);
                }
                catch (Throwable throwable) {
                    if (this.password != null) {
                        Arrays.fill(this.password, '\u0000');
                        this.password = null;
                    }
                    ScramScheme.zero(salted);
                    ScramScheme.zero(clientKey);
                    ScramScheme.zero(storedKey);
                    ScramScheme.zero(clientSignature);
                    ScramScheme.zero(clientProof);
                    ScramScheme.zero(serverKey);
                    ScramScheme.zero(serverSignature);
                    throw throwable;
                }
            }
            Arrays.fill(this.password, '\u0000');
            this.password = null;
        }
        ScramScheme.zero(salted);
        ScramScheme.zero(clientKey);
        ScramScheme.zero(storedKey);
        ScramScheme.zero(clientSignature);
        ScramScheme.zero(clientProof);
        ScramScheme.zero(serverKey);
        ScramScheme.zero(serverSignature);
        return string;
    }

    private static void zero(byte[] a) {
        if (a != null) {
            Arrays.fill(a, (byte)0);
        }
    }

    private void zeroAndClearExpectedV() {
        if (this.expectedV != null) {
            ScramScheme.zero(this.expectedV);
            this.expectedV = null;
        }
    }

    private static Map<String, String> toParamMap(List<NameValuePair> pairs) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (pairs != null) {
            for (NameValuePair p : pairs) {
                if (p == null || p.getName() == null) continue;
                m.put(p.getName().toLowerCase(Locale.ROOT), p.getValue());
            }
        }
        return m;
    }

    private static Map<String, String> parseAttrs(String s) throws MalformedChallengeException {
        LinkedHashMap<String, String> out = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < s.length()) {
            if (i + 2 > s.length() || s.charAt(i + 1) != '=') {
                throw new MalformedChallengeException("Bad SCRAM attr at index " + i);
            }
            String k = String.valueOf(s.charAt(i));
            i += 2;
            StringBuilder v = new StringBuilder();
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c == ',') {
                    ++i;
                    break;
                }
                if (c == '=' && i + 2 < s.length()) {
                    String esc = s.substring(i, i + 3);
                    if ("=2C".equalsIgnoreCase(esc)) {
                        v.append(',');
                        i += 3;
                        continue;
                    }
                    if ("=3D".equalsIgnoreCase(esc)) {
                        v.append('=');
                        i += 3;
                        continue;
                    }
                }
                v.append(c);
                ++i;
            }
            out.put(k, v.toString());
        }
        return out;
    }

    private String genNonce() {
        byte[] buf = new byte[16];
        this.secureRandom.nextBytes(buf);
        StringBuilder sb = new StringBuilder(buf.length * 2);
        for (byte b : buf) {
            int v = b & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString();
    }

    private static String escapeUser(String user) {
        if (user == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(user.length() + 8);
        for (int i = 0; i < user.length(); ++i) {
            char c = user.charAt(i);
            if (c == ',') {
                sb.append("=2C");
                continue;
            }
            if (c == '=') {
                sb.append("=3D");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String quoteParam(String v) {
        if (v == null) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder(v.length() + 2);
        sb.append('\"');
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            if (c == '\\' || c == '\"') {
                sb.append('\\');
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    private static byte[] hiPBKDF2(char[] password, byte[] salt, int iterations, int dkLen) throws GeneralSecurityException {
        PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, dkLen * 8);
        return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256").generateSecret(spec).getEncoded();
    }

    private static byte[] hmac(byte[] key, String msg) throws GeneralSecurityException {
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(key, "HmacSHA256"));
        return mac.doFinal(msg.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] sha256(byte[] in) throws GeneralSecurityException {
        return MessageDigest.getInstance("SHA-256").digest(in);
    }

    private static byte[] xor(byte[] a, byte[] b) {
        int len = Math.min(a.length, b.length);
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            out[i] = (byte)(a[i] ^ b[i]);
        }
        return out;
    }

    private static String stringToB64(String s) {
        return B64.encodeToString(s.getBytes(StandardCharsets.UTF_8));
    }

    private static String b64ToString(String b64) throws MalformedChallengeException {
        try {
            return new String(B64D.decode(b64), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedChallengeException("Bad base64 'data' value", e);
        }
    }

    private static final class SimplePrincipal
    implements Principal {
        private final String name;

        private SimplePrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private static enum State {
        INIT,
        ANNOUNCED,
        CLIENT_FIRST_SENT,
        SERVER_FIRST_RCVD,
        CLIENT_FINAL_SENT,
        COMPLETE,
        FAILED;

    }
}

