/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.io.IOException;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.priority.PriorityFormatter;
import org.apache.hc.core5.http2.priority.PriorityValue;
import org.apache.hc.core5.util.Args;

@Experimental
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class H2RequestPriority
implements HttpRequestInterceptor {
    public static final H2RequestPriority INSTANCE = new H2RequestPriority();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        HttpClientContext httpClientContext = HttpClientContext.cast(context);
        ProtocolVersion pv = httpClientContext.getProtocolVersion();
        if (pv.compareToVersion(HttpVersion.HTTP_2) < 0) {
            return;
        }
        Header existing = request.getFirstHeader("Priority");
        if (existing != null) {
            return;
        }
        RequestConfig requestConfig = httpClientContext.getRequestConfigOrDefault();
        PriorityValue pri = requestConfig.getH2Priority();
        if (pri == null || PriorityValue.defaults().equals(pri)) {
            return;
        }
        request.addHeader(PriorityFormatter.formatHeader(pri));
    }
}

