/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http2.H2MessageConverter;
import org.apache.hc.core5.http2.impl.FieldValidationSupport;
import org.apache.hc.core5.util.TextUtils;

public class DefaultH2ResponseConverter
implements H2MessageConverter<HttpResponse> {
    public static final DefaultH2ResponseConverter INSTANCE = new DefaultH2ResponseConverter();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public HttpResponse convert(List<Header> headers) throws HttpException {
        int statusCode;
        String statusText = null;
        ArrayList<Header> messageHeaders = new ArrayList<Header>();
        int cookieCount = 0;
        for (int i = 0; i < headers.size(); ++i) {
            Header header = headers.get(i);
            String name = header.getName();
            String value = header.getValue();
            if (name.startsWith(":")) {
                if (!FieldValidationSupport.isNameLowerCaseValid(name, 1, name.length())) {
                    throw new ProtocolException("Header name '%s' is invalid", name);
                }
                if (!messageHeaders.isEmpty()) {
                    throw new ProtocolException("Invalid sequence of headers (pseudo-headers must precede message headers)");
                }
                if (!name.equals(":status")) throw new ProtocolException("Unsupported response header '%s'", name);
                if (statusText != null) {
                    throw new ProtocolException("Multiple '%s' response headers are illegal", name);
                }
                statusText = value;
            } else {
                if (!FieldValidationSupport.isNameLowerCaseValid(name)) {
                    throw new ProtocolException("Header name '%s' is invalid", name);
                }
                if (name.equalsIgnoreCase("Cookie")) {
                    ++cookieCount;
                }
                messageHeaders.add(header);
            }
            if (FieldValidationSupport.isValueValid(value)) continue;
            throw new ProtocolException("Header value is invalid");
        }
        if (statusText == null) {
            throw new ProtocolException("Mandatory response header '%s' not found", ":status");
        }
        try {
            statusCode = Integer.parseInt(statusText);
        }
        catch (NumberFormatException ex) {
            throw new ProtocolException("Invalid response status: " + statusText);
        }
        BasicHttpResponse response = new BasicHttpResponse(statusCode, null);
        response.setVersion(HttpVersion.HTTP_2);
        for (int i = 0; i < messageHeaders.size(); ++i) {
            response.addHeader((Header)messageHeaders.get(i));
        }
        if (cookieCount <= 1) return response;
        StringBuilder buf = new StringBuilder();
        Iterator<Header> it = response.headerIterator("Cookie");
        while (it.hasNext()) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            Header cookie = it.next();
            buf.append(cookie.getValue());
            it.remove();
        }
        response.setHeader("Cookie".toLowerCase(Locale.ROOT), buf.toString());
        return response;
    }

    @Override
    public List<Header> convert(HttpResponse message) throws HttpException {
        int code = message.getCode();
        if (code < 100 || code >= 600) {
            throw new ProtocolException("Response status %s is invalid", code);
        }
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(new BasicHeader(":status", Integer.toString(code), false));
        Iterator<Header> it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.next();
            String name = header.getName();
            String value = header.getValue();
            if (!FieldValidationSupport.isNameValid(name)) {
                throw new ProtocolException("Header name '%s' is invalid", name);
            }
            if (!FieldValidationSupport.isValueValid(value)) {
                throw new ProtocolException("Header value is invalid");
            }
            headers.add(new BasicHeader(TextUtils.toLowerCase(name), value));
        }
        return headers;
    }
}

