/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.priority;

import java.util.Locale;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.http2.priority.PriorityValue;
import org.apache.hc.core5.util.Tokenizer;

@Internal
public final class PriorityParser {
    private static final Tokenizer TK = Tokenizer.INSTANCE;
    private static final Tokenizer.Delimiter KEY_DELIMS = Tokenizer.delimiters('=', ',', ';');
    private static final Tokenizer.Delimiter VALUE_DELIMS = Tokenizer.delimiters(',', ';');

    private PriorityParser() {
    }

    public static PriorityValue parse(Header header) {
        if (header == null) {
            return PriorityValue.defaults();
        }
        PriorityValue[] out = new PriorityValue[1];
        MessageSupport.parseHeader(header, (seq, cur) -> {
            out[0] = PriorityParser.parse(seq, cur);
        });
        return out[0] != null ? out[0] : PriorityValue.defaults();
    }

    public static PriorityValue parse(String headerValue) {
        if (headerValue == null || headerValue.isEmpty()) {
            return PriorityValue.defaults();
        }
        ParserCursor c = new ParserCursor(0, headerValue.length());
        return PriorityParser.parse(headerValue, c);
    }

    public static PriorityValue parse(CharSequence src, ParserCursor cursor) {
        int urgency = 3;
        boolean incremental = false;
        while (!cursor.atEnd()) {
            TK.skipWhiteSpace(src, cursor);
            if (cursor.atEnd()) break;
            String rawKey = TK.parseToken(src, (Tokenizer.Cursor)cursor, KEY_DELIMS);
            if (rawKey == null || rawKey.isEmpty()) {
                PriorityParser.skipToNextItem(src, cursor);
                continue;
            }
            String key = rawKey.toLowerCase(Locale.ROOT);
            TK.skipWhiteSpace(src, cursor);
            char ch = PriorityParser.currentChar(src, cursor);
            if (ch == '=') {
                cursor.updatePos(cursor.getPos() + 1);
                TK.skipWhiteSpace(src, cursor);
                if ("u".equals(key)) {
                    String numTok = TK.parseToken(src, (Tokenizer.Cursor)cursor, VALUE_DELIMS);
                    Integer u = PriorityParser.safeParseInt(numTok);
                    if (u != null && u >= 0 && u <= 7) {
                        urgency = u;
                    }
                } else if ("i".equals(key)) {
                    char b = PriorityParser.currentChar(src, cursor);
                    if (b == '?') {
                        cursor.updatePos(cursor.getPos() + 1);
                        char v = PriorityParser.currentChar(src, cursor);
                        if (v == '1') {
                            incremental = true;
                            cursor.updatePos(cursor.getPos() + 1);
                        } else if (v == '0') {
                            incremental = false;
                            cursor.updatePos(cursor.getPos() + 1);
                        }
                    } else {
                        String tok = TK.parseToken(src, (Tokenizer.Cursor)cursor, VALUE_DELIMS);
                        if ("1".equals(tok)) {
                            incremental = true;
                        } else if ("0".equals(tok)) {
                            incremental = false;
                        }
                    }
                } else {
                    TK.parseToken(src, (Tokenizer.Cursor)cursor, VALUE_DELIMS);
                }
                PriorityParser.skipParamsThenNextItem(src, cursor);
                continue;
            }
            if ("i".equals(key)) {
                incremental = true;
            }
            PriorityParser.skipParamsThenNextItem(src, cursor);
        }
        return PriorityValue.of(urgency, incremental);
    }

    private static char currentChar(CharSequence buf, Tokenizer.Cursor c) {
        return c.atEnd() ? (char)'\u0000' : buf.charAt(c.getPos());
    }

    private static Integer safeParseInt(String s) {
        if (s == null) {
            return null;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    private static void skipToNextItem(CharSequence buf, Tokenizer.Cursor c) {
        while (!c.atEnd()) {
            char ch = buf.charAt(c.getPos());
            c.updatePos(c.getPos() + 1);
            if (ch != ',') continue;
            break;
        }
    }

    private static void skipParamsThenNextItem(CharSequence buf, Tokenizer.Cursor c) {
        int pos;
        char ch;
        while (!c.atEnd() && (ch = buf.charAt(pos = c.getPos())) == ';') {
            c.updatePos(pos + 1);
            TK.parseToken(buf, c, VALUE_DELIMS);
        }
        while (!c.atEnd()) {
            char ch2 = buf.charAt(c.getPos());
            if (ch2 == ',') {
                c.updatePos(c.getPos() + 1);
                break;
            }
            c.updatePos(c.getPos() + 1);
        }
    }
}

