/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AbstractStreamingClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.OutputStreamPublisher;
import org.springframework.http.client.ReactorClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;

final class ReactorClientHttpRequest
extends AbstractStreamingClientHttpRequest {
    private final HttpClient httpClient;
    private final HttpMethod method;
    private final URI uri;
    private final Executor executor;
    @Nullable
    private final Duration exchangeTimeout;

    public ReactorClientHttpRequest(HttpClient httpClient, HttpMethod method, URI uri) {
        this(httpClient, method, uri, null);
    }

    public ReactorClientHttpRequest(HttpClient httpClient, HttpMethod method, URI uri, @Nullable Executor executor) {
        this(httpClient, method, uri, executor, null);
    }

    ReactorClientHttpRequest(HttpClient httpClient, HttpMethod method, URI uri, @Nullable Executor executor, @Nullable Duration exchangeTimeout) {
        this.httpClient = httpClient;
        this.method = method;
        this.uri = uri;
        this.executor = executor != null ? executor : arg_0 -> ((Scheduler)Schedulers.boundedElastic()).schedule(arg_0);
        this.exchangeTimeout = exchangeTimeout;
    }

    @Deprecated(since="6.2", forRemoval=true)
    public ReactorClientHttpRequest(HttpClient httpClient, URI uri, HttpMethod method, @Nullable Duration exchangeTimeout, @Nullable Duration readTimeout) {
        this(httpClient, method, uri, null, exchangeTimeout);
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body2) throws IOException {
        HttpClient.RequestSender sender = this.httpClient.request(io.netty.handler.codec.http.HttpMethod.valueOf((String)this.method.name()));
        sender = this.uri.isAbsolute() ? (HttpClient.RequestSender)sender.uri(this.uri) : (HttpClient.RequestSender)sender.uri(this.uri.toString());
        try {
            ReactorClientHttpResponse clientResponse;
            Mono mono = sender.send((request, outbound) -> this.send(headers, body2, (HttpClientRequest)request, (NettyOutbound)outbound)).responseConnection((response, conn) -> Mono.just((Object)new ReactorClientHttpResponse((HttpClientResponse)response, (Connection)conn))).next();
            ReactorClientHttpResponse reactorClientHttpResponse = clientResponse = this.exchangeTimeout != null ? (ReactorClientHttpResponse)mono.block(this.exchangeTimeout) : (ReactorClientHttpResponse)mono.block();
            if (clientResponse == null) {
                throw new IOException("HTTP exchange resulted in no result");
            }
            return clientResponse;
        }
        catch (RuntimeException ex) {
            throw ReactorClientHttpRequest.convertException(ex);
        }
    }

    private Publisher<Void> send(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body2, HttpClientRequest request, NettyOutbound outbound) {
        headers.forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(key, value) -> request.requestHeaders().set(key, (Iterable)value)));
        if (body2 == null) {
            return Mono.empty();
        }
        return outbound.send(FlowAdapters.toPublisher(new OutputStreamPublisher<ByteBuf>(os -> body2.writeTo(StreamUtils.nonClosing(os)), new ByteBufMapper(outbound), this.executor, null)));
    }

    static IOException convertException(RuntimeException ex) {
        UncheckedIOException uioEx;
        IOException ioEx;
        Throwable cause = ex.getCause();
        if (cause instanceof IOException) {
            IOException ioEx2 = (IOException)cause;
            return ioEx2;
        }
        if (cause instanceof UncheckedIOException && (ioEx = (uioEx = (UncheckedIOException)cause).getCause()) != null) {
            return ioEx;
        }
        return new IOException(ex.getMessage(), cause != null ? cause : ex);
    }

    private static final class ByteBufMapper
    implements OutputStreamPublisher.ByteMapper<ByteBuf> {
        private final ByteBufAllocator allocator;

        public ByteBufMapper(NettyOutbound outbound) {
            this.allocator = outbound.alloc();
        }

        @Override
        public ByteBuf map(int b) {
            ByteBuf buf = this.allocator.buffer(1);
            buf.writeByte(b);
            return buf;
        }

        @Override
        public ByteBuf map(byte[] b, int off, int len) {
            ByteBuf buf = this.allocator.buffer(len);
            buf.writeBytes(b, off, len);
            return buf;
        }
    }
}

