/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import java.util.List;
import org.springframework.http.server.PathContainer;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.pattern.PathElement;
import org.springframework.web.util.pattern.PathPattern;

class CaptureSegmentsPathElement
extends PathElement {
    private final String variableName;

    CaptureSegmentsPathElement(int pos, char[] captureDescriptor, char separator) {
        super(pos, separator);
        this.variableName = new String(captureDescriptor, 2, captureDescriptor.length - 3);
    }

    @Override
    public boolean matches(int pathIndex, PathPattern.MatchingContext matchingContext) {
        if (pathIndex == 0 && this.next != null) {
            for (int endPathIndex = pathIndex; endPathIndex < matchingContext.pathLength; ++endPathIndex) {
                if (!this.next.matches(endPathIndex, matchingContext)) continue;
                this.collectParameters(matchingContext, pathIndex, endPathIndex);
                return true;
            }
            return false;
        }
        if (pathIndex < matchingContext.pathLength && !matchingContext.isSeparator(pathIndex)) {
            return false;
        }
        if (matchingContext.determineRemainingPath) {
            matchingContext.remainingPathIndex = matchingContext.pathLength;
        }
        this.collectParameters(matchingContext, pathIndex, matchingContext.pathLength);
        return true;
    }

    private void collectParameters(PathPattern.MatchingContext matchingContext, int pathIndex, int endPathIndex) {
        if (matchingContext.extractingVariables) {
            LinkedMultiValueMap<String, String> parametersCollector = NO_PARAMETERS;
            for (int i = pathIndex; i < endPathIndex; ++i) {
                PathContainer.PathSegment pathSegment;
                MultiValueMap<String, String> parameters;
                PathContainer.Element element = matchingContext.pathElements.get(i);
                if (!(element instanceof PathContainer.PathSegment) || (parameters = (pathSegment = (PathContainer.PathSegment)element).parameters()).isEmpty()) continue;
                if (parametersCollector == NO_PARAMETERS) {
                    parametersCollector = new LinkedMultiValueMap<String, String>();
                }
                parametersCollector.addAll(parameters);
            }
            matchingContext.set(this.variableName, this.pathToString(pathIndex, endPathIndex, matchingContext.pathElements), (MultiValueMap<String, String>)parametersCollector);
        }
    }

    private String pathToString(int fromSegment, int toSegment, List<PathContainer.Element> pathElements) {
        StringBuilder sb = new StringBuilder();
        int max = toSegment;
        for (int i = fromSegment; i < max; ++i) {
            PathContainer.Element element = pathElements.get(i);
            if (element instanceof PathContainer.PathSegment) {
                PathContainer.PathSegment pathSegment = (PathContainer.PathSegment)element;
                sb.append(pathSegment.valueToMatch());
                continue;
            }
            sb.append(element.value());
        }
        return sb.toString();
    }

    @Override
    public int getNormalizedLength() {
        return 1;
    }

    @Override
    public char[] getChars() {
        return ("/{*" + this.variableName + "}").toCharArray();
    }

    @Override
    public int getWildcardCount() {
        return 0;
    }

    @Override
    public int getCaptureCount() {
        return 1;
    }

    public String toString() {
        return "CaptureSegments(/{*" + this.variableName + "})";
    }
}

